/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetSubnetsRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<SetSubnetsRequest.Builder, SetSubnetsRequest> {
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetSubnetsRequest::loadBalancerArn)).setter(setter(Builder::loadBalancerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").build()).build();

    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(SetSubnetsRequest::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SubnetMapping>> SUBNET_MAPPINGS_FIELD = SdkField
            .<List<SubnetMapping>> builder(MarshallingType.LIST)
            .getter(getter(SetSubnetsRequest::subnetMappings))
            .setter(setter(Builder::subnetMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubnetMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubnetMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_ARN_FIELD,
            SUBNETS_FIELD, SUBNET_MAPPINGS_FIELD));

    private final String loadBalancerArn;

    private final List<String> subnets;

    private final List<SubnetMapping> subnetMappings;

    private SetSubnetsRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerArn = builder.loadBalancerArn;
        this.subnets = builder.subnets;
        this.subnetMappings = builder.subnetMappings;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the load balancer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the load balancer.
     */
    public String loadBalancerArn() {
        return loadBalancerArn;
    }

    /**
     * <p>
     * The IDs of the public subnets. You must specify subnets from at least two Availability Zones. You can specify
     * only one subnet per Availability Zone. You must specify either subnets or subnet mappings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the public subnets. You must specify subnets from at least two Availability Zones. You can
     *         specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.
     */
    public List<String> subnets() {
        return subnets;
    }

    /**
     * <p>
     * The IDs of the public subnets. You must specify subnets from at least two Availability Zones. You can specify
     * only one subnet per Availability Zone. You must specify either subnets or subnet mappings.
     * </p>
     * <p>
     * You cannot specify Elastic IP addresses for your subnets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the public subnets. You must specify subnets from at least two Availability Zones. You can
     *         specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
     *         <p>
     *         You cannot specify Elastic IP addresses for your subnets.
     */
    public List<SubnetMapping> subnetMappings() {
        return subnetMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(subnets());
        hashCode = 31 * hashCode + Objects.hashCode(subnetMappings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSubnetsRequest)) {
            return false;
        }
        SetSubnetsRequest other = (SetSubnetsRequest) obj;
        return Objects.equals(loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(subnets(), other.subnets())
                && Objects.equals(subnetMappings(), other.subnetMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SetSubnetsRequest").add("LoadBalancerArn", loadBalancerArn()).add("Subnets", subnets())
                .add("SubnetMappings", subnetMappings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerArn":
            return Optional.ofNullable(clazz.cast(loadBalancerArn()));
        case "Subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "SubnetMappings":
            return Optional.ofNullable(clazz.cast(subnetMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetSubnetsRequest, T> g) {
        return obj -> g.apply((SetSubnetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo, CopyableBuilder<Builder, SetSubnetsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the load balancer.
         * </p>
         * 
         * @param loadBalancerArn
         *        The Amazon Resource Name (ARN) of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerArn(String loadBalancerArn);

        /**
         * <p>
         * The IDs of the public subnets. You must specify subnets from at least two Availability Zones. You can specify
         * only one subnet per Availability Zone. You must specify either subnets or subnet mappings.
         * </p>
         * 
         * @param subnets
         *        The IDs of the public subnets. You must specify subnets from at least two Availability Zones. You can
         *        specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * The IDs of the public subnets. You must specify subnets from at least two Availability Zones. You can specify
         * only one subnet per Availability Zone. You must specify either subnets or subnet mappings.
         * </p>
         * 
         * @param subnets
         *        The IDs of the public subnets. You must specify subnets from at least two Availability Zones. You can
         *        specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * The IDs of the public subnets. You must specify subnets from at least two Availability Zones. You can specify
         * only one subnet per Availability Zone. You must specify either subnets or subnet mappings.
         * </p>
         * <p>
         * You cannot specify Elastic IP addresses for your subnets.
         * </p>
         * 
         * @param subnetMappings
         *        The IDs of the public subnets. You must specify subnets from at least two Availability Zones. You can
         *        specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
         *        <p>
         *        You cannot specify Elastic IP addresses for your subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetMappings(Collection<SubnetMapping> subnetMappings);

        /**
         * <p>
         * The IDs of the public subnets. You must specify subnets from at least two Availability Zones. You can specify
         * only one subnet per Availability Zone. You must specify either subnets or subnet mappings.
         * </p>
         * <p>
         * You cannot specify Elastic IP addresses for your subnets.
         * </p>
         * 
         * @param subnetMappings
         *        The IDs of the public subnets. You must specify subnets from at least two Availability Zones. You can
         *        specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p>
         *        <p>
         *        You cannot specify Elastic IP addresses for your subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetMappings(SubnetMapping... subnetMappings);

        /**
         * <p>
         * The IDs of the public subnets. You must specify subnets from at least two Availability Zones. You can specify
         * only one subnet per Availability Zone. You must specify either subnets or subnet mappings.
         * </p>
         * <p>
         * You cannot specify Elastic IP addresses for your subnets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SubnetMapping>.Builder} avoiding the need
         * to create one manually via {@link List<SubnetMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SubnetMapping>.Builder#build()} is called immediately and
         * its result is passed to {@link #subnetMappings(List<SubnetMapping>)}.
         * 
         * @param subnetMappings
         *        a consumer that will call methods on {@link List<SubnetMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnetMappings(List<SubnetMapping>)
         */
        Builder subnetMappings(Consumer<SubnetMapping.Builder>... subnetMappings);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String loadBalancerArn;

        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<SubnetMapping> subnetMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SetSubnetsRequest model) {
            super(model);
            loadBalancerArn(model.loadBalancerArn);
            subnets(model.subnets);
            subnetMappings(model.subnetMappings);
        }

        public final String getLoadBalancerArn() {
            return loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        public final Collection<String> getSubnets() {
            return subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        public final Collection<SubnetMapping.Builder> getSubnetMappings() {
            return subnetMappings != null ? subnetMappings.stream().map(SubnetMapping::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder subnetMappings(Collection<SubnetMapping> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copy(subnetMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetMappings(SubnetMapping... subnetMappings) {
            subnetMappings(Arrays.asList(subnetMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetMappings(Consumer<SubnetMapping.Builder>... subnetMappings) {
            subnetMappings(Stream.of(subnetMappings).map(c -> SubnetMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSubnetMappings(Collection<SubnetMapping.BuilderImpl> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copyFromBuilder(subnetMappings);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetSubnetsRequest build() {
            return new SetSubnetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
