/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetDescription.Builder, TargetDescription> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TargetDescription::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TargetDescription::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TargetDescription::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PORT_FIELD,
            AVAILABILITY_ZONE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Integer port;

    private final String availabilityZone;

    private TargetDescription(BuilderImpl builder) {
        this.id = builder.id;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
    }

    /**
     * <p>
     * The ID of the target. If the target type of the target group is <code>instance</code>, specify an instance ID. If
     * the target type is <code>ip</code>, specify an IP address. If the target type is <code>lambda</code>, specify the
     * ARN of the Lambda function.
     * </p>
     * 
     * @return The ID of the target. If the target type of the target group is <code>instance</code>, specify an
     *         instance ID. If the target type is <code>ip</code>, specify an IP address. If the target type is
     *         <code>lambda</code>, specify the ARN of the Lambda function.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The port on which the target is listening.
     * </p>
     * 
     * @return The port on which the target is listening.
     */
    public Integer port() {
        return port;
    }

    /**
     * <p>
     * An Availability Zone or <code>all</code>. This determines whether the target receives traffic from the load
     * balancer nodes in the specified Availability Zone or from all enabled Availability Zones for the load balancer.
     * </p>
     * <p>
     * This parameter is not supported if the target type of the target group is <code>instance</code>.
     * </p>
     * <p>
     * If the target type is <code>ip</code> and the IP address is in a subnet of the VPC for the target group, the
     * Availability Zone is automatically detected and this parameter is optional. If the IP address is outside the VPC,
     * this parameter is required.
     * </p>
     * <p>
     * With an Application Load Balancer, if the target type is <code>ip</code> and the IP address is outside the VPC
     * for the target group, the only supported value is <code>all</code>.
     * </p>
     * <p>
     * If the target type is <code>lambda</code>, this parameter is optional and the only supported value is
     * <code>all</code>.
     * </p>
     * 
     * @return An Availability Zone or <code>all</code>. This determines whether the target receives traffic from the
     *         load balancer nodes in the specified Availability Zone or from all enabled Availability Zones for the
     *         load balancer.</p>
     *         <p>
     *         This parameter is not supported if the target type of the target group is <code>instance</code>.
     *         </p>
     *         <p>
     *         If the target type is <code>ip</code> and the IP address is in a subnet of the VPC for the target group,
     *         the Availability Zone is automatically detected and this parameter is optional. If the IP address is
     *         outside the VPC, this parameter is required.
     *         </p>
     *         <p>
     *         With an Application Load Balancer, if the target type is <code>ip</code> and the IP address is outside
     *         the VPC for the target group, the only supported value is <code>all</code>.
     *         </p>
     *         <p>
     *         If the target type is <code>lambda</code>, this parameter is optional and the only supported value is
     *         <code>all</code>.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetDescription)) {
            return false;
        }
        TargetDescription other = (TargetDescription) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(port(), other.port())
                && Objects.equals(availabilityZone(), other.availabilityZone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TargetDescription").add("Id", id()).add("Port", port())
                .add("AvailabilityZone", availabilityZone()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetDescription, T> g) {
        return obj -> g.apply((TargetDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetDescription> {
        /**
         * <p>
         * The ID of the target. If the target type of the target group is <code>instance</code>, specify an instance
         * ID. If the target type is <code>ip</code>, specify an IP address. If the target type is <code>lambda</code>,
         * specify the ARN of the Lambda function.
         * </p>
         * 
         * @param id
         *        The ID of the target. If the target type of the target group is <code>instance</code>, specify an
         *        instance ID. If the target type is <code>ip</code>, specify an IP address. If the target type is
         *        <code>lambda</code>, specify the ARN of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The port on which the target is listening.
         * </p>
         * 
         * @param port
         *        The port on which the target is listening.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * An Availability Zone or <code>all</code>. This determines whether the target receives traffic from the load
         * balancer nodes in the specified Availability Zone or from all enabled Availability Zones for the load
         * balancer.
         * </p>
         * <p>
         * This parameter is not supported if the target type of the target group is <code>instance</code>.
         * </p>
         * <p>
         * If the target type is <code>ip</code> and the IP address is in a subnet of the VPC for the target group, the
         * Availability Zone is automatically detected and this parameter is optional. If the IP address is outside the
         * VPC, this parameter is required.
         * </p>
         * <p>
         * With an Application Load Balancer, if the target type is <code>ip</code> and the IP address is outside the
         * VPC for the target group, the only supported value is <code>all</code>.
         * </p>
         * <p>
         * If the target type is <code>lambda</code>, this parameter is optional and the only supported value is
         * <code>all</code>.
         * </p>
         * 
         * @param availabilityZone
         *        An Availability Zone or <code>all</code>. This determines whether the target receives traffic from the
         *        load balancer nodes in the specified Availability Zone or from all enabled Availability Zones for the
         *        load balancer.</p>
         *        <p>
         *        This parameter is not supported if the target type of the target group is <code>instance</code>.
         *        </p>
         *        <p>
         *        If the target type is <code>ip</code> and the IP address is in a subnet of the VPC for the target
         *        group, the Availability Zone is automatically detected and this parameter is optional. If the IP
         *        address is outside the VPC, this parameter is required.
         *        </p>
         *        <p>
         *        With an Application Load Balancer, if the target type is <code>ip</code> and the IP address is outside
         *        the VPC for the target group, the only supported value is <code>all</code>.
         *        </p>
         *        <p>
         *        If the target type is <code>lambda</code>, this parameter is optional and the only supported value is
         *        <code>all</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Integer port;

        private String availabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetDescription model) {
            id(model.id);
            port(model.port);
            availabilityZone(model.availabilityZone);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public TargetDescription build() {
            return new TargetDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
