/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.SAMLOptionsOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdvancedSecurityOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdvancedSecurityOptions> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(AdvancedSecurityOptions.getter(AdvancedSecurityOptions::enabled)).setter(AdvancedSecurityOptions.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<Boolean> INTERNAL_USER_DATABASE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("InternalUserDatabaseEnabled").getter(AdvancedSecurityOptions.getter(AdvancedSecurityOptions::internalUserDatabaseEnabled)).setter(AdvancedSecurityOptions.setter(Builder::internalUserDatabaseEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternalUserDatabaseEnabled").build()}).build();
    private static final SdkField<SAMLOptionsOutput> SAML_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SAMLOptions").getter(AdvancedSecurityOptions.getter(AdvancedSecurityOptions::samlOptions)).setter(AdvancedSecurityOptions.setter(Builder::samlOptions)).constructor(SAMLOptionsOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, INTERNAL_USER_DATABASE_ENABLED_FIELD, SAML_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final Boolean internalUserDatabaseEnabled;
    private final SAMLOptionsOutput samlOptions;

    private AdvancedSecurityOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.internalUserDatabaseEnabled = builder.internalUserDatabaseEnabled;
        this.samlOptions = builder.samlOptions;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Boolean internalUserDatabaseEnabled() {
        return this.internalUserDatabaseEnabled;
    }

    public SAMLOptionsOutput samlOptions() {
        return this.samlOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.internalUserDatabaseEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.samlOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedSecurityOptions)) {
            return false;
        }
        AdvancedSecurityOptions other = (AdvancedSecurityOptions)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.internalUserDatabaseEnabled(), other.internalUserDatabaseEnabled()) && Objects.equals(this.samlOptions(), other.samlOptions());
    }

    public String toString() {
        return ToString.builder((String)"AdvancedSecurityOptions").add("Enabled", (Object)this.enabled()).add("InternalUserDatabaseEnabled", (Object)this.internalUserDatabaseEnabled()).add("SAMLOptions", (Object)this.samlOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "InternalUserDatabaseEnabled": {
                return Optional.ofNullable(clazz.cast(this.internalUserDatabaseEnabled()));
            }
            case "SAMLOptions": {
                return Optional.ofNullable(clazz.cast(this.samlOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdvancedSecurityOptions, T> g) {
        return obj -> g.apply((AdvancedSecurityOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Boolean internalUserDatabaseEnabled;
        private SAMLOptionsOutput samlOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AdvancedSecurityOptions model) {
            this.enabled(model.enabled);
            this.internalUserDatabaseEnabled(model.internalUserDatabaseEnabled);
            this.samlOptions(model.samlOptions);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Boolean getInternalUserDatabaseEnabled() {
            return this.internalUserDatabaseEnabled;
        }

        @Override
        public final Builder internalUserDatabaseEnabled(Boolean internalUserDatabaseEnabled) {
            this.internalUserDatabaseEnabled = internalUserDatabaseEnabled;
            return this;
        }

        public final void setInternalUserDatabaseEnabled(Boolean internalUserDatabaseEnabled) {
            this.internalUserDatabaseEnabled = internalUserDatabaseEnabled;
        }

        public final SAMLOptionsOutput.Builder getSamlOptions() {
            return this.samlOptions != null ? this.samlOptions.toBuilder() : null;
        }

        @Override
        public final Builder samlOptions(SAMLOptionsOutput samlOptions) {
            this.samlOptions = samlOptions;
            return this;
        }

        public final void setSamlOptions(SAMLOptionsOutput.BuilderImpl samlOptions) {
            this.samlOptions = samlOptions != null ? samlOptions.build() : null;
        }

        public AdvancedSecurityOptions build() {
            return new AdvancedSecurityOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdvancedSecurityOptions> {
        public Builder enabled(Boolean var1);

        public Builder internalUserDatabaseEnabled(Boolean var1);

        public Builder samlOptions(SAMLOptionsOutput var1);

        default public Builder samlOptions(Consumer<SAMLOptionsOutput.Builder> samlOptions) {
            return this.samlOptions((SAMLOptionsOutput)((SAMLOptionsOutput.Builder)SAMLOptionsOutput.builder().applyMutation(samlOptions)).build());
        }
    }
}

