/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceSoftwareOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceSoftwareOptions> {
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentVersion").getter(ServiceSoftwareOptions.getter(ServiceSoftwareOptions::currentVersion)).setter(ServiceSoftwareOptions.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersion").build()}).build();
    private static final SdkField<String> NEW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewVersion").getter(ServiceSoftwareOptions.getter(ServiceSoftwareOptions::newVersion)).setter(ServiceSoftwareOptions.setter(Builder::newVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewVersion").build()}).build();
    private static final SdkField<Boolean> UPDATE_AVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UpdateAvailable").getter(ServiceSoftwareOptions.getter(ServiceSoftwareOptions::updateAvailable)).setter(ServiceSoftwareOptions.setter(Builder::updateAvailable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateAvailable").build()}).build();
    private static final SdkField<Boolean> CANCELLABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Cancellable").getter(ServiceSoftwareOptions.getter(ServiceSoftwareOptions::cancellable)).setter(ServiceSoftwareOptions.setter(Builder::cancellable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cancellable").build()}).build();
    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateStatus").getter(ServiceSoftwareOptions.getter(ServiceSoftwareOptions::updateStatusAsString)).setter(ServiceSoftwareOptions.setter(Builder::updateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ServiceSoftwareOptions.getter(ServiceSoftwareOptions::description)).setter(ServiceSoftwareOptions.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> AUTOMATED_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AutomatedUpdateDate").getter(ServiceSoftwareOptions.getter(ServiceSoftwareOptions::automatedUpdateDate)).setter(ServiceSoftwareOptions.setter(Builder::automatedUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomatedUpdateDate").build()}).build();
    private static final SdkField<Boolean> OPTIONAL_DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OptionalDeployment").getter(ServiceSoftwareOptions.getter(ServiceSoftwareOptions::optionalDeployment)).setter(ServiceSoftwareOptions.setter(Builder::optionalDeployment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionalDeployment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_VERSION_FIELD, NEW_VERSION_FIELD, UPDATE_AVAILABLE_FIELD, CANCELLABLE_FIELD, UPDATE_STATUS_FIELD, DESCRIPTION_FIELD, AUTOMATED_UPDATE_DATE_FIELD, OPTIONAL_DEPLOYMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String currentVersion;
    private final String newVersion;
    private final Boolean updateAvailable;
    private final Boolean cancellable;
    private final String updateStatus;
    private final String description;
    private final Instant automatedUpdateDate;
    private final Boolean optionalDeployment;

    private ServiceSoftwareOptions(BuilderImpl builder) {
        this.currentVersion = builder.currentVersion;
        this.newVersion = builder.newVersion;
        this.updateAvailable = builder.updateAvailable;
        this.cancellable = builder.cancellable;
        this.updateStatus = builder.updateStatus;
        this.description = builder.description;
        this.automatedUpdateDate = builder.automatedUpdateDate;
        this.optionalDeployment = builder.optionalDeployment;
    }

    public final String currentVersion() {
        return this.currentVersion;
    }

    public final String newVersion() {
        return this.newVersion;
    }

    public final Boolean updateAvailable() {
        return this.updateAvailable;
    }

    public final Boolean cancellable() {
        return this.cancellable;
    }

    public final DeploymentStatus updateStatus() {
        return DeploymentStatus.fromValue(this.updateStatus);
    }

    public final String updateStatusAsString() {
        return this.updateStatus;
    }

    public final String description() {
        return this.description;
    }

    public final Instant automatedUpdateDate() {
        return this.automatedUpdateDate;
    }

    public final Boolean optionalDeployment() {
        return this.optionalDeployment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.newVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateAvailable());
        hashCode = 31 * hashCode + Objects.hashCode(this.cancellable());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.automatedUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionalDeployment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSoftwareOptions)) {
            return false;
        }
        ServiceSoftwareOptions other = (ServiceSoftwareOptions)obj;
        return Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.newVersion(), other.newVersion()) && Objects.equals(this.updateAvailable(), other.updateAvailable()) && Objects.equals(this.cancellable(), other.cancellable()) && Objects.equals(this.updateStatusAsString(), other.updateStatusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.automatedUpdateDate(), other.automatedUpdateDate()) && Objects.equals(this.optionalDeployment(), other.optionalDeployment());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceSoftwareOptions").add("CurrentVersion", (Object)this.currentVersion()).add("NewVersion", (Object)this.newVersion()).add("UpdateAvailable", (Object)this.updateAvailable()).add("Cancellable", (Object)this.cancellable()).add("UpdateStatus", (Object)this.updateStatusAsString()).add("Description", (Object)this.description()).add("AutomatedUpdateDate", (Object)this.automatedUpdateDate()).add("OptionalDeployment", (Object)this.optionalDeployment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "NewVersion": {
                return Optional.ofNullable(clazz.cast(this.newVersion()));
            }
            case "UpdateAvailable": {
                return Optional.ofNullable(clazz.cast(this.updateAvailable()));
            }
            case "Cancellable": {
                return Optional.ofNullable(clazz.cast(this.cancellable()));
            }
            case "UpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.updateStatusAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AutomatedUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.automatedUpdateDate()));
            }
            case "OptionalDeployment": {
                return Optional.ofNullable(clazz.cast(this.optionalDeployment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceSoftwareOptions, T> g) {
        return obj -> g.apply((ServiceSoftwareOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currentVersion;
        private String newVersion;
        private Boolean updateAvailable;
        private Boolean cancellable;
        private String updateStatus;
        private String description;
        private Instant automatedUpdateDate;
        private Boolean optionalDeployment;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceSoftwareOptions model) {
            this.currentVersion(model.currentVersion);
            this.newVersion(model.newVersion);
            this.updateAvailable(model.updateAvailable);
            this.cancellable(model.cancellable);
            this.updateStatus(model.updateStatus);
            this.description(model.description);
            this.automatedUpdateDate(model.automatedUpdateDate);
            this.optionalDeployment(model.optionalDeployment);
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        public final String getNewVersion() {
            return this.newVersion;
        }

        @Override
        public final Builder newVersion(String newVersion) {
            this.newVersion = newVersion;
            return this;
        }

        public final void setNewVersion(String newVersion) {
            this.newVersion = newVersion;
        }

        public final Boolean getUpdateAvailable() {
            return this.updateAvailable;
        }

        @Override
        public final Builder updateAvailable(Boolean updateAvailable) {
            this.updateAvailable = updateAvailable;
            return this;
        }

        public final void setUpdateAvailable(Boolean updateAvailable) {
            this.updateAvailable = updateAvailable;
        }

        public final Boolean getCancellable() {
            return this.cancellable;
        }

        @Override
        public final Builder cancellable(Boolean cancellable) {
            this.cancellable = cancellable;
            return this;
        }

        public final void setCancellable(Boolean cancellable) {
            this.cancellable = cancellable;
        }

        public final String getUpdateStatus() {
            return this.updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(DeploymentStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getAutomatedUpdateDate() {
            return this.automatedUpdateDate;
        }

        @Override
        public final Builder automatedUpdateDate(Instant automatedUpdateDate) {
            this.automatedUpdateDate = automatedUpdateDate;
            return this;
        }

        public final void setAutomatedUpdateDate(Instant automatedUpdateDate) {
            this.automatedUpdateDate = automatedUpdateDate;
        }

        public final Boolean getOptionalDeployment() {
            return this.optionalDeployment;
        }

        @Override
        public final Builder optionalDeployment(Boolean optionalDeployment) {
            this.optionalDeployment = optionalDeployment;
            return this;
        }

        public final void setOptionalDeployment(Boolean optionalDeployment) {
            this.optionalDeployment = optionalDeployment;
        }

        public ServiceSoftwareOptions build() {
            return new ServiceSoftwareOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceSoftwareOptions> {
        public Builder currentVersion(String var1);

        public Builder newVersion(String var1);

        public Builder updateAvailable(Boolean var1);

        public Builder cancellable(Boolean var1);

        public Builder updateStatus(String var1);

        public Builder updateStatus(DeploymentStatus var1);

        public Builder description(String var1);

        public Builder automatedUpdateDate(Instant var1);

        public Builder optionalDeployment(Boolean var1);
    }
}

