/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies Auto-Tune type and Auto-Tune action details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoTune implements SdkPojo, Serializable, ToCopyableBuilder<AutoTune.Builder, AutoTune> {
    private static final SdkField<String> AUTO_TUNE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoTuneType").getter(getter(AutoTune::autoTuneTypeAsString)).setter(setter(Builder::autoTuneType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTuneType").build()).build();

    private static final SdkField<AutoTuneDetails> AUTO_TUNE_DETAILS_FIELD = SdkField
            .<AutoTuneDetails> builder(MarshallingType.SDK_POJO).memberName("AutoTuneDetails")
            .getter(getter(AutoTune::autoTuneDetails)).setter(setter(Builder::autoTuneDetails))
            .constructor(AutoTuneDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTuneDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_TUNE_TYPE_FIELD,
            AUTO_TUNE_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String autoTuneType;

    private final AutoTuneDetails autoTuneDetails;

    private AutoTune(BuilderImpl builder) {
        this.autoTuneType = builder.autoTuneType;
        this.autoTuneDetails = builder.autoTuneDetails;
    }

    /**
     * <p>
     * Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoTuneType} will
     * return {@link AutoTuneType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoTuneTypeAsString}.
     * </p>
     * 
     * @return Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION.
     * @see AutoTuneType
     */
    public final AutoTuneType autoTuneType() {
        return AutoTuneType.fromValue(autoTuneType);
    }

    /**
     * <p>
     * Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoTuneType} will
     * return {@link AutoTuneType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoTuneTypeAsString}.
     * </p>
     * 
     * @return Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION.
     * @see AutoTuneType
     */
    public final String autoTuneTypeAsString() {
        return autoTuneType;
    }

    /**
     * <p>
     * Specifies details of the Auto-Tune action. See the <a
     * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
     * target="_blank">Developer Guide</a> for more information.
     * </p>
     * 
     * @return Specifies details of the Auto-Tune action. See the <a
     *         href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
     *         target="_blank">Developer Guide</a> for more information.
     */
    public final AutoTuneDetails autoTuneDetails() {
        return autoTuneDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoTuneTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoTuneDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoTune)) {
            return false;
        }
        AutoTune other = (AutoTune) obj;
        return Objects.equals(autoTuneTypeAsString(), other.autoTuneTypeAsString())
                && Objects.equals(autoTuneDetails(), other.autoTuneDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoTune").add("AutoTuneType", autoTuneTypeAsString()).add("AutoTuneDetails", autoTuneDetails())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoTuneType":
            return Optional.ofNullable(clazz.cast(autoTuneTypeAsString()));
        case "AutoTuneDetails":
            return Optional.ofNullable(clazz.cast(autoTuneDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoTune, T> g) {
        return obj -> g.apply((AutoTune) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoTune> {
        /**
         * <p>
         * Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION.
         * </p>
         * 
         * @param autoTuneType
         *        Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION.
         * @see AutoTuneType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoTuneType
         */
        Builder autoTuneType(String autoTuneType);

        /**
         * <p>
         * Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION.
         * </p>
         * 
         * @param autoTuneType
         *        Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION.
         * @see AutoTuneType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoTuneType
         */
        Builder autoTuneType(AutoTuneType autoTuneType);

        /**
         * <p>
         * Specifies details of the Auto-Tune action. See the <a
         * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
         * target="_blank">Developer Guide</a> for more information.
         * </p>
         * 
         * @param autoTuneDetails
         *        Specifies details of the Auto-Tune action. See the <a
         *        href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
         *        target="_blank">Developer Guide</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoTuneDetails(AutoTuneDetails autoTuneDetails);

        /**
         * <p>
         * Specifies details of the Auto-Tune action. See the <a
         * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
         * target="_blank">Developer Guide</a> for more information.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoTuneDetails.Builder} avoiding the need to
         * create one manually via {@link AutoTuneDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoTuneDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #autoTuneDetails(AutoTuneDetails)}.
         * 
         * @param autoTuneDetails
         *        a consumer that will call methods on {@link AutoTuneDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoTuneDetails(AutoTuneDetails)
         */
        default Builder autoTuneDetails(Consumer<AutoTuneDetails.Builder> autoTuneDetails) {
            return autoTuneDetails(AutoTuneDetails.builder().applyMutation(autoTuneDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String autoTuneType;

        private AutoTuneDetails autoTuneDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoTune model) {
            autoTuneType(model.autoTuneType);
            autoTuneDetails(model.autoTuneDetails);
        }

        public final String getAutoTuneType() {
            return autoTuneType;
        }

        @Override
        public final Builder autoTuneType(String autoTuneType) {
            this.autoTuneType = autoTuneType;
            return this;
        }

        @Override
        public final Builder autoTuneType(AutoTuneType autoTuneType) {
            this.autoTuneType(autoTuneType == null ? null : autoTuneType.toString());
            return this;
        }

        public final void setAutoTuneType(String autoTuneType) {
            this.autoTuneType = autoTuneType;
        }

        public final AutoTuneDetails.Builder getAutoTuneDetails() {
            return autoTuneDetails != null ? autoTuneDetails.toBuilder() : null;
        }

        @Override
        public final Builder autoTuneDetails(AutoTuneDetails autoTuneDetails) {
            this.autoTuneDetails = autoTuneDetails;
            return this;
        }

        public final void setAutoTuneDetails(AutoTuneDetails.BuilderImpl autoTuneDetails) {
            this.autoTuneDetails = autoTuneDetails != null ? autoTuneDetails.build() : null;
        }

        @Override
        public AutoTune build() {
            return new AutoTune(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
