/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of a reserved Elasticsearch instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedElasticsearchInstance implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedElasticsearchInstance.Builder, ReservedElasticsearchInstance> {
    private static final SdkField<String> RESERVATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservationName").getter(getter(ReservedElasticsearchInstance::reservationName))
            .setter(setter(Builder::reservationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationName").build()).build();

    private static final SdkField<String> RESERVED_ELASTICSEARCH_INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedElasticsearchInstanceId")
            .getter(getter(ReservedElasticsearchInstance::reservedElasticsearchInstanceId))
            .setter(setter(Builder::reservedElasticsearchInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedElasticsearchInstanceId")
                    .build()).build();

    private static final SdkField<String> RESERVED_ELASTICSEARCH_INSTANCE_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedElasticsearchInstanceOfferingId")
            .getter(getter(ReservedElasticsearchInstance::reservedElasticsearchInstanceOfferingId))
            .setter(setter(Builder::reservedElasticsearchInstanceOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReservedElasticsearchInstanceOfferingId").build()).build();

    private static final SdkField<String> ELASTICSEARCH_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ElasticsearchInstanceType")
            .getter(getter(ReservedElasticsearchInstance::elasticsearchInstanceTypeAsString))
            .setter(setter(Builder::elasticsearchInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchInstanceType").build())
            .build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ReservedElasticsearchInstance::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Duration").getter(getter(ReservedElasticsearchInstance::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("FixedPrice").getter(getter(ReservedElasticsearchInstance::fixedPrice))
            .setter(setter(Builder::fixedPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").build()).build();

    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("UsagePrice").getter(getter(ReservedElasticsearchInstance::usagePrice))
            .setter(setter(Builder::usagePrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(ReservedElasticsearchInstance::currencyCode))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<Integer> ELASTICSEARCH_INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ElasticsearchInstanceCount")
            .getter(getter(ReservedElasticsearchInstance::elasticsearchInstanceCount))
            .setter(setter(Builder::elasticsearchInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchInstanceCount").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ReservedElasticsearchInstance::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaymentOption").getter(getter(ReservedElasticsearchInstance::paymentOptionAsString))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()).build();

    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField
            .<List<RecurringCharge>> builder(MarshallingType.LIST)
            .memberName("RecurringCharges")
            .getter(getter(ReservedElasticsearchInstance::recurringCharges))
            .setter(setter(Builder::recurringCharges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecurringCharge> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecurringCharge::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVATION_NAME_FIELD,
            RESERVED_ELASTICSEARCH_INSTANCE_ID_FIELD, RESERVED_ELASTICSEARCH_INSTANCE_OFFERING_ID_FIELD,
            ELASTICSEARCH_INSTANCE_TYPE_FIELD, START_TIME_FIELD, DURATION_FIELD, FIXED_PRICE_FIELD, USAGE_PRICE_FIELD,
            CURRENCY_CODE_FIELD, ELASTICSEARCH_INSTANCE_COUNT_FIELD, STATE_FIELD, PAYMENT_OPTION_FIELD, RECURRING_CHARGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reservationName;

    private final String reservedElasticsearchInstanceId;

    private final String reservedElasticsearchInstanceOfferingId;

    private final String elasticsearchInstanceType;

    private final Instant startTime;

    private final Integer duration;

    private final Double fixedPrice;

    private final Double usagePrice;

    private final String currencyCode;

    private final Integer elasticsearchInstanceCount;

    private final String state;

    private final String paymentOption;

    private final List<RecurringCharge> recurringCharges;

    private ReservedElasticsearchInstance(BuilderImpl builder) {
        this.reservationName = builder.reservationName;
        this.reservedElasticsearchInstanceId = builder.reservedElasticsearchInstanceId;
        this.reservedElasticsearchInstanceOfferingId = builder.reservedElasticsearchInstanceOfferingId;
        this.elasticsearchInstanceType = builder.elasticsearchInstanceType;
        this.startTime = builder.startTime;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.elasticsearchInstanceCount = builder.elasticsearchInstanceCount;
        this.state = builder.state;
        this.paymentOption = builder.paymentOption;
        this.recurringCharges = builder.recurringCharges;
    }

    /**
     * <p>
     * The customer-specified identifier to track this reservation.
     * </p>
     * 
     * @return The customer-specified identifier to track this reservation.
     */
    public final String reservationName() {
        return reservationName;
    }

    /**
     * <p>
     * The unique identifier for the reservation.
     * </p>
     * 
     * @return The unique identifier for the reservation.
     */
    public final String reservedElasticsearchInstanceId() {
        return reservedElasticsearchInstanceId;
    }

    /**
     * <p>
     * The offering identifier.
     * </p>
     * 
     * @return The offering identifier.
     */
    public final String reservedElasticsearchInstanceOfferingId() {
        return reservedElasticsearchInstanceOfferingId;
    }

    /**
     * <p>
     * The Elasticsearch instance type offered by the reserved instance offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #elasticsearchInstanceType} will return {@link ESPartitionInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #elasticsearchInstanceTypeAsString}.
     * </p>
     * 
     * @return The Elasticsearch instance type offered by the reserved instance offering.
     * @see ESPartitionInstanceType
     */
    public final ESPartitionInstanceType elasticsearchInstanceType() {
        return ESPartitionInstanceType.fromValue(elasticsearchInstanceType);
    }

    /**
     * <p>
     * The Elasticsearch instance type offered by the reserved instance offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #elasticsearchInstanceType} will return {@link ESPartitionInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #elasticsearchInstanceTypeAsString}.
     * </p>
     * 
     * @return The Elasticsearch instance type offered by the reserved instance offering.
     * @see ESPartitionInstanceType
     */
    public final String elasticsearchInstanceTypeAsString() {
        return elasticsearchInstanceType;
    }

    /**
     * <p>
     * The time the reservation started.
     * </p>
     * 
     * @return The time the reservation started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The duration, in seconds, for which the Elasticsearch instance is reserved.
     * </p>
     * 
     * @return The duration, in seconds, for which the Elasticsearch instance is reserved.
     */
    public final Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The upfront fixed charge you will paid to purchase the specific reserved Elasticsearch instance offering.
     * </p>
     * 
     * @return The upfront fixed charge you will paid to purchase the specific reserved Elasticsearch instance offering.
     */
    public final Double fixedPrice() {
        return fixedPrice;
    }

    /**
     * <p>
     * The rate you are charged for each hour for the domain that is using this reserved instance.
     * </p>
     * 
     * @return The rate you are charged for each hour for the domain that is using this reserved instance.
     */
    public final Double usagePrice() {
        return usagePrice;
    }

    /**
     * <p>
     * The currency code for the reserved Elasticsearch instance offering.
     * </p>
     * 
     * @return The currency code for the reserved Elasticsearch instance offering.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The number of Elasticsearch instances that have been reserved.
     * </p>
     * 
     * @return The number of Elasticsearch instances that have been reserved.
     */
    public final Integer elasticsearchInstanceCount() {
        return elasticsearchInstanceCount;
    }

    /**
     * <p>
     * The state of the reserved Elasticsearch instance.
     * </p>
     * 
     * @return The state of the reserved Elasticsearch instance.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The payment option as defined in the reserved Elasticsearch instance offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link ReservedElasticsearchInstancePaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option as defined in the reserved Elasticsearch instance offering.
     * @see ReservedElasticsearchInstancePaymentOption
     */
    public final ReservedElasticsearchInstancePaymentOption paymentOption() {
        return ReservedElasticsearchInstancePaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The payment option as defined in the reserved Elasticsearch instance offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link ReservedElasticsearchInstancePaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option as defined in the reserved Elasticsearch instance offering.
     * @see ReservedElasticsearchInstancePaymentOption
     */
    public final String paymentOptionAsString() {
        return paymentOption;
    }

    /**
     * Returns true if the RecurringCharges property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRecurringCharges() {
        return recurringCharges != null && !(recurringCharges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The charge to your account regardless of whether you are creating any domains using the instance offering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecurringCharges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The charge to your account regardless of whether you are creating any domains using the instance
     *         offering.
     */
    public final List<RecurringCharge> recurringCharges() {
        return recurringCharges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservationName());
        hashCode = 31 * hashCode + Objects.hashCode(reservedElasticsearchInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(reservedElasticsearchInstanceOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecurringCharges() ? recurringCharges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedElasticsearchInstance)) {
            return false;
        }
        ReservedElasticsearchInstance other = (ReservedElasticsearchInstance) obj;
        return Objects.equals(reservationName(), other.reservationName())
                && Objects.equals(reservedElasticsearchInstanceId(), other.reservedElasticsearchInstanceId())
                && Objects.equals(reservedElasticsearchInstanceOfferingId(), other.reservedElasticsearchInstanceOfferingId())
                && Objects.equals(elasticsearchInstanceTypeAsString(), other.elasticsearchInstanceTypeAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(duration(), other.duration())
                && Objects.equals(fixedPrice(), other.fixedPrice()) && Objects.equals(usagePrice(), other.usagePrice())
                && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(elasticsearchInstanceCount(), other.elasticsearchInstanceCount())
                && Objects.equals(state(), other.state())
                && Objects.equals(paymentOptionAsString(), other.paymentOptionAsString())
                && hasRecurringCharges() == other.hasRecurringCharges()
                && Objects.equals(recurringCharges(), other.recurringCharges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservedElasticsearchInstance").add("ReservationName", reservationName())
                .add("ReservedElasticsearchInstanceId", reservedElasticsearchInstanceId())
                .add("ReservedElasticsearchInstanceOfferingId", reservedElasticsearchInstanceOfferingId())
                .add("ElasticsearchInstanceType", elasticsearchInstanceTypeAsString()).add("StartTime", startTime())
                .add("Duration", duration()).add("FixedPrice", fixedPrice()).add("UsagePrice", usagePrice())
                .add("CurrencyCode", currencyCode()).add("ElasticsearchInstanceCount", elasticsearchInstanceCount())
                .add("State", state()).add("PaymentOption", paymentOptionAsString())
                .add("RecurringCharges", hasRecurringCharges() ? recurringCharges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservationName":
            return Optional.ofNullable(clazz.cast(reservationName()));
        case "ReservedElasticsearchInstanceId":
            return Optional.ofNullable(clazz.cast(reservedElasticsearchInstanceId()));
        case "ReservedElasticsearchInstanceOfferingId":
            return Optional.ofNullable(clazz.cast(reservedElasticsearchInstanceOfferingId()));
        case "ElasticsearchInstanceType":
            return Optional.ofNullable(clazz.cast(elasticsearchInstanceTypeAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "FixedPrice":
            return Optional.ofNullable(clazz.cast(fixedPrice()));
        case "UsagePrice":
            return Optional.ofNullable(clazz.cast(usagePrice()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "ElasticsearchInstanceCount":
            return Optional.ofNullable(clazz.cast(elasticsearchInstanceCount()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "PaymentOption":
            return Optional.ofNullable(clazz.cast(paymentOptionAsString()));
        case "RecurringCharges":
            return Optional.ofNullable(clazz.cast(recurringCharges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedElasticsearchInstance, T> g) {
        return obj -> g.apply((ReservedElasticsearchInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedElasticsearchInstance> {
        /**
         * <p>
         * The customer-specified identifier to track this reservation.
         * </p>
         * 
         * @param reservationName
         *        The customer-specified identifier to track this reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationName(String reservationName);

        /**
         * <p>
         * The unique identifier for the reservation.
         * </p>
         * 
         * @param reservedElasticsearchInstanceId
         *        The unique identifier for the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedElasticsearchInstanceId(String reservedElasticsearchInstanceId);

        /**
         * <p>
         * The offering identifier.
         * </p>
         * 
         * @param reservedElasticsearchInstanceOfferingId
         *        The offering identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId);

        /**
         * <p>
         * The Elasticsearch instance type offered by the reserved instance offering.
         * </p>
         * 
         * @param elasticsearchInstanceType
         *        The Elasticsearch instance type offered by the reserved instance offering.
         * @see ESPartitionInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ESPartitionInstanceType
         */
        Builder elasticsearchInstanceType(String elasticsearchInstanceType);

        /**
         * <p>
         * The Elasticsearch instance type offered by the reserved instance offering.
         * </p>
         * 
         * @param elasticsearchInstanceType
         *        The Elasticsearch instance type offered by the reserved instance offering.
         * @see ESPartitionInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ESPartitionInstanceType
         */
        Builder elasticsearchInstanceType(ESPartitionInstanceType elasticsearchInstanceType);

        /**
         * <p>
         * The time the reservation started.
         * </p>
         * 
         * @param startTime
         *        The time the reservation started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The duration, in seconds, for which the Elasticsearch instance is reserved.
         * </p>
         * 
         * @param duration
         *        The duration, in seconds, for which the Elasticsearch instance is reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The upfront fixed charge you will paid to purchase the specific reserved Elasticsearch instance offering.
         * </p>
         * 
         * @param fixedPrice
         *        The upfront fixed charge you will paid to purchase the specific reserved Elasticsearch instance
         *        offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedPrice(Double fixedPrice);

        /**
         * <p>
         * The rate you are charged for each hour for the domain that is using this reserved instance.
         * </p>
         * 
         * @param usagePrice
         *        The rate you are charged for each hour for the domain that is using this reserved instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePrice(Double usagePrice);

        /**
         * <p>
         * The currency code for the reserved Elasticsearch instance offering.
         * </p>
         * 
         * @param currencyCode
         *        The currency code for the reserved Elasticsearch instance offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The number of Elasticsearch instances that have been reserved.
         * </p>
         * 
         * @param elasticsearchInstanceCount
         *        The number of Elasticsearch instances that have been reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchInstanceCount(Integer elasticsearchInstanceCount);

        /**
         * <p>
         * The state of the reserved Elasticsearch instance.
         * </p>
         * 
         * @param state
         *        The state of the reserved Elasticsearch instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The payment option as defined in the reserved Elasticsearch instance offering.
         * </p>
         * 
         * @param paymentOption
         *        The payment option as defined in the reserved Elasticsearch instance offering.
         * @see ReservedElasticsearchInstancePaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedElasticsearchInstancePaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The payment option as defined in the reserved Elasticsearch instance offering.
         * </p>
         * 
         * @param paymentOption
         *        The payment option as defined in the reserved Elasticsearch instance offering.
         * @see ReservedElasticsearchInstancePaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedElasticsearchInstancePaymentOption
         */
        Builder paymentOption(ReservedElasticsearchInstancePaymentOption paymentOption);

        /**
         * <p>
         * The charge to your account regardless of whether you are creating any domains using the instance offering.
         * </p>
         * 
         * @param recurringCharges
         *        The charge to your account regardless of whether you are creating any domains using the instance
         *        offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(Collection<RecurringCharge> recurringCharges);

        /**
         * <p>
         * The charge to your account regardless of whether you are creating any domains using the instance offering.
         * </p>
         * 
         * @param recurringCharges
         *        The charge to your account regardless of whether you are creating any domains using the instance
         *        offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(RecurringCharge... recurringCharges);

        /**
         * <p>
         * The charge to your account regardless of whether you are creating any domains using the instance offering.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RecurringCharge>.Builder} avoiding the need
         * to create one manually via {@link List<RecurringCharge>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RecurringCharge>.Builder#build()} is called immediately and
         * its result is passed to {@link #recurringCharges(List<RecurringCharge>)}.
         * 
         * @param recurringCharges
         *        a consumer that will call methods on {@link List<RecurringCharge>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurringCharges(List<RecurringCharge>)
         */
        Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges);
    }

    static final class BuilderImpl implements Builder {
        private String reservationName;

        private String reservedElasticsearchInstanceId;

        private String reservedElasticsearchInstanceOfferingId;

        private String elasticsearchInstanceType;

        private Instant startTime;

        private Integer duration;

        private Double fixedPrice;

        private Double usagePrice;

        private String currencyCode;

        private Integer elasticsearchInstanceCount;

        private String state;

        private String paymentOption;

        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedElasticsearchInstance model) {
            reservationName(model.reservationName);
            reservedElasticsearchInstanceId(model.reservedElasticsearchInstanceId);
            reservedElasticsearchInstanceOfferingId(model.reservedElasticsearchInstanceOfferingId);
            elasticsearchInstanceType(model.elasticsearchInstanceType);
            startTime(model.startTime);
            duration(model.duration);
            fixedPrice(model.fixedPrice);
            usagePrice(model.usagePrice);
            currencyCode(model.currencyCode);
            elasticsearchInstanceCount(model.elasticsearchInstanceCount);
            state(model.state);
            paymentOption(model.paymentOption);
            recurringCharges(model.recurringCharges);
        }

        public final String getReservationName() {
            return reservationName;
        }

        @Override
        public final Builder reservationName(String reservationName) {
            this.reservationName = reservationName;
            return this;
        }

        public final void setReservationName(String reservationName) {
            this.reservationName = reservationName;
        }

        public final String getReservedElasticsearchInstanceId() {
            return reservedElasticsearchInstanceId;
        }

        @Override
        public final Builder reservedElasticsearchInstanceId(String reservedElasticsearchInstanceId) {
            this.reservedElasticsearchInstanceId = reservedElasticsearchInstanceId;
            return this;
        }

        public final void setReservedElasticsearchInstanceId(String reservedElasticsearchInstanceId) {
            this.reservedElasticsearchInstanceId = reservedElasticsearchInstanceId;
        }

        public final String getReservedElasticsearchInstanceOfferingId() {
            return reservedElasticsearchInstanceOfferingId;
        }

        @Override
        public final Builder reservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId) {
            this.reservedElasticsearchInstanceOfferingId = reservedElasticsearchInstanceOfferingId;
            return this;
        }

        public final void setReservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId) {
            this.reservedElasticsearchInstanceOfferingId = reservedElasticsearchInstanceOfferingId;
        }

        public final String getElasticsearchInstanceType() {
            return elasticsearchInstanceType;
        }

        @Override
        public final Builder elasticsearchInstanceType(String elasticsearchInstanceType) {
            this.elasticsearchInstanceType = elasticsearchInstanceType;
            return this;
        }

        @Override
        public final Builder elasticsearchInstanceType(ESPartitionInstanceType elasticsearchInstanceType) {
            this.elasticsearchInstanceType(elasticsearchInstanceType == null ? null : elasticsearchInstanceType.toString());
            return this;
        }

        public final void setElasticsearchInstanceType(String elasticsearchInstanceType) {
            this.elasticsearchInstanceType = elasticsearchInstanceType;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Double getFixedPrice() {
            return fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final Double getUsagePrice() {
            return usagePrice;
        }

        @Override
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Integer getElasticsearchInstanceCount() {
            return elasticsearchInstanceCount;
        }

        @Override
        public final Builder elasticsearchInstanceCount(Integer elasticsearchInstanceCount) {
            this.elasticsearchInstanceCount = elasticsearchInstanceCount;
            return this;
        }

        public final void setElasticsearchInstanceCount(Integer elasticsearchInstanceCount) {
            this.elasticsearchInstanceCount = elasticsearchInstanceCount;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(ReservedElasticsearchInstancePaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final List<RecurringCharge.Builder> getRecurringCharges() {
            List<RecurringCharge.Builder> result = RecurringChargeListCopier.copyToBuilder(this.recurringCharges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge... recurringCharges) {
            recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges) {
            recurringCharges(Stream.of(recurringCharges).map(c -> RecurringCharge.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        @Override
        public ReservedElasticsearchInstance build() {
            return new ReservedElasticsearchInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
