/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of an <code>UpdateElasticsearchDomain</code> request. Contains the status of the Elasticsearch domain
 * being updated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateElasticsearchDomainConfigResponse extends ElasticsearchResponse implements
        ToCopyableBuilder<UpdateElasticsearchDomainConfigResponse.Builder, UpdateElasticsearchDomainConfigResponse> {
    private static final SdkField<ElasticsearchDomainConfig> DOMAIN_CONFIG_FIELD = SdkField
            .<ElasticsearchDomainConfig> builder(MarshallingType.SDK_POJO).memberName("DomainConfig")
            .getter(getter(UpdateElasticsearchDomainConfigResponse::domainConfig)).setter(setter(Builder::domainConfig))
            .constructor(ElasticsearchDomainConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CONFIG_FIELD));

    private final ElasticsearchDomainConfig domainConfig;

    private UpdateElasticsearchDomainConfigResponse(BuilderImpl builder) {
        super(builder);
        this.domainConfig = builder.domainConfig;
    }

    /**
     * <p>
     * The status of the updated Elasticsearch domain.
     * </p>
     * 
     * @return The status of the updated Elasticsearch domain.
     */
    public final ElasticsearchDomainConfig domainConfig() {
        return domainConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateElasticsearchDomainConfigResponse)) {
            return false;
        }
        UpdateElasticsearchDomainConfigResponse other = (UpdateElasticsearchDomainConfigResponse) obj;
        return Objects.equals(domainConfig(), other.domainConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateElasticsearchDomainConfigResponse").add("DomainConfig", domainConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainConfig":
            return Optional.ofNullable(clazz.cast(domainConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateElasticsearchDomainConfigResponse, T> g) {
        return obj -> g.apply((UpdateElasticsearchDomainConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateElasticsearchDomainConfigResponse> {
        /**
         * <p>
         * The status of the updated Elasticsearch domain.
         * </p>
         * 
         * @param domainConfig
         *        The status of the updated Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainConfig(ElasticsearchDomainConfig domainConfig);

        /**
         * <p>
         * The status of the updated Elasticsearch domain.
         * </p>
         * This is a convenience that creates an instance of the {@link ElasticsearchDomainConfig.Builder} avoiding the
         * need to create one manually via {@link ElasticsearchDomainConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ElasticsearchDomainConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #domainConfig(ElasticsearchDomainConfig)}.
         * 
         * @param domainConfig
         *        a consumer that will call methods on {@link ElasticsearchDomainConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainConfig(ElasticsearchDomainConfig)
         */
        default Builder domainConfig(Consumer<ElasticsearchDomainConfig.Builder> domainConfig) {
            return domainConfig(ElasticsearchDomainConfig.builder().applyMutation(domainConfig).build());
        }
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private ElasticsearchDomainConfig domainConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateElasticsearchDomainConfigResponse model) {
            super(model);
            domainConfig(model.domainConfig);
        }

        public final ElasticsearchDomainConfig.Builder getDomainConfig() {
            return domainConfig != null ? domainConfig.toBuilder() : null;
        }

        @Override
        public final Builder domainConfig(ElasticsearchDomainConfig domainConfig) {
            this.domainConfig = domainConfig;
            return this;
        }

        public final void setDomainConfig(ElasticsearchDomainConfig.BuilderImpl domainConfig) {
            this.domainConfig = domainConfig != null ? domainConfig.build() : null;
        }

        @Override
        public UpdateElasticsearchDomainConfigResponse build() {
            return new UpdateElasticsearchDomainConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
