/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.DomainInformation;
import software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InboundCrossClusterSearchConnection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InboundCrossClusterSearchConnection> {
    private static final SdkField<DomainInformation> SOURCE_DOMAIN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceDomainInfo").getter(InboundCrossClusterSearchConnection.getter(InboundCrossClusterSearchConnection::sourceDomainInfo)).setter(InboundCrossClusterSearchConnection.setter(Builder::sourceDomainInfo)).constructor(DomainInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDomainInfo").build()}).build();
    private static final SdkField<DomainInformation> DESTINATION_DOMAIN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationDomainInfo").getter(InboundCrossClusterSearchConnection.getter(InboundCrossClusterSearchConnection::destinationDomainInfo)).setter(InboundCrossClusterSearchConnection.setter(Builder::destinationDomainInfo)).constructor(DomainInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationDomainInfo").build()}).build();
    private static final SdkField<String> CROSS_CLUSTER_SEARCH_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CrossClusterSearchConnectionId").getter(InboundCrossClusterSearchConnection.getter(InboundCrossClusterSearchConnection::crossClusterSearchConnectionId)).setter(InboundCrossClusterSearchConnection.setter(Builder::crossClusterSearchConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossClusterSearchConnectionId").build()}).build();
    private static final SdkField<InboundCrossClusterSearchConnectionStatus> CONNECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionStatus").getter(InboundCrossClusterSearchConnection.getter(InboundCrossClusterSearchConnection::connectionStatus)).setter(InboundCrossClusterSearchConnection.setter(Builder::connectionStatus)).constructor(InboundCrossClusterSearchConnectionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_DOMAIN_INFO_FIELD, DESTINATION_DOMAIN_INFO_FIELD, CROSS_CLUSTER_SEARCH_CONNECTION_ID_FIELD, CONNECTION_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final DomainInformation sourceDomainInfo;
    private final DomainInformation destinationDomainInfo;
    private final String crossClusterSearchConnectionId;
    private final InboundCrossClusterSearchConnectionStatus connectionStatus;

    private InboundCrossClusterSearchConnection(BuilderImpl builder) {
        this.sourceDomainInfo = builder.sourceDomainInfo;
        this.destinationDomainInfo = builder.destinationDomainInfo;
        this.crossClusterSearchConnectionId = builder.crossClusterSearchConnectionId;
        this.connectionStatus = builder.connectionStatus;
    }

    public final DomainInformation sourceDomainInfo() {
        return this.sourceDomainInfo;
    }

    public final DomainInformation destinationDomainInfo() {
        return this.destinationDomainInfo;
    }

    public final String crossClusterSearchConnectionId() {
        return this.crossClusterSearchConnectionId;
    }

    public final InboundCrossClusterSearchConnectionStatus connectionStatus() {
        return this.connectionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.crossClusterSearchConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InboundCrossClusterSearchConnection)) {
            return false;
        }
        InboundCrossClusterSearchConnection other = (InboundCrossClusterSearchConnection)obj;
        return Objects.equals(this.sourceDomainInfo(), other.sourceDomainInfo()) && Objects.equals(this.destinationDomainInfo(), other.destinationDomainInfo()) && Objects.equals(this.crossClusterSearchConnectionId(), other.crossClusterSearchConnectionId()) && Objects.equals(this.connectionStatus(), other.connectionStatus());
    }

    public final String toString() {
        return ToString.builder((String)"InboundCrossClusterSearchConnection").add("SourceDomainInfo", (Object)this.sourceDomainInfo()).add("DestinationDomainInfo", (Object)this.destinationDomainInfo()).add("CrossClusterSearchConnectionId", (Object)this.crossClusterSearchConnectionId()).add("ConnectionStatus", (Object)this.connectionStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceDomainInfo": {
                return Optional.ofNullable(clazz.cast(this.sourceDomainInfo()));
            }
            case "DestinationDomainInfo": {
                return Optional.ofNullable(clazz.cast(this.destinationDomainInfo()));
            }
            case "CrossClusterSearchConnectionId": {
                return Optional.ofNullable(clazz.cast(this.crossClusterSearchConnectionId()));
            }
            case "ConnectionStatus": {
                return Optional.ofNullable(clazz.cast(this.connectionStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InboundCrossClusterSearchConnection, T> g) {
        return obj -> g.apply((InboundCrossClusterSearchConnection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DomainInformation sourceDomainInfo;
        private DomainInformation destinationDomainInfo;
        private String crossClusterSearchConnectionId;
        private InboundCrossClusterSearchConnectionStatus connectionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(InboundCrossClusterSearchConnection model) {
            this.sourceDomainInfo(model.sourceDomainInfo);
            this.destinationDomainInfo(model.destinationDomainInfo);
            this.crossClusterSearchConnectionId(model.crossClusterSearchConnectionId);
            this.connectionStatus(model.connectionStatus);
        }

        public final DomainInformation.Builder getSourceDomainInfo() {
            return this.sourceDomainInfo != null ? this.sourceDomainInfo.toBuilder() : null;
        }

        public final void setSourceDomainInfo(DomainInformation.BuilderImpl sourceDomainInfo) {
            this.sourceDomainInfo = sourceDomainInfo != null ? sourceDomainInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceDomainInfo(DomainInformation sourceDomainInfo) {
            this.sourceDomainInfo = sourceDomainInfo;
            return this;
        }

        public final DomainInformation.Builder getDestinationDomainInfo() {
            return this.destinationDomainInfo != null ? this.destinationDomainInfo.toBuilder() : null;
        }

        public final void setDestinationDomainInfo(DomainInformation.BuilderImpl destinationDomainInfo) {
            this.destinationDomainInfo = destinationDomainInfo != null ? destinationDomainInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder destinationDomainInfo(DomainInformation destinationDomainInfo) {
            this.destinationDomainInfo = destinationDomainInfo;
            return this;
        }

        public final String getCrossClusterSearchConnectionId() {
            return this.crossClusterSearchConnectionId;
        }

        public final void setCrossClusterSearchConnectionId(String crossClusterSearchConnectionId) {
            this.crossClusterSearchConnectionId = crossClusterSearchConnectionId;
        }

        @Override
        @Transient
        public final Builder crossClusterSearchConnectionId(String crossClusterSearchConnectionId) {
            this.crossClusterSearchConnectionId = crossClusterSearchConnectionId;
            return this;
        }

        public final InboundCrossClusterSearchConnectionStatus.Builder getConnectionStatus() {
            return this.connectionStatus != null ? this.connectionStatus.toBuilder() : null;
        }

        public final void setConnectionStatus(InboundCrossClusterSearchConnectionStatus.BuilderImpl connectionStatus) {
            this.connectionStatus = connectionStatus != null ? connectionStatus.build() : null;
        }

        @Override
        @Transient
        public final Builder connectionStatus(InboundCrossClusterSearchConnectionStatus connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        public InboundCrossClusterSearchConnection build() {
            return new InboundCrossClusterSearchConnection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InboundCrossClusterSearchConnection> {
        public Builder sourceDomainInfo(DomainInformation var1);

        default public Builder sourceDomainInfo(Consumer<DomainInformation.Builder> sourceDomainInfo) {
            return this.sourceDomainInfo((DomainInformation)((DomainInformation.Builder)DomainInformation.builder().applyMutation(sourceDomainInfo)).build());
        }

        public Builder destinationDomainInfo(DomainInformation var1);

        default public Builder destinationDomainInfo(Consumer<DomainInformation.Builder> destinationDomainInfo) {
            return this.destinationDomainInfo((DomainInformation)((DomainInformation.Builder)DomainInformation.builder().applyMutation(destinationDomainInfo)).build());
        }

        public Builder crossClusterSearchConnectionId(String var1);

        public Builder connectionStatus(InboundCrossClusterSearchConnectionStatus var1);

        default public Builder connectionStatus(Consumer<InboundCrossClusterSearchConnectionStatus.Builder> connectionStatus) {
            return this.connectionStatus((InboundCrossClusterSearchConnectionStatus)((InboundCrossClusterSearchConnectionStatus.Builder)InboundCrossClusterSearchConnectionStatus.builder().applyMutation(connectionStatus)).build());
        }
    }
}

