/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchAsyncClient;
import software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryResponse;

public class GetPackageVersionHistoryPublisher
implements SdkPublisher<GetPackageVersionHistoryResponse> {
    private final ElasticsearchAsyncClient client;
    private final GetPackageVersionHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetPackageVersionHistoryPublisher(ElasticsearchAsyncClient client, GetPackageVersionHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetPackageVersionHistoryPublisher(ElasticsearchAsyncClient client, GetPackageVersionHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetPackageVersionHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetPackageVersionHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetPackageVersionHistoryResponseFetcher
    implements AsyncPageFetcher<GetPackageVersionHistoryResponse> {
        private GetPackageVersionHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetPackageVersionHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetPackageVersionHistoryResponse> nextPage(GetPackageVersionHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetPackageVersionHistoryPublisher.this.client.getPackageVersionHistory(GetPackageVersionHistoryPublisher.this.firstRequest);
            }
            return GetPackageVersionHistoryPublisher.this.client.getPackageVersionHistory((GetPackageVersionHistoryRequest)((Object)GetPackageVersionHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

