/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters to the <code><a>AcceptInboundCrossClusterSearchConnection</a></code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptInboundCrossClusterSearchConnectionRequest extends ElasticsearchRequest
        implements
        ToCopyableBuilder<AcceptInboundCrossClusterSearchConnectionRequest.Builder, AcceptInboundCrossClusterSearchConnectionRequest> {
    private static final SdkField<String> CROSS_CLUSTER_SEARCH_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("CrossClusterSearchConnectionId")
            .getter(getter(AcceptInboundCrossClusterSearchConnectionRequest::crossClusterSearchConnectionId))
            .setter(setter(Builder::crossClusterSearchConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConnectionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CROSS_CLUSTER_SEARCH_CONNECTION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String crossClusterSearchConnectionId;

    private AcceptInboundCrossClusterSearchConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.crossClusterSearchConnectionId = builder.crossClusterSearchConnectionId;
    }

    /**
     * <p>
     * The id of the inbound connection that you want to accept.
     * </p>
     * 
     * @return The id of the inbound connection that you want to accept.
     */
    public final String crossClusterSearchConnectionId() {
        return crossClusterSearchConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(crossClusterSearchConnectionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptInboundCrossClusterSearchConnectionRequest)) {
            return false;
        }
        AcceptInboundCrossClusterSearchConnectionRequest other = (AcceptInboundCrossClusterSearchConnectionRequest) obj;
        return Objects.equals(crossClusterSearchConnectionId(), other.crossClusterSearchConnectionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptInboundCrossClusterSearchConnectionRequest")
                .add("CrossClusterSearchConnectionId", crossClusterSearchConnectionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrossClusterSearchConnectionId":
            return Optional.ofNullable(clazz.cast(crossClusterSearchConnectionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionId", CROSS_CLUSTER_SEARCH_CONNECTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceptInboundCrossClusterSearchConnectionRequest, T> g) {
        return obj -> g.apply((AcceptInboundCrossClusterSearchConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AcceptInboundCrossClusterSearchConnectionRequest> {
        /**
         * <p>
         * The id of the inbound connection that you want to accept.
         * </p>
         * 
         * @param crossClusterSearchConnectionId
         *        The id of the inbound connection that you want to accept.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossClusterSearchConnectionId(String crossClusterSearchConnectionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticsearchRequest.BuilderImpl implements Builder {
        private String crossClusterSearchConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptInboundCrossClusterSearchConnectionRequest model) {
            super(model);
            crossClusterSearchConnectionId(model.crossClusterSearchConnectionId);
        }

        public final String getCrossClusterSearchConnectionId() {
            return crossClusterSearchConnectionId;
        }

        public final void setCrossClusterSearchConnectionId(String crossClusterSearchConnectionId) {
            this.crossClusterSearchConnectionId = crossClusterSearchConnectionId;
        }

        @Override
        public final Builder crossClusterSearchConnectionId(String crossClusterSearchConnectionId) {
            this.crossClusterSearchConnectionId = crossClusterSearchConnectionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptInboundCrossClusterSearchConnectionRequest build() {
            return new AcceptInboundCrossClusterSearchConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
