/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code><a>AcceptInboundCrossClusterSearchConnection</a></code> operation. Contains details of accepted
 * inbound connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptInboundCrossClusterSearchConnectionResponse extends ElasticsearchResponse
        implements
        ToCopyableBuilder<AcceptInboundCrossClusterSearchConnectionResponse.Builder, AcceptInboundCrossClusterSearchConnectionResponse> {
    private static final SdkField<InboundCrossClusterSearchConnection> CROSS_CLUSTER_SEARCH_CONNECTION_FIELD = SdkField
            .<InboundCrossClusterSearchConnection> builder(MarshallingType.SDK_POJO)
            .memberName("CrossClusterSearchConnection")
            .getter(getter(AcceptInboundCrossClusterSearchConnectionResponse::crossClusterSearchConnection))
            .setter(setter(Builder::crossClusterSearchConnection))
            .constructor(InboundCrossClusterSearchConnection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossClusterSearchConnection")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CROSS_CLUSTER_SEARCH_CONNECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final InboundCrossClusterSearchConnection crossClusterSearchConnection;

    private AcceptInboundCrossClusterSearchConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.crossClusterSearchConnection = builder.crossClusterSearchConnection;
    }

    /**
     * <p>
     * Specifies the <code><a>InboundCrossClusterSearchConnection</a></code> of accepted inbound connection.
     * </p>
     * 
     * @return Specifies the <code><a>InboundCrossClusterSearchConnection</a></code> of accepted inbound connection.
     */
    public final InboundCrossClusterSearchConnection crossClusterSearchConnection() {
        return crossClusterSearchConnection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(crossClusterSearchConnection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptInboundCrossClusterSearchConnectionResponse)) {
            return false;
        }
        AcceptInboundCrossClusterSearchConnectionResponse other = (AcceptInboundCrossClusterSearchConnectionResponse) obj;
        return Objects.equals(crossClusterSearchConnection(), other.crossClusterSearchConnection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptInboundCrossClusterSearchConnectionResponse")
                .add("CrossClusterSearchConnection", crossClusterSearchConnection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrossClusterSearchConnection":
            return Optional.ofNullable(clazz.cast(crossClusterSearchConnection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CrossClusterSearchConnection", CROSS_CLUSTER_SEARCH_CONNECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceptInboundCrossClusterSearchConnectionResponse, T> g) {
        return obj -> g.apply((AcceptInboundCrossClusterSearchConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AcceptInboundCrossClusterSearchConnectionResponse> {
        /**
         * <p>
         * Specifies the <code><a>InboundCrossClusterSearchConnection</a></code> of accepted inbound connection.
         * </p>
         * 
         * @param crossClusterSearchConnection
         *        Specifies the <code><a>InboundCrossClusterSearchConnection</a></code> of accepted inbound connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossClusterSearchConnection(InboundCrossClusterSearchConnection crossClusterSearchConnection);

        /**
         * <p>
         * Specifies the <code><a>InboundCrossClusterSearchConnection</a></code> of accepted inbound connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InboundCrossClusterSearchConnection.Builder} avoiding the need to create one manually via
         * {@link InboundCrossClusterSearchConnection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InboundCrossClusterSearchConnection.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #crossClusterSearchConnection(InboundCrossClusterSearchConnection)}.
         * 
         * @param crossClusterSearchConnection
         *        a consumer that will call methods on {@link InboundCrossClusterSearchConnection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crossClusterSearchConnection(InboundCrossClusterSearchConnection)
         */
        default Builder crossClusterSearchConnection(
                Consumer<InboundCrossClusterSearchConnection.Builder> crossClusterSearchConnection) {
            return crossClusterSearchConnection(InboundCrossClusterSearchConnection.builder()
                    .applyMutation(crossClusterSearchConnection).build());
        }
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private InboundCrossClusterSearchConnection crossClusterSearchConnection;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptInboundCrossClusterSearchConnectionResponse model) {
            super(model);
            crossClusterSearchConnection(model.crossClusterSearchConnection);
        }

        public final InboundCrossClusterSearchConnection.Builder getCrossClusterSearchConnection() {
            return crossClusterSearchConnection != null ? crossClusterSearchConnection.toBuilder() : null;
        }

        public final void setCrossClusterSearchConnection(
                InboundCrossClusterSearchConnection.BuilderImpl crossClusterSearchConnection) {
            this.crossClusterSearchConnection = crossClusterSearchConnection != null ? crossClusterSearchConnection.build()
                    : null;
        }

        @Override
        public final Builder crossClusterSearchConnection(InboundCrossClusterSearchConnection crossClusterSearchConnection) {
            this.crossClusterSearchConnection = crossClusterSearchConnection;
            return this;
        }

        @Override
        public AcceptInboundCrossClusterSearchConnectionResponse build() {
            return new AcceptInboundCrossClusterSearchConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
