/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the Auto-Tune options: the Auto-Tune desired state for the domain and list of maintenance schedules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoTuneOptionsInput implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoTuneOptionsInput.Builder, AutoTuneOptionsInput> {
    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DesiredState").getter(getter(AutoTuneOptionsInput::desiredStateAsString))
            .setter(setter(Builder::desiredState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()).build();

    private static final SdkField<List<AutoTuneMaintenanceSchedule>> MAINTENANCE_SCHEDULES_FIELD = SdkField
            .<List<AutoTuneMaintenanceSchedule>> builder(MarshallingType.LIST)
            .memberName("MaintenanceSchedules")
            .getter(getter(AutoTuneOptionsInput::maintenanceSchedules))
            .setter(setter(Builder::maintenanceSchedules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceSchedules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoTuneMaintenanceSchedule> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoTuneMaintenanceSchedule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_STATE_FIELD,
            MAINTENANCE_SCHEDULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String desiredState;

    private final List<AutoTuneMaintenanceSchedule> maintenanceSchedules;

    private AutoTuneOptionsInput(BuilderImpl builder) {
        this.desiredState = builder.desiredState;
        this.maintenanceSchedules = builder.maintenanceSchedules;
    }

    /**
     * <p>
     * Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link AutoTuneDesiredState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #desiredStateAsString}.
     * </p>
     * 
     * @return Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED.
     * @see AutoTuneDesiredState
     */
    public final AutoTuneDesiredState desiredState() {
        return AutoTuneDesiredState.fromValue(desiredState);
    }

    /**
     * <p>
     * Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link AutoTuneDesiredState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #desiredStateAsString}.
     * </p>
     * 
     * @return Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED.
     * @see AutoTuneDesiredState
     */
    public final String desiredStateAsString() {
        return desiredState;
    }

    /**
     * For responses, this returns true if the service returned a value for the MaintenanceSchedules property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMaintenanceSchedules() {
        return maintenanceSchedules != null && !(maintenanceSchedules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies list of maitenance schedules. See the <a
     * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
     * target="_blank">Developer Guide</a> for more information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMaintenanceSchedules} method.
     * </p>
     * 
     * @return Specifies list of maitenance schedules. See the <a
     *         href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
     *         target="_blank">Developer Guide</a> for more information.
     */
    public final List<AutoTuneMaintenanceSchedule> maintenanceSchedules() {
        return maintenanceSchedules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMaintenanceSchedules() ? maintenanceSchedules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoTuneOptionsInput)) {
            return false;
        }
        AutoTuneOptionsInput other = (AutoTuneOptionsInput) obj;
        return Objects.equals(desiredStateAsString(), other.desiredStateAsString())
                && hasMaintenanceSchedules() == other.hasMaintenanceSchedules()
                && Objects.equals(maintenanceSchedules(), other.maintenanceSchedules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoTuneOptionsInput").add("DesiredState", desiredStateAsString())
                .add("MaintenanceSchedules", hasMaintenanceSchedules() ? maintenanceSchedules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DesiredState":
            return Optional.ofNullable(clazz.cast(desiredStateAsString()));
        case "MaintenanceSchedules":
            return Optional.ofNullable(clazz.cast(maintenanceSchedules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DesiredState", DESIRED_STATE_FIELD);
        map.put("MaintenanceSchedules", MAINTENANCE_SCHEDULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoTuneOptionsInput, T> g) {
        return obj -> g.apply((AutoTuneOptionsInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoTuneOptionsInput> {
        /**
         * <p>
         * Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED.
         * </p>
         * 
         * @param desiredState
         *        Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED.
         * @see AutoTuneDesiredState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoTuneDesiredState
         */
        Builder desiredState(String desiredState);

        /**
         * <p>
         * Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED.
         * </p>
         * 
         * @param desiredState
         *        Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED.
         * @see AutoTuneDesiredState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoTuneDesiredState
         */
        Builder desiredState(AutoTuneDesiredState desiredState);

        /**
         * <p>
         * Specifies list of maitenance schedules. See the <a
         * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
         * target="_blank">Developer Guide</a> for more information.
         * </p>
         * 
         * @param maintenanceSchedules
         *        Specifies list of maitenance schedules. See the <a
         *        href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
         *        target="_blank">Developer Guide</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceSchedules(Collection<AutoTuneMaintenanceSchedule> maintenanceSchedules);

        /**
         * <p>
         * Specifies list of maitenance schedules. See the <a
         * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
         * target="_blank">Developer Guide</a> for more information.
         * </p>
         * 
         * @param maintenanceSchedules
         *        Specifies list of maitenance schedules. See the <a
         *        href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
         *        target="_blank">Developer Guide</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceSchedules(AutoTuneMaintenanceSchedule... maintenanceSchedules);

        /**
         * <p>
         * Specifies list of maitenance schedules. See the <a
         * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
         * target="_blank">Developer Guide</a> for more information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticsearch.model.AutoTuneMaintenanceSchedule.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.elasticsearch.model.AutoTuneMaintenanceSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticsearch.model.AutoTuneMaintenanceSchedule.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #maintenanceSchedules(List<AutoTuneMaintenanceSchedule>)}.
         * 
         * @param maintenanceSchedules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticsearch.model.AutoTuneMaintenanceSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceSchedules(java.util.Collection<AutoTuneMaintenanceSchedule>)
         */
        Builder maintenanceSchedules(Consumer<AutoTuneMaintenanceSchedule.Builder>... maintenanceSchedules);
    }

    static final class BuilderImpl implements Builder {
        private String desiredState;

        private List<AutoTuneMaintenanceSchedule> maintenanceSchedules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoTuneOptionsInput model) {
            desiredState(model.desiredState);
            maintenanceSchedules(model.maintenanceSchedules);
        }

        public final String getDesiredState() {
            return desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(AutoTuneDesiredState desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final List<AutoTuneMaintenanceSchedule.Builder> getMaintenanceSchedules() {
            List<AutoTuneMaintenanceSchedule.Builder> result = AutoTuneMaintenanceScheduleListCopier
                    .copyToBuilder(this.maintenanceSchedules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMaintenanceSchedules(Collection<AutoTuneMaintenanceSchedule.BuilderImpl> maintenanceSchedules) {
            this.maintenanceSchedules = AutoTuneMaintenanceScheduleListCopier.copyFromBuilder(maintenanceSchedules);
        }

        @Override
        public final Builder maintenanceSchedules(Collection<AutoTuneMaintenanceSchedule> maintenanceSchedules) {
            this.maintenanceSchedules = AutoTuneMaintenanceScheduleListCopier.copy(maintenanceSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceSchedules(AutoTuneMaintenanceSchedule... maintenanceSchedules) {
            maintenanceSchedules(Arrays.asList(maintenanceSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceSchedules(Consumer<AutoTuneMaintenanceSchedule.Builder>... maintenanceSchedules) {
            maintenanceSchedules(Stream.of(maintenanceSchedules)
                    .map(c -> AutoTuneMaintenanceSchedule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AutoTuneOptionsInput build() {
            return new AutoTuneOptionsInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
