/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters to the <code>DescribeDomainChangeProgress</code> operation. Specifies the domain name
 * and optional change specific identity for which you want progress information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDomainChangeProgressRequest extends ElasticsearchRequest implements
        ToCopyableBuilder<DescribeDomainChangeProgressRequest.Builder, DescribeDomainChangeProgressRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(DescribeDomainChangeProgressRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> CHANGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeId").getter(getter(DescribeDomainChangeProgressRequest::changeId))
            .setter(setter(Builder::changeId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("changeid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            CHANGE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String changeId;

    private DescribeDomainChangeProgressRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.changeId = builder.changeId;
    }

    /**
     * <p>
     * The domain you want to get the progress information about.
     * </p>
     * 
     * @return The domain you want to get the progress information about.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The specific change ID for which you want to get progress information. This is an optional parameter. If omitted,
     * the service returns information about the most recent configuration change.
     * </p>
     * 
     * @return The specific change ID for which you want to get progress information. This is an optional parameter. If
     *         omitted, the service returns information about the most recent configuration change.
     */
    public final String changeId() {
        return changeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(changeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainChangeProgressRequest)) {
            return false;
        }
        DescribeDomainChangeProgressRequest other = (DescribeDomainChangeProgressRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(changeId(), other.changeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDomainChangeProgressRequest").add("DomainName", domainName())
                .add("ChangeId", changeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ChangeId":
            return Optional.ofNullable(clazz.cast(changeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("changeid", CHANGE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainChangeProgressRequest, T> g) {
        return obj -> g.apply((DescribeDomainChangeProgressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDomainChangeProgressRequest> {
        /**
         * <p>
         * The domain you want to get the progress information about.
         * </p>
         * 
         * @param domainName
         *        The domain you want to get the progress information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The specific change ID for which you want to get progress information. This is an optional parameter. If
         * omitted, the service returns information about the most recent configuration change.
         * </p>
         * 
         * @param changeId
         *        The specific change ID for which you want to get progress information. This is an optional parameter.
         *        If omitted, the service returns information about the most recent configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeId(String changeId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticsearchRequest.BuilderImpl implements Builder {
        private String domainName;

        private String changeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainChangeProgressRequest model) {
            super(model);
            domainName(model.domainName);
            changeId(model.changeId);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getChangeId() {
            return changeId;
        }

        public final void setChangeId(String changeId) {
            this.changeId = changeId;
        }

        @Override
        public final Builder changeId(String changeId) {
            this.changeId = changeId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDomainChangeProgressRequest build() {
            return new DescribeDomainChangeProgressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
