/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters received from <code> <a>DescribeElasticsearchInstanceTypeLimits</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeElasticsearchInstanceTypeLimitsResponse extends ElasticsearchResponse
        implements
        ToCopyableBuilder<DescribeElasticsearchInstanceTypeLimitsResponse.Builder, DescribeElasticsearchInstanceTypeLimitsResponse> {
    private static final SdkField<Map<String, Limits>> LIMITS_BY_ROLE_FIELD = SdkField
            .<Map<String, Limits>> builder(MarshallingType.MAP)
            .memberName("LimitsByRole")
            .getter(getter(DescribeElasticsearchInstanceTypeLimitsResponse::limitsByRole))
            .setter(setter(Builder::limitsByRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitsByRole").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Limits> builder(MarshallingType.SDK_POJO)
                                            .constructor(Limits::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMITS_BY_ROLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, Limits> limitsByRole;

    private DescribeElasticsearchInstanceTypeLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.limitsByRole = builder.limitsByRole;
    }

    /**
     * For responses, this returns true if the service returned a value for the LimitsByRole property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLimitsByRole() {
        return limitsByRole != null && !(limitsByRole instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the LimitsByRole property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLimitsByRole} method.
     * </p>
     * 
     * @return The value of the LimitsByRole property for this object.
     */
    public final Map<String, Limits> limitsByRole() {
        return limitsByRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLimitsByRole() ? limitsByRole() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticsearchInstanceTypeLimitsResponse)) {
            return false;
        }
        DescribeElasticsearchInstanceTypeLimitsResponse other = (DescribeElasticsearchInstanceTypeLimitsResponse) obj;
        return hasLimitsByRole() == other.hasLimitsByRole() && Objects.equals(limitsByRole(), other.limitsByRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeElasticsearchInstanceTypeLimitsResponse")
                .add("LimitsByRole", hasLimitsByRole() ? limitsByRole() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LimitsByRole":
            return Optional.ofNullable(clazz.cast(limitsByRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LimitsByRole", LIMITS_BY_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeElasticsearchInstanceTypeLimitsResponse, T> g) {
        return obj -> g.apply((DescribeElasticsearchInstanceTypeLimitsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeElasticsearchInstanceTypeLimitsResponse> {
        /**
         * Sets the value of the LimitsByRole property for this object.
         *
         * @param limitsByRole
         *        The new value for the LimitsByRole property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitsByRole(Map<String, Limits> limitsByRole);
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private Map<String, Limits> limitsByRole = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticsearchInstanceTypeLimitsResponse model) {
            super(model);
            limitsByRole(model.limitsByRole);
        }

        public final Map<String, Limits.Builder> getLimitsByRole() {
            Map<String, Limits.Builder> result = LimitsByRoleCopier.copyToBuilder(this.limitsByRole);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLimitsByRole(Map<String, Limits.BuilderImpl> limitsByRole) {
            this.limitsByRole = LimitsByRoleCopier.copyFromBuilder(limitsByRole);
        }

        @Override
        public final Builder limitsByRole(Map<String, Limits> limitsByRole) {
            this.limitsByRole = LimitsByRoleCopier.copy(limitsByRole);
            return this;
        }

        @Override
        public DescribeElasticsearchInstanceTypeLimitsResponse build() {
            return new DescribeElasticsearchInstanceTypeLimitsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
