/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code><a>DescribeInboundCrossClusterSearchConnections</a></code> request. Contains the list of
 * connections matching the filter criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInboundCrossClusterSearchConnectionsResponse extends ElasticsearchResponse
        implements
        ToCopyableBuilder<DescribeInboundCrossClusterSearchConnectionsResponse.Builder, DescribeInboundCrossClusterSearchConnectionsResponse> {
    private static final SdkField<List<InboundCrossClusterSearchConnection>> CROSS_CLUSTER_SEARCH_CONNECTIONS_FIELD = SdkField
            .<List<InboundCrossClusterSearchConnection>> builder(MarshallingType.LIST)
            .memberName("CrossClusterSearchConnections")
            .getter(getter(DescribeInboundCrossClusterSearchConnectionsResponse::crossClusterSearchConnections))
            .setter(setter(Builder::crossClusterSearchConnections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossClusterSearchConnections")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InboundCrossClusterSearchConnection> builder(MarshallingType.SDK_POJO)
                                            .constructor(InboundCrossClusterSearchConnection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeInboundCrossClusterSearchConnectionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CROSS_CLUSTER_SEARCH_CONNECTIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<InboundCrossClusterSearchConnection> crossClusterSearchConnections;

    private final String nextToken;

    private DescribeInboundCrossClusterSearchConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.crossClusterSearchConnections = builder.crossClusterSearchConnections;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CrossClusterSearchConnections property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCrossClusterSearchConnections() {
        return crossClusterSearchConnections != null && !(crossClusterSearchConnections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Consists of list of <code><a>InboundCrossClusterSearchConnection</a></code> matching the specified filter
     * criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCrossClusterSearchConnections} method.
     * </p>
     * 
     * @return Consists of list of <code><a>InboundCrossClusterSearchConnection</a></code> matching the specified filter
     *         criteria.
     */
    public final List<InboundCrossClusterSearchConnection> crossClusterSearchConnections() {
        return crossClusterSearchConnections;
    }

    /**
     * <p>
     * If more results are available and NextToken is present, make the next request to the same API with the received
     * NextToken to paginate the remaining results.
     * </p>
     * 
     * @return If more results are available and NextToken is present, make the next request to the same API with the
     *         received NextToken to paginate the remaining results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCrossClusterSearchConnections() ? crossClusterSearchConnections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInboundCrossClusterSearchConnectionsResponse)) {
            return false;
        }
        DescribeInboundCrossClusterSearchConnectionsResponse other = (DescribeInboundCrossClusterSearchConnectionsResponse) obj;
        return hasCrossClusterSearchConnections() == other.hasCrossClusterSearchConnections()
                && Objects.equals(crossClusterSearchConnections(), other.crossClusterSearchConnections())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeInboundCrossClusterSearchConnectionsResponse")
                .add("CrossClusterSearchConnections", hasCrossClusterSearchConnections() ? crossClusterSearchConnections() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrossClusterSearchConnections":
            return Optional.ofNullable(clazz.cast(crossClusterSearchConnections()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CrossClusterSearchConnections", CROSS_CLUSTER_SEARCH_CONNECTIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInboundCrossClusterSearchConnectionsResponse, T> g) {
        return obj -> g.apply((DescribeInboundCrossClusterSearchConnectionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInboundCrossClusterSearchConnectionsResponse> {
        /**
         * <p>
         * Consists of list of <code><a>InboundCrossClusterSearchConnection</a></code> matching the specified filter
         * criteria.
         * </p>
         * 
         * @param crossClusterSearchConnections
         *        Consists of list of <code><a>InboundCrossClusterSearchConnection</a></code> matching the specified
         *        filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossClusterSearchConnections(Collection<InboundCrossClusterSearchConnection> crossClusterSearchConnections);

        /**
         * <p>
         * Consists of list of <code><a>InboundCrossClusterSearchConnection</a></code> matching the specified filter
         * criteria.
         * </p>
         * 
         * @param crossClusterSearchConnections
         *        Consists of list of <code><a>InboundCrossClusterSearchConnection</a></code> matching the specified
         *        filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossClusterSearchConnections(InboundCrossClusterSearchConnection... crossClusterSearchConnections);

        /**
         * <p>
         * Consists of list of <code><a>InboundCrossClusterSearchConnection</a></code> matching the specified filter
         * criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnection.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnection.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #crossClusterSearchConnections(List<InboundCrossClusterSearchConnection>)}.
         * 
         * @param crossClusterSearchConnections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crossClusterSearchConnections(java.util.Collection<InboundCrossClusterSearchConnection>)
         */
        Builder crossClusterSearchConnections(
                Consumer<InboundCrossClusterSearchConnection.Builder>... crossClusterSearchConnections);

        /**
         * <p>
         * If more results are available and NextToken is present, make the next request to the same API with the
         * received NextToken to paginate the remaining results.
         * </p>
         * 
         * @param nextToken
         *        If more results are available and NextToken is present, make the next request to the same API with the
         *        received NextToken to paginate the remaining results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private List<InboundCrossClusterSearchConnection> crossClusterSearchConnections = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInboundCrossClusterSearchConnectionsResponse model) {
            super(model);
            crossClusterSearchConnections(model.crossClusterSearchConnections);
            nextToken(model.nextToken);
        }

        public final List<InboundCrossClusterSearchConnection.Builder> getCrossClusterSearchConnections() {
            List<InboundCrossClusterSearchConnection.Builder> result = InboundCrossClusterSearchConnectionsCopier
                    .copyToBuilder(this.crossClusterSearchConnections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCrossClusterSearchConnections(
                Collection<InboundCrossClusterSearchConnection.BuilderImpl> crossClusterSearchConnections) {
            this.crossClusterSearchConnections = InboundCrossClusterSearchConnectionsCopier
                    .copyFromBuilder(crossClusterSearchConnections);
        }

        @Override
        public final Builder crossClusterSearchConnections(
                Collection<InboundCrossClusterSearchConnection> crossClusterSearchConnections) {
            this.crossClusterSearchConnections = InboundCrossClusterSearchConnectionsCopier.copy(crossClusterSearchConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossClusterSearchConnections(InboundCrossClusterSearchConnection... crossClusterSearchConnections) {
            crossClusterSearchConnections(Arrays.asList(crossClusterSearchConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossClusterSearchConnections(
                Consumer<InboundCrossClusterSearchConnection.Builder>... crossClusterSearchConnections) {
            crossClusterSearchConnections(Stream.of(crossClusterSearchConnections)
                    .map(c -> InboundCrossClusterSearchConnection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeInboundCrossClusterSearchConnectionsResponse build() {
            return new DescribeInboundCrossClusterSearchConnectionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
