/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configured endpoint options for the domain and their current status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainEndpointOptionsStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainEndpointOptionsStatus.Builder, DomainEndpointOptionsStatus> {
    private static final SdkField<DomainEndpointOptions> OPTIONS_FIELD = SdkField
            .<DomainEndpointOptions> builder(MarshallingType.SDK_POJO).memberName("Options")
            .getter(getter(DomainEndpointOptionsStatus::options)).setter(setter(Builder::options))
            .constructor(DomainEndpointOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()).build();

    private static final SdkField<OptionStatus> STATUS_FIELD = SdkField.<OptionStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status").getter(getter(DomainEndpointOptionsStatus::status)).setter(setter(Builder::status))
            .constructor(OptionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DomainEndpointOptions options;

    private final OptionStatus status;

    private DomainEndpointOptionsStatus(BuilderImpl builder) {
        this.options = builder.options;
        this.status = builder.status;
    }

    /**
     * <p>
     * Options to configure endpoint for the Elasticsearch domain.
     * </p>
     * 
     * @return Options to configure endpoint for the Elasticsearch domain.
     */
    public final DomainEndpointOptions options() {
        return options;
    }

    /**
     * <p>
     * The status of the endpoint options for the Elasticsearch domain. See <code>OptionStatus</code> for the status
     * information that's included.
     * </p>
     * 
     * @return The status of the endpoint options for the Elasticsearch domain. See <code>OptionStatus</code> for the
     *         status information that's included.
     */
    public final OptionStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(options());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainEndpointOptionsStatus)) {
            return false;
        }
        DomainEndpointOptionsStatus other = (DomainEndpointOptionsStatus) obj;
        return Objects.equals(options(), other.options()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainEndpointOptionsStatus").add("Options", options()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Options", OPTIONS_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainEndpointOptionsStatus, T> g) {
        return obj -> g.apply((DomainEndpointOptionsStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainEndpointOptionsStatus> {
        /**
         * <p>
         * Options to configure endpoint for the Elasticsearch domain.
         * </p>
         * 
         * @param options
         *        Options to configure endpoint for the Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(DomainEndpointOptions options);

        /**
         * <p>
         * Options to configure endpoint for the Elasticsearch domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainEndpointOptions.Builder} avoiding
         * the need to create one manually via {@link DomainEndpointOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainEndpointOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #options(DomainEndpointOptions)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link DomainEndpointOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(DomainEndpointOptions)
         */
        default Builder options(Consumer<DomainEndpointOptions.Builder> options) {
            return options(DomainEndpointOptions.builder().applyMutation(options).build());
        }

        /**
         * <p>
         * The status of the endpoint options for the Elasticsearch domain. See <code>OptionStatus</code> for the status
         * information that's included.
         * </p>
         * 
         * @param status
         *        The status of the endpoint options for the Elasticsearch domain. See <code>OptionStatus</code> for the
         *        status information that's included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(OptionStatus status);

        /**
         * <p>
         * The status of the endpoint options for the Elasticsearch domain. See <code>OptionStatus</code> for the status
         * information that's included.
         * </p>
         * This is a convenience method that creates an instance of the {@link OptionStatus.Builder} avoiding the need
         * to create one manually via {@link OptionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OptionStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(OptionStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link OptionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(OptionStatus)
         */
        default Builder status(Consumer<OptionStatus.Builder> status) {
            return status(OptionStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DomainEndpointOptions options;

        private OptionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainEndpointOptionsStatus model) {
            options(model.options);
            status(model.status);
        }

        public final DomainEndpointOptions.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(DomainEndpointOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(DomainEndpointOptions options) {
            this.options = options;
            return this;
        }

        public final OptionStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(OptionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(OptionStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public DomainEndpointOptionsStatus build() {
            return new DomainEndpointOptionsStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
