/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the coonection status of an inbound cross-cluster search connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InboundCrossClusterSearchConnectionStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<InboundCrossClusterSearchConnectionStatus.Builder, InboundCrossClusterSearchConnectionStatus> {
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusCode").getter(getter(InboundCrossClusterSearchConnectionStatus::statusCodeAsString))
            .setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(InboundCrossClusterSearchConnectionStatus::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD,
            MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String statusCode;

    private final String message;

    private InboundCrossClusterSearchConnectionStatus(BuilderImpl builder) {
        this.statusCode = builder.statusCode;
        this.message = builder.message;
    }

    /**
     * <p>
     * The state code for inbound connection. This can be one of the following:
     * </p>
     * <ul>
     * <li>PENDING_ACCEPTANCE: Inbound connection is not yet accepted by destination domain owner.</li>
     * <li>APPROVED: Inbound connection is pending acceptance by destination domain owner.</li>
     * <li>REJECTING: Inbound connection rejection is in process.</li>
     * <li>REJECTED: Inbound connection is rejected.</li>
     * <li>DELETING: Inbound connection deletion is in progress.</li>
     * <li>DELETED: Inbound connection is deleted and cannot be used further.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link InboundCrossClusterSearchConnectionStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The state code for inbound connection. This can be one of the following:</p>
     *         <ul>
     *         <li>PENDING_ACCEPTANCE: Inbound connection is not yet accepted by destination domain owner.</li>
     *         <li>APPROVED: Inbound connection is pending acceptance by destination domain owner.</li>
     *         <li>REJECTING: Inbound connection rejection is in process.</li>
     *         <li>REJECTED: Inbound connection is rejected.</li>
     *         <li>DELETING: Inbound connection deletion is in progress.</li>
     *         <li>DELETED: Inbound connection is deleted and cannot be used further.</li>
     * @see InboundCrossClusterSearchConnectionStatusCode
     */
    public final InboundCrossClusterSearchConnectionStatusCode statusCode() {
        return InboundCrossClusterSearchConnectionStatusCode.fromValue(statusCode);
    }

    /**
     * <p>
     * The state code for inbound connection. This can be one of the following:
     * </p>
     * <ul>
     * <li>PENDING_ACCEPTANCE: Inbound connection is not yet accepted by destination domain owner.</li>
     * <li>APPROVED: Inbound connection is pending acceptance by destination domain owner.</li>
     * <li>REJECTING: Inbound connection rejection is in process.</li>
     * <li>REJECTED: Inbound connection is rejected.</li>
     * <li>DELETING: Inbound connection deletion is in progress.</li>
     * <li>DELETED: Inbound connection is deleted and cannot be used further.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link InboundCrossClusterSearchConnectionStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The state code for inbound connection. This can be one of the following:</p>
     *         <ul>
     *         <li>PENDING_ACCEPTANCE: Inbound connection is not yet accepted by destination domain owner.</li>
     *         <li>APPROVED: Inbound connection is pending acceptance by destination domain owner.</li>
     *         <li>REJECTING: Inbound connection rejection is in process.</li>
     *         <li>REJECTED: Inbound connection is rejected.</li>
     *         <li>DELETING: Inbound connection deletion is in progress.</li>
     *         <li>DELETED: Inbound connection is deleted and cannot be used further.</li>
     * @see InboundCrossClusterSearchConnectionStatusCode
     */
    public final String statusCodeAsString() {
        return statusCode;
    }

    /**
     * <p>
     * Specifies verbose information for the inbound connection status.
     * </p>
     * 
     * @return Specifies verbose information for the inbound connection status.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InboundCrossClusterSearchConnectionStatus)) {
            return false;
        }
        InboundCrossClusterSearchConnectionStatus other = (InboundCrossClusterSearchConnectionStatus) obj;
        return Objects.equals(statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InboundCrossClusterSearchConnectionStatus").add("StatusCode", statusCodeAsString())
                .add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InboundCrossClusterSearchConnectionStatus, T> g) {
        return obj -> g.apply((InboundCrossClusterSearchConnectionStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InboundCrossClusterSearchConnectionStatus> {
        /**
         * <p>
         * The state code for inbound connection. This can be one of the following:
         * </p>
         * <ul>
         * <li>PENDING_ACCEPTANCE: Inbound connection is not yet accepted by destination domain owner.</li>
         * <li>APPROVED: Inbound connection is pending acceptance by destination domain owner.</li>
         * <li>REJECTING: Inbound connection rejection is in process.</li>
         * <li>REJECTED: Inbound connection is rejected.</li>
         * <li>DELETING: Inbound connection deletion is in progress.</li>
         * <li>DELETED: Inbound connection is deleted and cannot be used further.</li>
         * </ul>
         * 
         * @param statusCode
         *        The state code for inbound connection. This can be one of the following:</p>
         *        <ul>
         *        <li>PENDING_ACCEPTANCE: Inbound connection is not yet accepted by destination domain owner.</li>
         *        <li>APPROVED: Inbound connection is pending acceptance by destination domain owner.</li>
         *        <li>REJECTING: Inbound connection rejection is in process.</li>
         *        <li>REJECTED: Inbound connection is rejected.</li>
         *        <li>DELETING: Inbound connection deletion is in progress.</li>
         *        <li>DELETED: Inbound connection is deleted and cannot be used further.</li>
         * @see InboundCrossClusterSearchConnectionStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InboundCrossClusterSearchConnectionStatusCode
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * The state code for inbound connection. This can be one of the following:
         * </p>
         * <ul>
         * <li>PENDING_ACCEPTANCE: Inbound connection is not yet accepted by destination domain owner.</li>
         * <li>APPROVED: Inbound connection is pending acceptance by destination domain owner.</li>
         * <li>REJECTING: Inbound connection rejection is in process.</li>
         * <li>REJECTED: Inbound connection is rejected.</li>
         * <li>DELETING: Inbound connection deletion is in progress.</li>
         * <li>DELETED: Inbound connection is deleted and cannot be used further.</li>
         * </ul>
         * 
         * @param statusCode
         *        The state code for inbound connection. This can be one of the following:</p>
         *        <ul>
         *        <li>PENDING_ACCEPTANCE: Inbound connection is not yet accepted by destination domain owner.</li>
         *        <li>APPROVED: Inbound connection is pending acceptance by destination domain owner.</li>
         *        <li>REJECTING: Inbound connection rejection is in process.</li>
         *        <li>REJECTED: Inbound connection is rejected.</li>
         *        <li>DELETING: Inbound connection deletion is in progress.</li>
         *        <li>DELETED: Inbound connection is deleted and cannot be used further.</li>
         * @see InboundCrossClusterSearchConnectionStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InboundCrossClusterSearchConnectionStatusCode
         */
        Builder statusCode(InboundCrossClusterSearchConnectionStatusCode statusCode);

        /**
         * <p>
         * Specifies verbose information for the inbound connection status.
         * </p>
         * 
         * @param message
         *        Specifies verbose information for the inbound connection status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String statusCode;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InboundCrossClusterSearchConnectionStatus model) {
            statusCode(model.statusCode);
            message(model.message);
        }

        public final String getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(InboundCrossClusterSearchConnectionStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public InboundCrossClusterSearchConnectionStatus build() {
            return new InboundCrossClusterSearchConnectionStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
