/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * InstanceLimits represents the list of instance related attributes that are available for given InstanceType.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceLimits implements SdkPojo, Serializable, ToCopyableBuilder<InstanceLimits.Builder, InstanceLimits> {
    private static final SdkField<InstanceCountLimits> INSTANCE_COUNT_LIMITS_FIELD = SdkField
            .<InstanceCountLimits> builder(MarshallingType.SDK_POJO).memberName("InstanceCountLimits")
            .getter(getter(InstanceLimits::instanceCountLimits)).setter(setter(Builder::instanceCountLimits))
            .constructor(InstanceCountLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCountLimits").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_LIMITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InstanceCountLimits instanceCountLimits;

    private InstanceLimits(BuilderImpl builder) {
        this.instanceCountLimits = builder.instanceCountLimits;
    }

    /**
     * Returns the value of the InstanceCountLimits property for this object.
     * 
     * @return The value of the InstanceCountLimits property for this object.
     */
    public final InstanceCountLimits instanceCountLimits() {
        return instanceCountLimits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceCountLimits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceLimits)) {
            return false;
        }
        InstanceLimits other = (InstanceLimits) obj;
        return Objects.equals(instanceCountLimits(), other.instanceCountLimits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceLimits").add("InstanceCountLimits", instanceCountLimits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceCountLimits":
            return Optional.ofNullable(clazz.cast(instanceCountLimits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceCountLimits", INSTANCE_COUNT_LIMITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceLimits, T> g) {
        return obj -> g.apply((InstanceLimits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceLimits> {
        /**
         * Sets the value of the InstanceCountLimits property for this object.
         *
         * @param instanceCountLimits
         *        The new value for the InstanceCountLimits property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCountLimits(InstanceCountLimits instanceCountLimits);

        /**
         * Sets the value of the InstanceCountLimits property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InstanceCountLimits.Builder} avoiding the
         * need to create one manually via {@link InstanceCountLimits#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceCountLimits.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceCountLimits(InstanceCountLimits)}.
         * 
         * @param instanceCountLimits
         *        a consumer that will call methods on {@link InstanceCountLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceCountLimits(InstanceCountLimits)
         */
        default Builder instanceCountLimits(Consumer<InstanceCountLimits.Builder> instanceCountLimits) {
            return instanceCountLimits(InstanceCountLimits.builder().applyMutation(instanceCountLimits).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InstanceCountLimits instanceCountLimits;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceLimits model) {
            instanceCountLimits(model.instanceCountLimits);
        }

        public final InstanceCountLimits.Builder getInstanceCountLimits() {
            return instanceCountLimits != null ? instanceCountLimits.toBuilder() : null;
        }

        public final void setInstanceCountLimits(InstanceCountLimits.BuilderImpl instanceCountLimits) {
            this.instanceCountLimits = instanceCountLimits != null ? instanceCountLimits.build() : null;
        }

        @Override
        public final Builder instanceCountLimits(InstanceCountLimits instanceCountLimits) {
            this.instanceCountLimits = instanceCountLimits;
            return this;
        }

        @Override
        public InstanceLimits build() {
            return new InstanceLimits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
