/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters for response received from <code> <a>ListElasticsearchVersions</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListElasticsearchVersionsResponse extends ElasticsearchResponse implements
        ToCopyableBuilder<ListElasticsearchVersionsResponse.Builder, ListElasticsearchVersionsResponse> {
    private static final SdkField<List<String>> ELASTICSEARCH_VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ElasticsearchVersions")
            .getter(getter(ListElasticsearchVersionsResponse::elasticsearchVersions))
            .setter(setter(Builder::elasticsearchVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListElasticsearchVersionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTICSEARCH_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> elasticsearchVersions;

    private final String nextToken;

    private ListElasticsearchVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.elasticsearchVersions = builder.elasticsearchVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ElasticsearchVersions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasElasticsearchVersions() {
        return elasticsearchVersions != null && !(elasticsearchVersions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the ElasticsearchVersions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasElasticsearchVersions} method.
     * </p>
     * 
     * @return The value of the ElasticsearchVersions property for this object.
     */
    public final List<String> elasticsearchVersions() {
        return elasticsearchVersions;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasElasticsearchVersions() ? elasticsearchVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListElasticsearchVersionsResponse)) {
            return false;
        }
        ListElasticsearchVersionsResponse other = (ListElasticsearchVersionsResponse) obj;
        return hasElasticsearchVersions() == other.hasElasticsearchVersions()
                && Objects.equals(elasticsearchVersions(), other.elasticsearchVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListElasticsearchVersionsResponse")
                .add("ElasticsearchVersions", hasElasticsearchVersions() ? elasticsearchVersions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticsearchVersions":
            return Optional.ofNullable(clazz.cast(elasticsearchVersions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ElasticsearchVersions", ELASTICSEARCH_VERSIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListElasticsearchVersionsResponse, T> g) {
        return obj -> g.apply((ListElasticsearchVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListElasticsearchVersionsResponse> {
        /**
         * Sets the value of the ElasticsearchVersions property for this object.
         *
         * @param elasticsearchVersions
         *        The new value for the ElasticsearchVersions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchVersions(Collection<String> elasticsearchVersions);

        /**
         * Sets the value of the ElasticsearchVersions property for this object.
         *
         * @param elasticsearchVersions
         *        The new value for the ElasticsearchVersions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchVersions(String... elasticsearchVersions);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private List<String> elasticsearchVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListElasticsearchVersionsResponse model) {
            super(model);
            elasticsearchVersions(model.elasticsearchVersions);
            nextToken(model.nextToken);
        }

        public final Collection<String> getElasticsearchVersions() {
            if (elasticsearchVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return elasticsearchVersions;
        }

        public final void setElasticsearchVersions(Collection<String> elasticsearchVersions) {
            this.elasticsearchVersions = ElasticsearchVersionListCopier.copy(elasticsearchVersions);
        }

        @Override
        public final Builder elasticsearchVersions(Collection<String> elasticsearchVersions) {
            this.elasticsearchVersions = ElasticsearchVersionListCopier.copy(elasticsearchVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticsearchVersions(String... elasticsearchVersions) {
            elasticsearchVersions(Arrays.asList(elasticsearchVersions));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListElasticsearchVersionsResponse build() {
            return new ListElasticsearchVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
