/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for response parameters to the <code><a>ListVpcEndpointsForDomain</a></code> operation. Returns a list
 * containing summarized details of the VPC endpoints.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVpcEndpointsForDomainResponse extends ElasticsearchResponse implements
        ToCopyableBuilder<ListVpcEndpointsForDomainResponse.Builder, ListVpcEndpointsForDomainResponse> {
    private static final SdkField<List<VpcEndpointSummary>> VPC_ENDPOINT_SUMMARY_LIST_FIELD = SdkField
            .<List<VpcEndpointSummary>> builder(MarshallingType.LIST)
            .memberName("VpcEndpointSummaryList")
            .getter(getter(ListVpcEndpointsForDomainResponse::vpcEndpointSummaryList))
            .setter(setter(Builder::vpcEndpointSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcEndpointSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcEndpointSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListVpcEndpointsForDomainResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VPC_ENDPOINT_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<VpcEndpointSummary> vpcEndpointSummaryList;

    private final String nextToken;

    private ListVpcEndpointsForDomainResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEndpointSummaryList = builder.vpcEndpointSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcEndpointSummaryList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVpcEndpointSummaryList() {
        return vpcEndpointSummaryList != null && !(vpcEndpointSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides list of <code>VpcEndpointSummary</code> summarizing details of the VPC endpoints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcEndpointSummaryList} method.
     * </p>
     * 
     * @return Provides list of <code>VpcEndpointSummary</code> summarizing details of the VPC endpoints.
     */
    public final List<VpcEndpointSummary> vpcEndpointSummaryList() {
        return vpcEndpointSummaryList;
    }

    /**
     * <p>
     * Information about each endpoint associated with the domain.
     * </p>
     * 
     * @return Information about each endpoint associated with the domain.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcEndpointSummaryList() ? vpcEndpointSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVpcEndpointsForDomainResponse)) {
            return false;
        }
        ListVpcEndpointsForDomainResponse other = (ListVpcEndpointsForDomainResponse) obj;
        return hasVpcEndpointSummaryList() == other.hasVpcEndpointSummaryList()
                && Objects.equals(vpcEndpointSummaryList(), other.vpcEndpointSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVpcEndpointsForDomainResponse")
                .add("VpcEndpointSummaryList", hasVpcEndpointSummaryList() ? vpcEndpointSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointSummaryList":
            return Optional.ofNullable(clazz.cast(vpcEndpointSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcEndpointSummaryList", VPC_ENDPOINT_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVpcEndpointsForDomainResponse, T> g) {
        return obj -> g.apply((ListVpcEndpointsForDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListVpcEndpointsForDomainResponse> {
        /**
         * <p>
         * Provides list of <code>VpcEndpointSummary</code> summarizing details of the VPC endpoints.
         * </p>
         * 
         * @param vpcEndpointSummaryList
         *        Provides list of <code>VpcEndpointSummary</code> summarizing details of the VPC endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointSummaryList(Collection<VpcEndpointSummary> vpcEndpointSummaryList);

        /**
         * <p>
         * Provides list of <code>VpcEndpointSummary</code> summarizing details of the VPC endpoints.
         * </p>
         * 
         * @param vpcEndpointSummaryList
         *        Provides list of <code>VpcEndpointSummary</code> summarizing details of the VPC endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointSummaryList(VpcEndpointSummary... vpcEndpointSummaryList);

        /**
         * <p>
         * Provides list of <code>VpcEndpointSummary</code> summarizing details of the VPC endpoints.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticsearch.model.VpcEndpointSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.elasticsearch.model.VpcEndpointSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticsearch.model.VpcEndpointSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcEndpointSummaryList(List<VpcEndpointSummary>)}.
         * 
         * @param vpcEndpointSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticsearch.model.VpcEndpointSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEndpointSummaryList(java.util.Collection<VpcEndpointSummary>)
         */
        Builder vpcEndpointSummaryList(Consumer<VpcEndpointSummary.Builder>... vpcEndpointSummaryList);

        /**
         * <p>
         * Information about each endpoint associated with the domain.
         * </p>
         * 
         * @param nextToken
         *        Information about each endpoint associated with the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private List<VpcEndpointSummary> vpcEndpointSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVpcEndpointsForDomainResponse model) {
            super(model);
            vpcEndpointSummaryList(model.vpcEndpointSummaryList);
            nextToken(model.nextToken);
        }

        public final List<VpcEndpointSummary.Builder> getVpcEndpointSummaryList() {
            List<VpcEndpointSummary.Builder> result = VpcEndpointSummaryListCopier.copyToBuilder(this.vpcEndpointSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcEndpointSummaryList(Collection<VpcEndpointSummary.BuilderImpl> vpcEndpointSummaryList) {
            this.vpcEndpointSummaryList = VpcEndpointSummaryListCopier.copyFromBuilder(vpcEndpointSummaryList);
        }

        @Override
        public final Builder vpcEndpointSummaryList(Collection<VpcEndpointSummary> vpcEndpointSummaryList) {
            this.vpcEndpointSummaryList = VpcEndpointSummaryListCopier.copy(vpcEndpointSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointSummaryList(VpcEndpointSummary... vpcEndpointSummaryList) {
            vpcEndpointSummaryList(Arrays.asList(vpcEndpointSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointSummaryList(Consumer<VpcEndpointSummary.Builder>... vpcEndpointSummaryList) {
            vpcEndpointSummaryList(Stream.of(vpcEndpointSummaryList)
                    .map(c -> VpcEndpointSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListVpcEndpointsForDomainResponse build() {
            return new ListVpcEndpointsForDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
