/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies details of an outbound connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutboundCrossClusterSearchConnection implements SdkPojo, Serializable,
        ToCopyableBuilder<OutboundCrossClusterSearchConnection.Builder, OutboundCrossClusterSearchConnection> {
    private static final SdkField<DomainInformation> SOURCE_DOMAIN_INFO_FIELD = SdkField
            .<DomainInformation> builder(MarshallingType.SDK_POJO).memberName("SourceDomainInfo")
            .getter(getter(OutboundCrossClusterSearchConnection::sourceDomainInfo)).setter(setter(Builder::sourceDomainInfo))
            .constructor(DomainInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDomainInfo").build()).build();

    private static final SdkField<DomainInformation> DESTINATION_DOMAIN_INFO_FIELD = SdkField
            .<DomainInformation> builder(MarshallingType.SDK_POJO).memberName("DestinationDomainInfo")
            .getter(getter(OutboundCrossClusterSearchConnection::destinationDomainInfo))
            .setter(setter(Builder::destinationDomainInfo)).constructor(DomainInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationDomainInfo").build())
            .build();

    private static final SdkField<String> CROSS_CLUSTER_SEARCH_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CrossClusterSearchConnectionId")
            .getter(getter(OutboundCrossClusterSearchConnection::crossClusterSearchConnectionId))
            .setter(setter(Builder::crossClusterSearchConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossClusterSearchConnectionId")
                    .build()).build();

    private static final SdkField<String> CONNECTION_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionAlias").getter(getter(OutboundCrossClusterSearchConnection::connectionAlias))
            .setter(setter(Builder::connectionAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionAlias").build()).build();

    private static final SdkField<OutboundCrossClusterSearchConnectionStatus> CONNECTION_STATUS_FIELD = SdkField
            .<OutboundCrossClusterSearchConnectionStatus> builder(MarshallingType.SDK_POJO).memberName("ConnectionStatus")
            .getter(getter(OutboundCrossClusterSearchConnection::connectionStatus)).setter(setter(Builder::connectionStatus))
            .constructor(OutboundCrossClusterSearchConnectionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_DOMAIN_INFO_FIELD,
            DESTINATION_DOMAIN_INFO_FIELD, CROSS_CLUSTER_SEARCH_CONNECTION_ID_FIELD, CONNECTION_ALIAS_FIELD,
            CONNECTION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DomainInformation sourceDomainInfo;

    private final DomainInformation destinationDomainInfo;

    private final String crossClusterSearchConnectionId;

    private final String connectionAlias;

    private final OutboundCrossClusterSearchConnectionStatus connectionStatus;

    private OutboundCrossClusterSearchConnection(BuilderImpl builder) {
        this.sourceDomainInfo = builder.sourceDomainInfo;
        this.destinationDomainInfo = builder.destinationDomainInfo;
        this.crossClusterSearchConnectionId = builder.crossClusterSearchConnectionId;
        this.connectionAlias = builder.connectionAlias;
        this.connectionStatus = builder.connectionStatus;
    }

    /**
     * <p>
     * Specifies the <code><a>DomainInformation</a></code> for the source Elasticsearch domain.
     * </p>
     * 
     * @return Specifies the <code><a>DomainInformation</a></code> for the source Elasticsearch domain.
     */
    public final DomainInformation sourceDomainInfo() {
        return sourceDomainInfo;
    }

    /**
     * <p>
     * Specifies the <code><a>DomainInformation</a></code> for the destination Elasticsearch domain.
     * </p>
     * 
     * @return Specifies the <code><a>DomainInformation</a></code> for the destination Elasticsearch domain.
     */
    public final DomainInformation destinationDomainInfo() {
        return destinationDomainInfo;
    }

    /**
     * <p>
     * Specifies the connection id for the outbound cross-cluster search connection.
     * </p>
     * 
     * @return Specifies the connection id for the outbound cross-cluster search connection.
     */
    public final String crossClusterSearchConnectionId() {
        return crossClusterSearchConnectionId;
    }

    /**
     * <p>
     * Specifies the connection alias for the outbound cross-cluster search connection.
     * </p>
     * 
     * @return Specifies the connection alias for the outbound cross-cluster search connection.
     */
    public final String connectionAlias() {
        return connectionAlias;
    }

    /**
     * <p>
     * Specifies the <code><a>OutboundCrossClusterSearchConnectionStatus</a></code> for the outbound connection.
     * </p>
     * 
     * @return Specifies the <code><a>OutboundCrossClusterSearchConnectionStatus</a></code> for the outbound connection.
     */
    public final OutboundCrossClusterSearchConnectionStatus connectionStatus() {
        return connectionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(destinationDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(crossClusterSearchConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionAlias());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutboundCrossClusterSearchConnection)) {
            return false;
        }
        OutboundCrossClusterSearchConnection other = (OutboundCrossClusterSearchConnection) obj;
        return Objects.equals(sourceDomainInfo(), other.sourceDomainInfo())
                && Objects.equals(destinationDomainInfo(), other.destinationDomainInfo())
                && Objects.equals(crossClusterSearchConnectionId(), other.crossClusterSearchConnectionId())
                && Objects.equals(connectionAlias(), other.connectionAlias())
                && Objects.equals(connectionStatus(), other.connectionStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutboundCrossClusterSearchConnection").add("SourceDomainInfo", sourceDomainInfo())
                .add("DestinationDomainInfo", destinationDomainInfo())
                .add("CrossClusterSearchConnectionId", crossClusterSearchConnectionId())
                .add("ConnectionAlias", connectionAlias()).add("ConnectionStatus", connectionStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceDomainInfo":
            return Optional.ofNullable(clazz.cast(sourceDomainInfo()));
        case "DestinationDomainInfo":
            return Optional.ofNullable(clazz.cast(destinationDomainInfo()));
        case "CrossClusterSearchConnectionId":
            return Optional.ofNullable(clazz.cast(crossClusterSearchConnectionId()));
        case "ConnectionAlias":
            return Optional.ofNullable(clazz.cast(connectionAlias()));
        case "ConnectionStatus":
            return Optional.ofNullable(clazz.cast(connectionStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceDomainInfo", SOURCE_DOMAIN_INFO_FIELD);
        map.put("DestinationDomainInfo", DESTINATION_DOMAIN_INFO_FIELD);
        map.put("CrossClusterSearchConnectionId", CROSS_CLUSTER_SEARCH_CONNECTION_ID_FIELD);
        map.put("ConnectionAlias", CONNECTION_ALIAS_FIELD);
        map.put("ConnectionStatus", CONNECTION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutboundCrossClusterSearchConnection, T> g) {
        return obj -> g.apply((OutboundCrossClusterSearchConnection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutboundCrossClusterSearchConnection> {
        /**
         * <p>
         * Specifies the <code><a>DomainInformation</a></code> for the source Elasticsearch domain.
         * </p>
         * 
         * @param sourceDomainInfo
         *        Specifies the <code><a>DomainInformation</a></code> for the source Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDomainInfo(DomainInformation sourceDomainInfo);

        /**
         * <p>
         * Specifies the <code><a>DomainInformation</a></code> for the source Elasticsearch domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainInformation.Builder} avoiding the
         * need to create one manually via {@link DomainInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceDomainInfo(DomainInformation)}.
         * 
         * @param sourceDomainInfo
         *        a consumer that will call methods on {@link DomainInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceDomainInfo(DomainInformation)
         */
        default Builder sourceDomainInfo(Consumer<DomainInformation.Builder> sourceDomainInfo) {
            return sourceDomainInfo(DomainInformation.builder().applyMutation(sourceDomainInfo).build());
        }

        /**
         * <p>
         * Specifies the <code><a>DomainInformation</a></code> for the destination Elasticsearch domain.
         * </p>
         * 
         * @param destinationDomainInfo
         *        Specifies the <code><a>DomainInformation</a></code> for the destination Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationDomainInfo(DomainInformation destinationDomainInfo);

        /**
         * <p>
         * Specifies the <code><a>DomainInformation</a></code> for the destination Elasticsearch domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainInformation.Builder} avoiding the
         * need to create one manually via {@link DomainInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationDomainInfo(DomainInformation)}.
         * 
         * @param destinationDomainInfo
         *        a consumer that will call methods on {@link DomainInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationDomainInfo(DomainInformation)
         */
        default Builder destinationDomainInfo(Consumer<DomainInformation.Builder> destinationDomainInfo) {
            return destinationDomainInfo(DomainInformation.builder().applyMutation(destinationDomainInfo).build());
        }

        /**
         * <p>
         * Specifies the connection id for the outbound cross-cluster search connection.
         * </p>
         * 
         * @param crossClusterSearchConnectionId
         *        Specifies the connection id for the outbound cross-cluster search connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossClusterSearchConnectionId(String crossClusterSearchConnectionId);

        /**
         * <p>
         * Specifies the connection alias for the outbound cross-cluster search connection.
         * </p>
         * 
         * @param connectionAlias
         *        Specifies the connection alias for the outbound cross-cluster search connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionAlias(String connectionAlias);

        /**
         * <p>
         * Specifies the <code><a>OutboundCrossClusterSearchConnectionStatus</a></code> for the outbound connection.
         * </p>
         * 
         * @param connectionStatus
         *        Specifies the <code><a>OutboundCrossClusterSearchConnectionStatus</a></code> for the outbound
         *        connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionStatus(OutboundCrossClusterSearchConnectionStatus connectionStatus);

        /**
         * <p>
         * Specifies the <code><a>OutboundCrossClusterSearchConnectionStatus</a></code> for the outbound connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OutboundCrossClusterSearchConnectionStatus.Builder} avoiding the need to create one manually via
         * {@link OutboundCrossClusterSearchConnectionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutboundCrossClusterSearchConnectionStatus.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #connectionStatus(OutboundCrossClusterSearchConnectionStatus)}.
         * 
         * @param connectionStatus
         *        a consumer that will call methods on {@link OutboundCrossClusterSearchConnectionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionStatus(OutboundCrossClusterSearchConnectionStatus)
         */
        default Builder connectionStatus(Consumer<OutboundCrossClusterSearchConnectionStatus.Builder> connectionStatus) {
            return connectionStatus(OutboundCrossClusterSearchConnectionStatus.builder().applyMutation(connectionStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DomainInformation sourceDomainInfo;

        private DomainInformation destinationDomainInfo;

        private String crossClusterSearchConnectionId;

        private String connectionAlias;

        private OutboundCrossClusterSearchConnectionStatus connectionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(OutboundCrossClusterSearchConnection model) {
            sourceDomainInfo(model.sourceDomainInfo);
            destinationDomainInfo(model.destinationDomainInfo);
            crossClusterSearchConnectionId(model.crossClusterSearchConnectionId);
            connectionAlias(model.connectionAlias);
            connectionStatus(model.connectionStatus);
        }

        public final DomainInformation.Builder getSourceDomainInfo() {
            return sourceDomainInfo != null ? sourceDomainInfo.toBuilder() : null;
        }

        public final void setSourceDomainInfo(DomainInformation.BuilderImpl sourceDomainInfo) {
            this.sourceDomainInfo = sourceDomainInfo != null ? sourceDomainInfo.build() : null;
        }

        @Override
        public final Builder sourceDomainInfo(DomainInformation sourceDomainInfo) {
            this.sourceDomainInfo = sourceDomainInfo;
            return this;
        }

        public final DomainInformation.Builder getDestinationDomainInfo() {
            return destinationDomainInfo != null ? destinationDomainInfo.toBuilder() : null;
        }

        public final void setDestinationDomainInfo(DomainInformation.BuilderImpl destinationDomainInfo) {
            this.destinationDomainInfo = destinationDomainInfo != null ? destinationDomainInfo.build() : null;
        }

        @Override
        public final Builder destinationDomainInfo(DomainInformation destinationDomainInfo) {
            this.destinationDomainInfo = destinationDomainInfo;
            return this;
        }

        public final String getCrossClusterSearchConnectionId() {
            return crossClusterSearchConnectionId;
        }

        public final void setCrossClusterSearchConnectionId(String crossClusterSearchConnectionId) {
            this.crossClusterSearchConnectionId = crossClusterSearchConnectionId;
        }

        @Override
        public final Builder crossClusterSearchConnectionId(String crossClusterSearchConnectionId) {
            this.crossClusterSearchConnectionId = crossClusterSearchConnectionId;
            return this;
        }

        public final String getConnectionAlias() {
            return connectionAlias;
        }

        public final void setConnectionAlias(String connectionAlias) {
            this.connectionAlias = connectionAlias;
        }

        @Override
        public final Builder connectionAlias(String connectionAlias) {
            this.connectionAlias = connectionAlias;
            return this;
        }

        public final OutboundCrossClusterSearchConnectionStatus.Builder getConnectionStatus() {
            return connectionStatus != null ? connectionStatus.toBuilder() : null;
        }

        public final void setConnectionStatus(OutboundCrossClusterSearchConnectionStatus.BuilderImpl connectionStatus) {
            this.connectionStatus = connectionStatus != null ? connectionStatus.build() : null;
        }

        @Override
        public final Builder connectionStatus(OutboundCrossClusterSearchConnectionStatus connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        @Override
        public OutboundCrossClusterSearchConnection build() {
            return new OutboundCrossClusterSearchConnection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
