/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies details of the scheduled Auto-Tune action. See the <a
 * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
 * target="_blank">Developer Guide</a> for more information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledAutoTuneDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledAutoTuneDetails.Builder, ScheduledAutoTuneDetails> {
    private static final SdkField<Instant> DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("Date")
            .getter(getter(ScheduledAutoTuneDetails::date)).setter(setter(Builder::date))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Date").build()).build();

    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionType").getter(getter(ScheduledAutoTuneDetails::actionTypeAsString))
            .setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(ScheduledAutoTuneDetails::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(ScheduledAutoTuneDetails::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_FIELD, ACTION_TYPE_FIELD,
            ACTION_FIELD, SEVERITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant date;

    private final String actionType;

    private final String action;

    private final String severity;

    private ScheduledAutoTuneDetails(BuilderImpl builder) {
        this.date = builder.date;
        this.actionType = builder.actionType;
        this.action = builder.action;
        this.severity = builder.severity;
    }

    /**
     * <p>
     * Specifies timestamp for the Auto-Tune action scheduled for the domain.
     * </p>
     * 
     * @return Specifies timestamp for the Auto-Tune action scheduled for the domain.
     */
    public final Instant date() {
        return date;
    }

    /**
     * <p>
     * Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ScheduledAutoTuneActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionTypeAsString}.
     * </p>
     * 
     * @return Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING.
     * @see ScheduledAutoTuneActionType
     */
    public final ScheduledAutoTuneActionType actionType() {
        return ScheduledAutoTuneActionType.fromValue(actionType);
    }

    /**
     * <p>
     * Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ScheduledAutoTuneActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionTypeAsString}.
     * </p>
     * 
     * @return Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING.
     * @see ScheduledAutoTuneActionType
     */
    public final String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * Specifies Auto-Tune action description.
     * </p>
     * 
     * @return Specifies Auto-Tune action description.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link ScheduledAutoTuneSeverityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #severityAsString}.
     * </p>
     * 
     * @return Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH.
     * @see ScheduledAutoTuneSeverityType
     */
    public final ScheduledAutoTuneSeverityType severity() {
        return ScheduledAutoTuneSeverityType.fromValue(severity);
    }

    /**
     * <p>
     * Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link ScheduledAutoTuneSeverityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #severityAsString}.
     * </p>
     * 
     * @return Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH.
     * @see ScheduledAutoTuneSeverityType
     */
    public final String severityAsString() {
        return severity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(date());
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledAutoTuneDetails)) {
            return false;
        }
        ScheduledAutoTuneDetails other = (ScheduledAutoTuneDetails) obj;
        return Objects.equals(date(), other.date()) && Objects.equals(actionTypeAsString(), other.actionTypeAsString())
                && Objects.equals(action(), other.action()) && Objects.equals(severityAsString(), other.severityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledAutoTuneDetails").add("Date", date()).add("ActionType", actionTypeAsString())
                .add("Action", action()).add("Severity", severityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Date":
            return Optional.ofNullable(clazz.cast(date()));
        case "ActionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Date", DATE_FIELD);
        map.put("ActionType", ACTION_TYPE_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledAutoTuneDetails, T> g) {
        return obj -> g.apply((ScheduledAutoTuneDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledAutoTuneDetails> {
        /**
         * <p>
         * Specifies timestamp for the Auto-Tune action scheduled for the domain.
         * </p>
         * 
         * @param date
         *        Specifies timestamp for the Auto-Tune action scheduled for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(Instant date);

        /**
         * <p>
         * Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING.
         * </p>
         * 
         * @param actionType
         *        Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING.
         * @see ScheduledAutoTuneActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledAutoTuneActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING.
         * </p>
         * 
         * @param actionType
         *        Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING.
         * @see ScheduledAutoTuneActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledAutoTuneActionType
         */
        Builder actionType(ScheduledAutoTuneActionType actionType);

        /**
         * <p>
         * Specifies Auto-Tune action description.
         * </p>
         * 
         * @param action
         *        Specifies Auto-Tune action description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH.
         * </p>
         * 
         * @param severity
         *        Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH.
         * @see ScheduledAutoTuneSeverityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledAutoTuneSeverityType
         */
        Builder severity(String severity);

        /**
         * <p>
         * Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH.
         * </p>
         * 
         * @param severity
         *        Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH.
         * @see ScheduledAutoTuneSeverityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledAutoTuneSeverityType
         */
        Builder severity(ScheduledAutoTuneSeverityType severity);
    }

    static final class BuilderImpl implements Builder {
        private Instant date;

        private String actionType;

        private String action;

        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledAutoTuneDetails model) {
            date(model.date);
            actionType(model.actionType);
            action(model.action);
            severity(model.severity);
        }

        public final Instant getDate() {
            return date;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ScheduledAutoTuneActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(ScheduledAutoTuneSeverityType severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        @Override
        public ScheduledAutoTuneDetails build() {
            return new ScheduledAutoTuneDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
