/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVpcEndpointRequest extends ElasticsearchRequest implements
        ToCopyableBuilder<UpdateVpcEndpointRequest.Builder, UpdateVpcEndpointRequest> {
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointId").getter(getter(UpdateVpcEndpointRequest::vpcEndpointId))
            .setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()).build();

    private static final SdkField<VPCOptions> VPC_OPTIONS_FIELD = SdkField.<VPCOptions> builder(MarshallingType.SDK_POJO)
            .memberName("VpcOptions").getter(getter(UpdateVpcEndpointRequest::vpcOptions)).setter(setter(Builder::vpcOptions))
            .constructor(VPCOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_ID_FIELD,
            VPC_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String vpcEndpointId;

    private final VPCOptions vpcOptions;

    private UpdateVpcEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.vpcEndpointId = builder.vpcEndpointId;
        this.vpcOptions = builder.vpcOptions;
    }

    /**
     * <p>
     * Unique identifier of the VPC endpoint to be updated.
     * </p>
     * 
     * @return Unique identifier of the VPC endpoint to be updated.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * The security groups and/or subnets to add, remove, or modify.
     * </p>
     * 
     * @return The security groups and/or subnets to add, remove, or modify.
     */
    public final VPCOptions vpcOptions() {
        return vpcOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVpcEndpointRequest)) {
            return false;
        }
        UpdateVpcEndpointRequest other = (UpdateVpcEndpointRequest) obj;
        return Objects.equals(vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(vpcOptions(), other.vpcOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVpcEndpointRequest").add("VpcEndpointId", vpcEndpointId()).add("VpcOptions", vpcOptions())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "VpcOptions":
            return Optional.ofNullable(clazz.cast(vpcOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("VpcOptions", VPC_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVpcEndpointRequest, T> g) {
        return obj -> g.apply((UpdateVpcEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateVpcEndpointRequest> {
        /**
         * <p>
         * Unique identifier of the VPC endpoint to be updated.
         * </p>
         * 
         * @param vpcEndpointId
         *        Unique identifier of the VPC endpoint to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * The security groups and/or subnets to add, remove, or modify.
         * </p>
         * 
         * @param vpcOptions
         *        The security groups and/or subnets to add, remove, or modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOptions(VPCOptions vpcOptions);

        /**
         * <p>
         * The security groups and/or subnets to add, remove, or modify.
         * </p>
         * This is a convenience method that creates an instance of the {@link VPCOptions.Builder} avoiding the need to
         * create one manually via {@link VPCOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VPCOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcOptions(VPCOptions)}.
         * 
         * @param vpcOptions
         *        a consumer that will call methods on {@link VPCOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcOptions(VPCOptions)
         */
        default Builder vpcOptions(Consumer<VPCOptions.Builder> vpcOptions) {
            return vpcOptions(VPCOptions.builder().applyMutation(vpcOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticsearchRequest.BuilderImpl implements Builder {
        private String vpcEndpointId;

        private VPCOptions vpcOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVpcEndpointRequest model) {
            super(model);
            vpcEndpointId(model.vpcEndpointId);
            vpcOptions(model.vpcOptions);
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final VPCOptions.Builder getVpcOptions() {
            return vpcOptions != null ? vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(VPCOptions.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(VPCOptions vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVpcEndpointRequest build() {
            return new UpdateVpcEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
