/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedElasticsearchInstancesRequest
extends ElasticsearchRequest
implements ToCopyableBuilder<Builder, DescribeReservedElasticsearchInstancesRequest> {
    private static final SdkField<String> RESERVED_ELASTICSEARCH_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedElasticsearchInstanceId").getter(DescribeReservedElasticsearchInstancesRequest.getter(DescribeReservedElasticsearchInstancesRequest::reservedElasticsearchInstanceId)).setter(DescribeReservedElasticsearchInstancesRequest.setter(Builder::reservedElasticsearchInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("reservationId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeReservedElasticsearchInstancesRequest.getter(DescribeReservedElasticsearchInstancesRequest::maxResults)).setter(DescribeReservedElasticsearchInstancesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeReservedElasticsearchInstancesRequest.getter(DescribeReservedElasticsearchInstancesRequest::nextToken)).setter(DescribeReservedElasticsearchInstancesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_ELASTICSEARCH_INSTANCE_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeReservedElasticsearchInstancesRequest.memberNameToFieldInitializer();
    private final String reservedElasticsearchInstanceId;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeReservedElasticsearchInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.reservedElasticsearchInstanceId = builder.reservedElasticsearchInstanceId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String reservedElasticsearchInstanceId() {
        return this.reservedElasticsearchInstanceId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedElasticsearchInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedElasticsearchInstancesRequest)) {
            return false;
        }
        DescribeReservedElasticsearchInstancesRequest other = (DescribeReservedElasticsearchInstancesRequest)((Object)obj);
        return Objects.equals(this.reservedElasticsearchInstanceId(), other.reservedElasticsearchInstanceId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReservedElasticsearchInstancesRequest").add("ReservedElasticsearchInstanceId", (Object)this.reservedElasticsearchInstanceId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedElasticsearchInstanceId": {
                return Optional.ofNullable(clazz.cast(this.reservedElasticsearchInstanceId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reservationId", RESERVED_ELASTICSEARCH_INSTANCE_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedElasticsearchInstancesRequest, T> g) {
        return obj -> g.apply((DescribeReservedElasticsearchInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchRequest.BuilderImpl
    implements Builder {
        private String reservedElasticsearchInstanceId;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedElasticsearchInstancesRequest model) {
            super(model);
            this.reservedElasticsearchInstanceId(model.reservedElasticsearchInstanceId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getReservedElasticsearchInstanceId() {
            return this.reservedElasticsearchInstanceId;
        }

        public final void setReservedElasticsearchInstanceId(String reservedElasticsearchInstanceId) {
            this.reservedElasticsearchInstanceId = reservedElasticsearchInstanceId;
        }

        @Override
        public final Builder reservedElasticsearchInstanceId(String reservedElasticsearchInstanceId) {
            this.reservedElasticsearchInstanceId = reservedElasticsearchInstanceId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedElasticsearchInstancesRequest build() {
            return new DescribeReservedElasticsearchInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticsearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedElasticsearchInstancesRequest> {
        public Builder reservedElasticsearchInstanceId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

