/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.AutoTune;
import software.amazon.awssdk.services.elasticsearch.model.AutoTuneListCopier;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDomainAutoTunesResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, DescribeDomainAutoTunesResponse> {
    private static final SdkField<List<AutoTune>> AUTO_TUNES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutoTunes").getter(DescribeDomainAutoTunesResponse.getter(DescribeDomainAutoTunesResponse::autoTunes)).setter(DescribeDomainAutoTunesResponse.setter(Builder::autoTunes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTunes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoTune::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeDomainAutoTunesResponse.getter(DescribeDomainAutoTunesResponse::nextToken)).setter(DescribeDomainAutoTunesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_TUNES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDomainAutoTunesResponse.memberNameToFieldInitializer();
    private final List<AutoTune> autoTunes;
    private final String nextToken;

    private DescribeDomainAutoTunesResponse(BuilderImpl builder) {
        super(builder);
        this.autoTunes = builder.autoTunes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAutoTunes() {
        return this.autoTunes != null && !(this.autoTunes instanceof SdkAutoConstructList);
    }

    public final List<AutoTune> autoTunes() {
        return this.autoTunes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoTunes() ? this.autoTunes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainAutoTunesResponse)) {
            return false;
        }
        DescribeDomainAutoTunesResponse other = (DescribeDomainAutoTunesResponse)((Object)obj);
        return this.hasAutoTunes() == other.hasAutoTunes() && Objects.equals(this.autoTunes(), other.autoTunes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDomainAutoTunesResponse").add("AutoTunes", this.hasAutoTunes() ? this.autoTunes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoTunes": {
                return Optional.ofNullable(clazz.cast(this.autoTunes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AutoTunes", AUTO_TUNES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainAutoTunesResponse, T> g) {
        return obj -> g.apply((DescribeDomainAutoTunesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private List<AutoTune> autoTunes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainAutoTunesResponse model) {
            super(model);
            this.autoTunes(model.autoTunes);
            this.nextToken(model.nextToken);
        }

        public final List<AutoTune.Builder> getAutoTunes() {
            List<AutoTune.Builder> result = AutoTuneListCopier.copyToBuilder(this.autoTunes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoTunes(Collection<AutoTune.BuilderImpl> autoTunes) {
            this.autoTunes = AutoTuneListCopier.copyFromBuilder(autoTunes);
        }

        @Override
        public final Builder autoTunes(Collection<AutoTune> autoTunes) {
            this.autoTunes = AutoTuneListCopier.copy(autoTunes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoTunes(AutoTune ... autoTunes) {
            this.autoTunes(Arrays.asList(autoTunes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoTunes(Consumer<AutoTune.Builder> ... autoTunes) {
            this.autoTunes(Stream.of(autoTunes).map(c -> (AutoTune)((AutoTune.Builder)AutoTune.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDomainAutoTunesResponse build() {
            return new DescribeDomainAutoTunesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElasticsearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDomainAutoTunesResponse> {
        public Builder autoTunes(Collection<AutoTune> var1);

        public Builder autoTunes(AutoTune ... var1);

        public Builder autoTunes(Consumer<AutoTune.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

