/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchClient;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchServiceClientConfiguration;
import software.amazon.awssdk.services.elasticsearch.internal.ElasticsearchServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.AccessDeniedException;
import software.amazon.awssdk.services.elasticsearch.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.AssociatePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.AssociatePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.AuthorizeVpcEndpointAccessRequest;
import software.amazon.awssdk.services.elasticsearch.model.AuthorizeVpcEndpointAccessResponse;
import software.amazon.awssdk.services.elasticsearch.model.BaseException;
import software.amazon.awssdk.services.elasticsearch.model.CancelDomainConfigChangeRequest;
import software.amazon.awssdk.services.elasticsearch.model.CancelDomainConfigChangeResponse;
import software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.elasticsearch.model.ConflictException;
import software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.CreatePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.CreatePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.CreateVpcEndpointRequest;
import software.amazon.awssdk.services.elasticsearch.model.CreateVpcEndpointResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchServiceRoleRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchServiceRoleResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeletePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeletePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteVpcEndpointRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteVpcEndpointResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeDomainChangeProgressRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeDomainChangeProgressResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribePackagesRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeVpcEndpointsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeVpcEndpointsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DisabledOperationException;
import software.amazon.awssdk.services.elasticsearch.model.DissociatePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.DissociatePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchException;
import software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryResponse;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusResponse;
import software.amazon.awssdk.services.elasticsearch.model.InternalException;
import software.amazon.awssdk.services.elasticsearch.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.elasticsearch.model.InvalidTypeException;
import software.amazon.awssdk.services.elasticsearch.model.LimitExceededException;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointAccessRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointAccessResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsForDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsForDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsResponse;
import software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingRequest;
import software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse;
import software.amazon.awssdk.services.elasticsearch.model.RejectInboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.elasticsearch.model.ResourceNotFoundException;
import software.amazon.awssdk.services.elasticsearch.model.RevokeVpcEndpointAccessRequest;
import software.amazon.awssdk.services.elasticsearch.model.RevokeVpcEndpointAccessResponse;
import software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpdatePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpdatePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpdateVpcEndpointRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpdateVpcEndpointResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.ValidationException;
import software.amazon.awssdk.services.elasticsearch.transform.AcceptInboundCrossClusterSearchConnectionRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.AssociatePackageRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.AuthorizeVpcEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CancelDomainConfigChangeRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CancelElasticsearchServiceSoftwareUpdateRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CreateElasticsearchDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CreateOutboundCrossClusterSearchConnectionRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CreatePackageRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CreateVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeleteElasticsearchDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeleteElasticsearchServiceRoleRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeleteInboundCrossClusterSearchConnectionRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeleteOutboundCrossClusterSearchConnectionRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeletePackageRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeleteVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeDomainAutoTunesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeDomainChangeProgressRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchDomainConfigRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchDomainsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchInstanceTypeLimitsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeInboundCrossClusterSearchConnectionsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeOutboundCrossClusterSearchConnectionsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribePackagesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeReservedElasticsearchInstanceOfferingsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeReservedElasticsearchInstancesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeVpcEndpointsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DissociatePackageRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.GetCompatibleElasticsearchVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.GetPackageVersionHistoryRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.GetUpgradeHistoryRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.GetUpgradeStatusRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListDomainNamesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListDomainsForPackageRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListElasticsearchInstanceTypesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListElasticsearchVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListPackagesForDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListVpcEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListVpcEndpointsForDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListVpcEndpointsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.PurchaseReservedElasticsearchInstanceOfferingRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.RejectInboundCrossClusterSearchConnectionRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.RevokeVpcEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.StartElasticsearchServiceSoftwareUpdateRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.UpdateElasticsearchDomainConfigRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.UpdatePackageRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.UpdateVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.UpgradeElasticsearchDomainRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultElasticsearchClient
implements ElasticsearchClient {
    private static final Logger log = Logger.loggerFor(DefaultElasticsearchClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultElasticsearchClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Elasticsearch_Service#2.32.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcceptInboundCrossClusterSearchConnectionResponse acceptInboundCrossClusterSearchConnection(AcceptInboundCrossClusterSearchConnectionRequest acceptInboundCrossClusterSearchConnectionRequest) throws ResourceNotFoundException, LimitExceededException, DisabledOperationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptInboundCrossClusterSearchConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acceptInboundCrossClusterSearchConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, acceptInboundCrossClusterSearchConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptInboundCrossClusterSearchConnection");
            AcceptInboundCrossClusterSearchConnectionResponse acceptInboundCrossClusterSearchConnectionResponse = (AcceptInboundCrossClusterSearchConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptInboundCrossClusterSearchConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)acceptInboundCrossClusterSearchConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AcceptInboundCrossClusterSearchConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acceptInboundCrossClusterSearchConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$acceptInboundCrossClusterSearchConnection$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws BaseException, LimitExceededException, ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, addTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTags");
            AddTagsResponse addTagsResponse = (AddTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$addTags$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociatePackageResponse associatePackage(AssociatePackageRequest associatePackageRequest) throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociatePackageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associatePackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, associatePackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociatePackage");
            AssociatePackageResponse associatePackageResponse = (AssociatePackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociatePackage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associatePackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociatePackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associatePackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$associatePackage$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthorizeVpcEndpointAccessResponse authorizeVpcEndpointAccess(AuthorizeVpcEndpointAccessRequest authorizeVpcEndpointAccessRequest) throws ResourceNotFoundException, DisabledOperationException, LimitExceededException, ValidationException, InternalException, BaseException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AuthorizeVpcEndpointAccessResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)authorizeVpcEndpointAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, authorizeVpcEndpointAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AuthorizeVpcEndpointAccess");
            AuthorizeVpcEndpointAccessResponse authorizeVpcEndpointAccessResponse = (AuthorizeVpcEndpointAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AuthorizeVpcEndpointAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)authorizeVpcEndpointAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AuthorizeVpcEndpointAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return authorizeVpcEndpointAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$authorizeVpcEndpointAccess$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelDomainConfigChangeResponse cancelDomainConfigChange(CancelDomainConfigChangeRequest cancelDomainConfigChangeRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, DisabledOperationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelDomainConfigChangeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelDomainConfigChangeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, cancelDomainConfigChangeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelDomainConfigChange");
            CancelDomainConfigChangeResponse cancelDomainConfigChangeResponse = (CancelDomainConfigChangeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelDomainConfigChange").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelDomainConfigChangeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelDomainConfigChangeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelDomainConfigChangeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$cancelDomainConfigChange$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelElasticsearchServiceSoftwareUpdateResponse cancelElasticsearchServiceSoftwareUpdate(CancelElasticsearchServiceSoftwareUpdateRequest cancelElasticsearchServiceSoftwareUpdateRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelElasticsearchServiceSoftwareUpdateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelElasticsearchServiceSoftwareUpdateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, cancelElasticsearchServiceSoftwareUpdateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelElasticsearchServiceSoftwareUpdate");
            CancelElasticsearchServiceSoftwareUpdateResponse cancelElasticsearchServiceSoftwareUpdateResponse = (CancelElasticsearchServiceSoftwareUpdateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelElasticsearchServiceSoftwareUpdate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelElasticsearchServiceSoftwareUpdateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelElasticsearchServiceSoftwareUpdateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelElasticsearchServiceSoftwareUpdateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$cancelElasticsearchServiceSoftwareUpdate$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateElasticsearchDomainResponse createElasticsearchDomain(CreateElasticsearchDomainRequest createElasticsearchDomainRequest) throws BaseException, DisabledOperationException, InternalException, InvalidTypeException, LimitExceededException, ResourceAlreadyExistsException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateElasticsearchDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createElasticsearchDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, createElasticsearchDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateElasticsearchDomain");
            CreateElasticsearchDomainResponse createElasticsearchDomainResponse = (CreateElasticsearchDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateElasticsearchDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createElasticsearchDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateElasticsearchDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createElasticsearchDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$createElasticsearchDomain$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateOutboundCrossClusterSearchConnectionResponse createOutboundCrossClusterSearchConnection(CreateOutboundCrossClusterSearchConnectionRequest createOutboundCrossClusterSearchConnectionRequest) throws LimitExceededException, InternalException, ResourceAlreadyExistsException, DisabledOperationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateOutboundCrossClusterSearchConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createOutboundCrossClusterSearchConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, createOutboundCrossClusterSearchConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateOutboundCrossClusterSearchConnection");
            CreateOutboundCrossClusterSearchConnectionResponse createOutboundCrossClusterSearchConnectionResponse = (CreateOutboundCrossClusterSearchConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateOutboundCrossClusterSearchConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createOutboundCrossClusterSearchConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateOutboundCrossClusterSearchConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createOutboundCrossClusterSearchConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$createOutboundCrossClusterSearchConnection$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePackageResponse createPackage(CreatePackageRequest createPackageRequest) throws BaseException, InternalException, LimitExceededException, InvalidTypeException, ResourceAlreadyExistsException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePackageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, createPackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePackage");
            CreatePackageResponse createPackageResponse = (CreatePackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePackage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$createPackage$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVpcEndpointResponse createVpcEndpoint(CreateVpcEndpointRequest createVpcEndpointRequest) throws ConflictException, ValidationException, LimitExceededException, InternalException, DisabledOperationException, BaseException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVpcEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createVpcEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, createVpcEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVpcEndpoint");
            CreateVpcEndpointResponse createVpcEndpointResponse = (CreateVpcEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVpcEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createVpcEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateVpcEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVpcEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$createVpcEndpoint$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteElasticsearchDomainResponse deleteElasticsearchDomain(DeleteElasticsearchDomainRequest deleteElasticsearchDomainRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteElasticsearchDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteElasticsearchDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, deleteElasticsearchDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteElasticsearchDomain");
            DeleteElasticsearchDomainResponse deleteElasticsearchDomainResponse = (DeleteElasticsearchDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteElasticsearchDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteElasticsearchDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteElasticsearchDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteElasticsearchDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$deleteElasticsearchDomain$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteElasticsearchServiceRoleResponse deleteElasticsearchServiceRole(DeleteElasticsearchServiceRoleRequest deleteElasticsearchServiceRoleRequest) throws BaseException, InternalException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteElasticsearchServiceRoleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteElasticsearchServiceRoleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, deleteElasticsearchServiceRoleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteElasticsearchServiceRole");
            DeleteElasticsearchServiceRoleResponse deleteElasticsearchServiceRoleResponse = (DeleteElasticsearchServiceRoleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteElasticsearchServiceRole").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteElasticsearchServiceRoleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteElasticsearchServiceRoleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteElasticsearchServiceRoleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$deleteElasticsearchServiceRole$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInboundCrossClusterSearchConnectionResponse deleteInboundCrossClusterSearchConnection(DeleteInboundCrossClusterSearchConnectionRequest deleteInboundCrossClusterSearchConnectionRequest) throws ResourceNotFoundException, DisabledOperationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInboundCrossClusterSearchConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteInboundCrossClusterSearchConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, deleteInboundCrossClusterSearchConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInboundCrossClusterSearchConnection");
            DeleteInboundCrossClusterSearchConnectionResponse deleteInboundCrossClusterSearchConnectionResponse = (DeleteInboundCrossClusterSearchConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInboundCrossClusterSearchConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteInboundCrossClusterSearchConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteInboundCrossClusterSearchConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteInboundCrossClusterSearchConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$deleteInboundCrossClusterSearchConnection$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteOutboundCrossClusterSearchConnectionResponse deleteOutboundCrossClusterSearchConnection(DeleteOutboundCrossClusterSearchConnectionRequest deleteOutboundCrossClusterSearchConnectionRequest) throws ResourceNotFoundException, DisabledOperationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteOutboundCrossClusterSearchConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteOutboundCrossClusterSearchConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, deleteOutboundCrossClusterSearchConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteOutboundCrossClusterSearchConnection");
            DeleteOutboundCrossClusterSearchConnectionResponse deleteOutboundCrossClusterSearchConnectionResponse = (DeleteOutboundCrossClusterSearchConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteOutboundCrossClusterSearchConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteOutboundCrossClusterSearchConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteOutboundCrossClusterSearchConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteOutboundCrossClusterSearchConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$deleteOutboundCrossClusterSearchConnection$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePackageResponse deletePackage(DeletePackageRequest deletePackageRequest) throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePackageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, deletePackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePackage");
            DeletePackageResponse deletePackageResponse = (DeletePackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePackage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deletePackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$deletePackage$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVpcEndpointResponse deleteVpcEndpoint(DeleteVpcEndpointRequest deleteVpcEndpointRequest) throws ResourceNotFoundException, DisabledOperationException, InternalException, BaseException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVpcEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteVpcEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, deleteVpcEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVpcEndpoint");
            DeleteVpcEndpointResponse deleteVpcEndpointResponse = (DeleteVpcEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVpcEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteVpcEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVpcEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVpcEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$deleteVpcEndpoint$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDomainAutoTunesResponse describeDomainAutoTunes(DescribeDomainAutoTunesRequest describeDomainAutoTunesRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDomainAutoTunesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDomainAutoTunesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, describeDomainAutoTunesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDomainAutoTunes");
            DescribeDomainAutoTunesResponse describeDomainAutoTunesResponse = (DescribeDomainAutoTunesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomainAutoTunes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDomainAutoTunesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDomainAutoTunesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDomainAutoTunesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$describeDomainAutoTunes$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDomainChangeProgressResponse describeDomainChangeProgress(DescribeDomainChangeProgressRequest describeDomainChangeProgressRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDomainChangeProgressResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDomainChangeProgressRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, describeDomainChangeProgressRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDomainChangeProgress");
            DescribeDomainChangeProgressResponse describeDomainChangeProgressResponse = (DescribeDomainChangeProgressResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomainChangeProgress").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDomainChangeProgressRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDomainChangeProgressRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDomainChangeProgressResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$describeDomainChangeProgress$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeElasticsearchDomainResponse describeElasticsearchDomain(DescribeElasticsearchDomainRequest describeElasticsearchDomainRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeElasticsearchDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeElasticsearchDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, describeElasticsearchDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeElasticsearchDomain");
            DescribeElasticsearchDomainResponse describeElasticsearchDomainResponse = (DescribeElasticsearchDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeElasticsearchDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeElasticsearchDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeElasticsearchDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeElasticsearchDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$describeElasticsearchDomain$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeElasticsearchDomainConfigResponse describeElasticsearchDomainConfig(DescribeElasticsearchDomainConfigRequest describeElasticsearchDomainConfigRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeElasticsearchDomainConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeElasticsearchDomainConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, describeElasticsearchDomainConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeElasticsearchDomainConfig");
            DescribeElasticsearchDomainConfigResponse describeElasticsearchDomainConfigResponse = (DescribeElasticsearchDomainConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeElasticsearchDomainConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeElasticsearchDomainConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeElasticsearchDomainConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeElasticsearchDomainConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$describeElasticsearchDomainConfig$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeElasticsearchDomainsResponse describeElasticsearchDomains(DescribeElasticsearchDomainsRequest describeElasticsearchDomainsRequest) throws BaseException, InternalException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeElasticsearchDomainsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeElasticsearchDomainsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, describeElasticsearchDomainsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeElasticsearchDomains");
            DescribeElasticsearchDomainsResponse describeElasticsearchDomainsResponse = (DescribeElasticsearchDomainsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeElasticsearchDomains").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeElasticsearchDomainsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeElasticsearchDomainsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeElasticsearchDomainsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$describeElasticsearchDomains$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeElasticsearchInstanceTypeLimitsResponse describeElasticsearchInstanceTypeLimits(DescribeElasticsearchInstanceTypeLimitsRequest describeElasticsearchInstanceTypeLimitsRequest) throws BaseException, InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeElasticsearchInstanceTypeLimitsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeElasticsearchInstanceTypeLimitsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, describeElasticsearchInstanceTypeLimitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeElasticsearchInstanceTypeLimits");
            DescribeElasticsearchInstanceTypeLimitsResponse describeElasticsearchInstanceTypeLimitsResponse = (DescribeElasticsearchInstanceTypeLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeElasticsearchInstanceTypeLimits").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeElasticsearchInstanceTypeLimitsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeElasticsearchInstanceTypeLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeElasticsearchInstanceTypeLimitsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$describeElasticsearchInstanceTypeLimits$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInboundCrossClusterSearchConnectionsResponse describeInboundCrossClusterSearchConnections(DescribeInboundCrossClusterSearchConnectionsRequest describeInboundCrossClusterSearchConnectionsRequest) throws InvalidPaginationTokenException, DisabledOperationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeInboundCrossClusterSearchConnectionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeInboundCrossClusterSearchConnectionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, describeInboundCrossClusterSearchConnectionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInboundCrossClusterSearchConnections");
            DescribeInboundCrossClusterSearchConnectionsResponse describeInboundCrossClusterSearchConnectionsResponse = (DescribeInboundCrossClusterSearchConnectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInboundCrossClusterSearchConnections").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeInboundCrossClusterSearchConnectionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeInboundCrossClusterSearchConnectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeInboundCrossClusterSearchConnectionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$describeInboundCrossClusterSearchConnections$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOutboundCrossClusterSearchConnectionsResponse describeOutboundCrossClusterSearchConnections(DescribeOutboundCrossClusterSearchConnectionsRequest describeOutboundCrossClusterSearchConnectionsRequest) throws InvalidPaginationTokenException, DisabledOperationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOutboundCrossClusterSearchConnectionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeOutboundCrossClusterSearchConnectionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, describeOutboundCrossClusterSearchConnectionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOutboundCrossClusterSearchConnections");
            DescribeOutboundCrossClusterSearchConnectionsResponse describeOutboundCrossClusterSearchConnectionsResponse = (DescribeOutboundCrossClusterSearchConnectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOutboundCrossClusterSearchConnections").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeOutboundCrossClusterSearchConnectionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOutboundCrossClusterSearchConnectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeOutboundCrossClusterSearchConnectionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$describeOutboundCrossClusterSearchConnections$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePackagesResponse describePackages(DescribePackagesRequest describePackagesRequest) throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePackagesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describePackagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, describePackagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePackages");
            DescribePackagesResponse describePackagesResponse = (DescribePackagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePackages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describePackagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePackagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePackagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$describePackages$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReservedElasticsearchInstanceOfferingsResponse describeReservedElasticsearchInstanceOfferings(DescribeReservedElasticsearchInstanceOfferingsRequest describeReservedElasticsearchInstanceOfferingsRequest) throws ResourceNotFoundException, ValidationException, DisabledOperationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReservedElasticsearchInstanceOfferingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReservedElasticsearchInstanceOfferingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, describeReservedElasticsearchInstanceOfferingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReservedElasticsearchInstanceOfferings");
            DescribeReservedElasticsearchInstanceOfferingsResponse describeReservedElasticsearchInstanceOfferingsResponse = (DescribeReservedElasticsearchInstanceOfferingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedElasticsearchInstanceOfferings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReservedElasticsearchInstanceOfferingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReservedElasticsearchInstanceOfferingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReservedElasticsearchInstanceOfferingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$describeReservedElasticsearchInstanceOfferings$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReservedElasticsearchInstancesResponse describeReservedElasticsearchInstances(DescribeReservedElasticsearchInstancesRequest describeReservedElasticsearchInstancesRequest) throws ResourceNotFoundException, InternalException, ValidationException, DisabledOperationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReservedElasticsearchInstancesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReservedElasticsearchInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, describeReservedElasticsearchInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReservedElasticsearchInstances");
            DescribeReservedElasticsearchInstancesResponse describeReservedElasticsearchInstancesResponse = (DescribeReservedElasticsearchInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedElasticsearchInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReservedElasticsearchInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReservedElasticsearchInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReservedElasticsearchInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$describeReservedElasticsearchInstances$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVpcEndpointsResponse describeVpcEndpoints(DescribeVpcEndpointsRequest describeVpcEndpointsRequest) throws ValidationException, InternalException, DisabledOperationException, BaseException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVpcEndpointsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeVpcEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, describeVpcEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVpcEndpoints");
            DescribeVpcEndpointsResponse describeVpcEndpointsResponse = (DescribeVpcEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVpcEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeVpcEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVpcEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVpcEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$describeVpcEndpoints$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DissociatePackageResponse dissociatePackage(DissociatePackageRequest dissociatePackageRequest) throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DissociatePackageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)dissociatePackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, dissociatePackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DissociatePackage");
            DissociatePackageResponse dissociatePackageResponse = (DissociatePackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DissociatePackage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)dissociatePackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DissociatePackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return dissociatePackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$dissociatePackage$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCompatibleElasticsearchVersionsResponse getCompatibleElasticsearchVersions(GetCompatibleElasticsearchVersionsRequest getCompatibleElasticsearchVersionsRequest) throws BaseException, ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCompatibleElasticsearchVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCompatibleElasticsearchVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, getCompatibleElasticsearchVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCompatibleElasticsearchVersions");
            GetCompatibleElasticsearchVersionsResponse getCompatibleElasticsearchVersionsResponse = (GetCompatibleElasticsearchVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCompatibleElasticsearchVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCompatibleElasticsearchVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCompatibleElasticsearchVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCompatibleElasticsearchVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$getCompatibleElasticsearchVersions$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPackageVersionHistoryResponse getPackageVersionHistory(GetPackageVersionHistoryRequest getPackageVersionHistoryRequest) throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPackageVersionHistoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPackageVersionHistoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, getPackageVersionHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPackageVersionHistory");
            GetPackageVersionHistoryResponse getPackageVersionHistoryResponse = (GetPackageVersionHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPackageVersionHistory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPackageVersionHistoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPackageVersionHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPackageVersionHistoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$getPackageVersionHistory$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUpgradeHistoryResponse getUpgradeHistory(GetUpgradeHistoryRequest getUpgradeHistoryRequest) throws BaseException, ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUpgradeHistoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getUpgradeHistoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, getUpgradeHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUpgradeHistory");
            GetUpgradeHistoryResponse getUpgradeHistoryResponse = (GetUpgradeHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUpgradeHistory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getUpgradeHistoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetUpgradeHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUpgradeHistoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$getUpgradeHistory$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUpgradeStatusResponse getUpgradeStatus(GetUpgradeStatusRequest getUpgradeStatusRequest) throws BaseException, ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUpgradeStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getUpgradeStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, getUpgradeStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUpgradeStatus");
            GetUpgradeStatusResponse getUpgradeStatusResponse = (GetUpgradeStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUpgradeStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getUpgradeStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetUpgradeStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUpgradeStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$getUpgradeStatus$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainNamesResponse listDomainNames(ListDomainNamesRequest listDomainNamesRequest) throws BaseException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainNamesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDomainNamesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, listDomainNamesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDomainNames");
            ListDomainNamesResponse listDomainNamesResponse = (ListDomainNamesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomainNames").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDomainNamesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDomainNamesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDomainNamesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$listDomainNames$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainsForPackageResponse listDomainsForPackage(ListDomainsForPackageRequest listDomainsForPackageRequest) throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainsForPackageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDomainsForPackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, listDomainsForPackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDomainsForPackage");
            ListDomainsForPackageResponse listDomainsForPackageResponse = (ListDomainsForPackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomainsForPackage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDomainsForPackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDomainsForPackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDomainsForPackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$listDomainsForPackage$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListElasticsearchInstanceTypesResponse listElasticsearchInstanceTypes(ListElasticsearchInstanceTypesRequest listElasticsearchInstanceTypesRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListElasticsearchInstanceTypesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listElasticsearchInstanceTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, listElasticsearchInstanceTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListElasticsearchInstanceTypes");
            ListElasticsearchInstanceTypesResponse listElasticsearchInstanceTypesResponse = (ListElasticsearchInstanceTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListElasticsearchInstanceTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listElasticsearchInstanceTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListElasticsearchInstanceTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listElasticsearchInstanceTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$listElasticsearchInstanceTypes$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListElasticsearchVersionsResponse listElasticsearchVersions(ListElasticsearchVersionsRequest listElasticsearchVersionsRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListElasticsearchVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listElasticsearchVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, listElasticsearchVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListElasticsearchVersions");
            ListElasticsearchVersionsResponse listElasticsearchVersionsResponse = (ListElasticsearchVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListElasticsearchVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listElasticsearchVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListElasticsearchVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listElasticsearchVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$listElasticsearchVersions$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPackagesForDomainResponse listPackagesForDomain(ListPackagesForDomainRequest listPackagesForDomainRequest) throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPackagesForDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPackagesForDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, listPackagesForDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPackagesForDomain");
            ListPackagesForDomainResponse listPackagesForDomainResponse = (ListPackagesForDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPackagesForDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPackagesForDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPackagesForDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPackagesForDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$listPackagesForDomain$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws BaseException, ResourceNotFoundException, ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, listTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTags");
            ListTagsResponse listTagsResponse = (ListTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$listTags$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVpcEndpointAccessResponse listVpcEndpointAccess(ListVpcEndpointAccessRequest listVpcEndpointAccessRequest) throws ResourceNotFoundException, DisabledOperationException, InternalException, BaseException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVpcEndpointAccessResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listVpcEndpointAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, listVpcEndpointAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVpcEndpointAccess");
            ListVpcEndpointAccessResponse listVpcEndpointAccessResponse = (ListVpcEndpointAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVpcEndpointAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listVpcEndpointAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVpcEndpointAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVpcEndpointAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$listVpcEndpointAccess$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVpcEndpointsResponse listVpcEndpoints(ListVpcEndpointsRequest listVpcEndpointsRequest) throws InternalException, DisabledOperationException, BaseException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVpcEndpointsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listVpcEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, listVpcEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVpcEndpoints");
            ListVpcEndpointsResponse listVpcEndpointsResponse = (ListVpcEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVpcEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listVpcEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVpcEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVpcEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$listVpcEndpoints$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVpcEndpointsForDomainResponse listVpcEndpointsForDomain(ListVpcEndpointsForDomainRequest listVpcEndpointsForDomainRequest) throws InternalException, DisabledOperationException, ResourceNotFoundException, BaseException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVpcEndpointsForDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listVpcEndpointsForDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, listVpcEndpointsForDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVpcEndpointsForDomain");
            ListVpcEndpointsForDomainResponse listVpcEndpointsForDomainResponse = (ListVpcEndpointsForDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVpcEndpointsForDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listVpcEndpointsForDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVpcEndpointsForDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVpcEndpointsForDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$listVpcEndpointsForDomain$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PurchaseReservedElasticsearchInstanceOfferingResponse purchaseReservedElasticsearchInstanceOffering(PurchaseReservedElasticsearchInstanceOfferingRequest purchaseReservedElasticsearchInstanceOfferingRequest) throws ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, DisabledOperationException, ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PurchaseReservedElasticsearchInstanceOfferingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)purchaseReservedElasticsearchInstanceOfferingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, purchaseReservedElasticsearchInstanceOfferingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PurchaseReservedElasticsearchInstanceOffering");
            PurchaseReservedElasticsearchInstanceOfferingResponse purchaseReservedElasticsearchInstanceOfferingResponse = (PurchaseReservedElasticsearchInstanceOfferingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PurchaseReservedElasticsearchInstanceOffering").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)purchaseReservedElasticsearchInstanceOfferingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PurchaseReservedElasticsearchInstanceOfferingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return purchaseReservedElasticsearchInstanceOfferingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$purchaseReservedElasticsearchInstanceOffering$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RejectInboundCrossClusterSearchConnectionResponse rejectInboundCrossClusterSearchConnection(RejectInboundCrossClusterSearchConnectionRequest rejectInboundCrossClusterSearchConnectionRequest) throws ResourceNotFoundException, DisabledOperationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectInboundCrossClusterSearchConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rejectInboundCrossClusterSearchConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, rejectInboundCrossClusterSearchConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectInboundCrossClusterSearchConnection");
            RejectInboundCrossClusterSearchConnectionResponse rejectInboundCrossClusterSearchConnectionResponse = (RejectInboundCrossClusterSearchConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectInboundCrossClusterSearchConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rejectInboundCrossClusterSearchConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RejectInboundCrossClusterSearchConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rejectInboundCrossClusterSearchConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$rejectInboundCrossClusterSearchConnection$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws BaseException, ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, removeTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTags");
            RemoveTagsResponse removeTagsResponse = (RemoveTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$removeTags$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevokeVpcEndpointAccessResponse revokeVpcEndpointAccess(RevokeVpcEndpointAccessRequest revokeVpcEndpointAccessRequest) throws ResourceNotFoundException, ValidationException, DisabledOperationException, InternalException, BaseException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokeVpcEndpointAccessResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)revokeVpcEndpointAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, revokeVpcEndpointAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokeVpcEndpointAccess");
            RevokeVpcEndpointAccessResponse revokeVpcEndpointAccessResponse = (RevokeVpcEndpointAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeVpcEndpointAccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)revokeVpcEndpointAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RevokeVpcEndpointAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return revokeVpcEndpointAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$revokeVpcEndpointAccess$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartElasticsearchServiceSoftwareUpdateResponse startElasticsearchServiceSoftwareUpdate(StartElasticsearchServiceSoftwareUpdateRequest startElasticsearchServiceSoftwareUpdateRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartElasticsearchServiceSoftwareUpdateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startElasticsearchServiceSoftwareUpdateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, startElasticsearchServiceSoftwareUpdateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartElasticsearchServiceSoftwareUpdate");
            StartElasticsearchServiceSoftwareUpdateResponse startElasticsearchServiceSoftwareUpdateResponse = (StartElasticsearchServiceSoftwareUpdateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartElasticsearchServiceSoftwareUpdate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startElasticsearchServiceSoftwareUpdateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartElasticsearchServiceSoftwareUpdateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startElasticsearchServiceSoftwareUpdateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$startElasticsearchServiceSoftwareUpdate$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateElasticsearchDomainConfigResponse updateElasticsearchDomainConfig(UpdateElasticsearchDomainConfigRequest updateElasticsearchDomainConfigRequest) throws BaseException, InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateElasticsearchDomainConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateElasticsearchDomainConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, updateElasticsearchDomainConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateElasticsearchDomainConfig");
            UpdateElasticsearchDomainConfigResponse updateElasticsearchDomainConfigResponse = (UpdateElasticsearchDomainConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateElasticsearchDomainConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateElasticsearchDomainConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateElasticsearchDomainConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateElasticsearchDomainConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$updateElasticsearchDomainConfig$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePackageResponse updatePackage(UpdatePackageRequest updatePackageRequest) throws BaseException, InternalException, LimitExceededException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePackageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, updatePackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePackage");
            UpdatePackageResponse updatePackageResponse = (UpdatePackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePackage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updatePackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$updatePackage$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateVpcEndpointResponse updateVpcEndpoint(UpdateVpcEndpointRequest updateVpcEndpointRequest) throws ResourceNotFoundException, DisabledOperationException, InternalException, ValidationException, ConflictException, BaseException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVpcEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateVpcEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, updateVpcEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVpcEndpoint");
            UpdateVpcEndpointResponse updateVpcEndpointResponse = (UpdateVpcEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVpcEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateVpcEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateVpcEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateVpcEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$updateVpcEndpoint$99((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpgradeElasticsearchDomainResponse upgradeElasticsearchDomain(UpgradeElasticsearchDomainRequest upgradeElasticsearchDomainRequest) throws BaseException, ResourceNotFoundException, ResourceAlreadyExistsException, DisabledOperationException, ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpgradeElasticsearchDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidTypeException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BaseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)upgradeElasticsearchDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticsearchClient.resolveMetricPublishers(clientConfiguration, upgradeElasticsearchDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpgradeElasticsearchDomain");
            UpgradeElasticsearchDomainResponse upgradeElasticsearchDomainResponse = (UpgradeElasticsearchDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpgradeElasticsearchDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)upgradeElasticsearchDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpgradeElasticsearchDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return upgradeElasticsearchDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticsearchClient.lambda$upgradeElasticsearchDomain$101((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "es";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        ElasticsearchServiceClientConfigurationBuilder serviceConfigBuilder = new ElasticsearchServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ElasticsearchException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final ElasticsearchServiceClientConfiguration serviceClientConfiguration() {
        return new ElasticsearchServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$upgradeElasticsearchDomain$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateVpcEndpoint$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePackage$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateElasticsearchDomainConfig$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startElasticsearchServiceSoftwareUpdate$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$revokeVpcEndpointAccess$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeTags$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rejectInboundCrossClusterSearchConnection$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$purchaseReservedElasticsearchInstanceOffering$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVpcEndpointsForDomain$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVpcEndpoints$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVpcEndpointAccess$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTags$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPackagesForDomain$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listElasticsearchVersions$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listElasticsearchInstanceTypes$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDomainsForPackage$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDomainNames$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUpgradeStatus$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUpgradeHistory$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPackageVersionHistory$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCompatibleElasticsearchVersions$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$dissociatePackage$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVpcEndpoints$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReservedElasticsearchInstances$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReservedElasticsearchInstanceOfferings$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePackages$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeOutboundCrossClusterSearchConnections$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeInboundCrossClusterSearchConnections$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeElasticsearchInstanceTypeLimits$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeElasticsearchDomains$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeElasticsearchDomainConfig$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeElasticsearchDomain$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDomainChangeProgress$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDomainAutoTunes$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVpcEndpoint$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePackage$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteOutboundCrossClusterSearchConnection$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteInboundCrossClusterSearchConnection$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteElasticsearchServiceRole$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteElasticsearchDomain$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVpcEndpoint$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPackage$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createOutboundCrossClusterSearchConnection$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createElasticsearchDomain$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelElasticsearchServiceSoftwareUpdate$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelDomainConfigChange$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$authorizeVpcEndpointAccess$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associatePackage$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addTags$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acceptInboundCrossClusterSearchConnection$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

