/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for results from <code>DescribeReservedElasticsearchInstanceOfferings</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedElasticsearchInstanceOfferingsResponse extends ElasticsearchResponse
        implements
        ToCopyableBuilder<DescribeReservedElasticsearchInstanceOfferingsResponse.Builder, DescribeReservedElasticsearchInstanceOfferingsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeReservedElasticsearchInstanceOfferingsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ReservedElasticsearchInstanceOffering>> RESERVED_ELASTICSEARCH_INSTANCE_OFFERINGS_FIELD = SdkField
            .<List<ReservedElasticsearchInstanceOffering>> builder(MarshallingType.LIST)
            .memberName("ReservedElasticsearchInstanceOfferings")
            .getter(getter(DescribeReservedElasticsearchInstanceOfferingsResponse::reservedElasticsearchInstanceOfferings))
            .setter(setter(Builder::reservedElasticsearchInstanceOfferings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReservedElasticsearchInstanceOfferings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReservedElasticsearchInstanceOffering> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedElasticsearchInstanceOffering::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESERVED_ELASTICSEARCH_INSTANCE_OFFERINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ReservedElasticsearchInstanceOffering> reservedElasticsearchInstanceOfferings;

    private DescribeReservedElasticsearchInstanceOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservedElasticsearchInstanceOfferings = builder.reservedElasticsearchInstanceOfferings;
    }

    /**
     * <p>
     * Provides an identifier to allow retrieval of paginated results.
     * </p>
     * 
     * @return Provides an identifier to allow retrieval of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReservedElasticsearchInstanceOfferings
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasReservedElasticsearchInstanceOfferings() {
        return reservedElasticsearchInstanceOfferings != null
                && !(reservedElasticsearchInstanceOfferings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of reserved Elasticsearch instance offerings
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReservedElasticsearchInstanceOfferings}
     * method.
     * </p>
     * 
     * @return List of reserved Elasticsearch instance offerings
     */
    public final List<ReservedElasticsearchInstanceOffering> reservedElasticsearchInstanceOfferings() {
        return reservedElasticsearchInstanceOfferings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReservedElasticsearchInstanceOfferings() ? reservedElasticsearchInstanceOfferings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedElasticsearchInstanceOfferingsResponse)) {
            return false;
        }
        DescribeReservedElasticsearchInstanceOfferingsResponse other = (DescribeReservedElasticsearchInstanceOfferingsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasReservedElasticsearchInstanceOfferings() == other.hasReservedElasticsearchInstanceOfferings()
                && Objects.equals(reservedElasticsearchInstanceOfferings(), other.reservedElasticsearchInstanceOfferings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeReservedElasticsearchInstanceOfferingsResponse")
                .add("NextToken", nextToken())
                .add("ReservedElasticsearchInstanceOfferings",
                        hasReservedElasticsearchInstanceOfferings() ? reservedElasticsearchInstanceOfferings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ReservedElasticsearchInstanceOfferings":
            return Optional.ofNullable(clazz.cast(reservedElasticsearchInstanceOfferings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ReservedElasticsearchInstanceOfferings", RESERVED_ELASTICSEARCH_INSTANCE_OFFERINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedElasticsearchInstanceOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeReservedElasticsearchInstanceOfferingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReservedElasticsearchInstanceOfferingsResponse> {
        /**
         * <p>
         * Provides an identifier to allow retrieval of paginated results.
         * </p>
         * 
         * @param nextToken
         *        Provides an identifier to allow retrieval of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * List of reserved Elasticsearch instance offerings
         * </p>
         * 
         * @param reservedElasticsearchInstanceOfferings
         *        List of reserved Elasticsearch instance offerings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedElasticsearchInstanceOfferings(
                Collection<ReservedElasticsearchInstanceOffering> reservedElasticsearchInstanceOfferings);

        /**
         * <p>
         * List of reserved Elasticsearch instance offerings
         * </p>
         * 
         * @param reservedElasticsearchInstanceOfferings
         *        List of reserved Elasticsearch instance offerings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedElasticsearchInstanceOfferings(
                ReservedElasticsearchInstanceOffering... reservedElasticsearchInstanceOfferings);

        /**
         * <p>
         * List of reserved Elasticsearch instance offerings
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstanceOffering.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstanceOffering#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstanceOffering.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #reservedElasticsearchInstanceOfferings(List<ReservedElasticsearchInstanceOffering>)}.
         * 
         * @param reservedElasticsearchInstanceOfferings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstanceOffering.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedElasticsearchInstanceOfferings(java.util.Collection<ReservedElasticsearchInstanceOffering>)
         */
        Builder reservedElasticsearchInstanceOfferings(
                Consumer<ReservedElasticsearchInstanceOffering.Builder>... reservedElasticsearchInstanceOfferings);
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ReservedElasticsearchInstanceOffering> reservedElasticsearchInstanceOfferings = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedElasticsearchInstanceOfferingsResponse model) {
            super(model);
            nextToken(model.nextToken);
            reservedElasticsearchInstanceOfferings(model.reservedElasticsearchInstanceOfferings);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ReservedElasticsearchInstanceOffering.Builder> getReservedElasticsearchInstanceOfferings() {
            List<ReservedElasticsearchInstanceOffering.Builder> result = ReservedElasticsearchInstanceOfferingListCopier
                    .copyToBuilder(this.reservedElasticsearchInstanceOfferings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedElasticsearchInstanceOfferings(
                Collection<ReservedElasticsearchInstanceOffering.BuilderImpl> reservedElasticsearchInstanceOfferings) {
            this.reservedElasticsearchInstanceOfferings = ReservedElasticsearchInstanceOfferingListCopier
                    .copyFromBuilder(reservedElasticsearchInstanceOfferings);
        }

        @Override
        public final Builder reservedElasticsearchInstanceOfferings(
                Collection<ReservedElasticsearchInstanceOffering> reservedElasticsearchInstanceOfferings) {
            this.reservedElasticsearchInstanceOfferings = ReservedElasticsearchInstanceOfferingListCopier
                    .copy(reservedElasticsearchInstanceOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedElasticsearchInstanceOfferings(
                ReservedElasticsearchInstanceOffering... reservedElasticsearchInstanceOfferings) {
            reservedElasticsearchInstanceOfferings(Arrays.asList(reservedElasticsearchInstanceOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedElasticsearchInstanceOfferings(
                Consumer<ReservedElasticsearchInstanceOffering.Builder>... reservedElasticsearchInstanceOfferings) {
            reservedElasticsearchInstanceOfferings(Stream.of(reservedElasticsearchInstanceOfferings)
                    .map(c -> ReservedElasticsearchInstanceOffering.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReservedElasticsearchInstanceOfferingsResponse build() {
            return new DescribeReservedElasticsearchInstanceOfferingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
