/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>StartElasticsearchServiceSoftwareUpdate</code> operation. Contains the status of the update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartElasticsearchServiceSoftwareUpdateResponse extends ElasticsearchResponse
        implements
        ToCopyableBuilder<StartElasticsearchServiceSoftwareUpdateResponse.Builder, StartElasticsearchServiceSoftwareUpdateResponse> {
    private static final SdkField<ServiceSoftwareOptions> SERVICE_SOFTWARE_OPTIONS_FIELD = SdkField
            .<ServiceSoftwareOptions> builder(MarshallingType.SDK_POJO).memberName("ServiceSoftwareOptions")
            .getter(getter(StartElasticsearchServiceSoftwareUpdateResponse::serviceSoftwareOptions))
            .setter(setter(Builder::serviceSoftwareOptions)).constructor(ServiceSoftwareOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSoftwareOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SERVICE_SOFTWARE_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ServiceSoftwareOptions serviceSoftwareOptions;

    private StartElasticsearchServiceSoftwareUpdateResponse(BuilderImpl builder) {
        super(builder);
        this.serviceSoftwareOptions = builder.serviceSoftwareOptions;
    }

    /**
     * <p>
     * The current status of the Elasticsearch service software update.
     * </p>
     * 
     * @return The current status of the Elasticsearch service software update.
     */
    public final ServiceSoftwareOptions serviceSoftwareOptions() {
        return serviceSoftwareOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceSoftwareOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartElasticsearchServiceSoftwareUpdateResponse)) {
            return false;
        }
        StartElasticsearchServiceSoftwareUpdateResponse other = (StartElasticsearchServiceSoftwareUpdateResponse) obj;
        return Objects.equals(serviceSoftwareOptions(), other.serviceSoftwareOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartElasticsearchServiceSoftwareUpdateResponse")
                .add("ServiceSoftwareOptions", serviceSoftwareOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceSoftwareOptions":
            return Optional.ofNullable(clazz.cast(serviceSoftwareOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceSoftwareOptions", SERVICE_SOFTWARE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartElasticsearchServiceSoftwareUpdateResponse, T> g) {
        return obj -> g.apply((StartElasticsearchServiceSoftwareUpdateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartElasticsearchServiceSoftwareUpdateResponse> {
        /**
         * <p>
         * The current status of the Elasticsearch service software update.
         * </p>
         * 
         * @param serviceSoftwareOptions
         *        The current status of the Elasticsearch service software update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSoftwareOptions(ServiceSoftwareOptions serviceSoftwareOptions);

        /**
         * <p>
         * The current status of the Elasticsearch service software update.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceSoftwareOptions.Builder} avoiding
         * the need to create one manually via {@link ServiceSoftwareOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceSoftwareOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceSoftwareOptions(ServiceSoftwareOptions)}.
         * 
         * @param serviceSoftwareOptions
         *        a consumer that will call methods on {@link ServiceSoftwareOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceSoftwareOptions(ServiceSoftwareOptions)
         */
        default Builder serviceSoftwareOptions(Consumer<ServiceSoftwareOptions.Builder> serviceSoftwareOptions) {
            return serviceSoftwareOptions(ServiceSoftwareOptions.builder().applyMutation(serviceSoftwareOptions).build());
        }
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private ServiceSoftwareOptions serviceSoftwareOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(StartElasticsearchServiceSoftwareUpdateResponse model) {
            super(model);
            serviceSoftwareOptions(model.serviceSoftwareOptions);
        }

        public final ServiceSoftwareOptions.Builder getServiceSoftwareOptions() {
            return serviceSoftwareOptions != null ? serviceSoftwareOptions.toBuilder() : null;
        }

        public final void setServiceSoftwareOptions(ServiceSoftwareOptions.BuilderImpl serviceSoftwareOptions) {
            this.serviceSoftwareOptions = serviceSoftwareOptions != null ? serviceSoftwareOptions.build() : null;
        }

        @Override
        public final Builder serviceSoftwareOptions(ServiceSoftwareOptions serviceSoftwareOptions) {
            this.serviceSoftwareOptions = serviceSoftwareOptions;
            return this;
        }

        @Override
        public StartElasticsearchServiceSoftwareUpdateResponse build() {
            return new StartElasticsearchServiceSoftwareUpdateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
