/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>DescribeElasticsearchDomains</code> request. Contains the status of the specified domains or
 * all domains owned by the account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeElasticsearchDomainsResponse extends ElasticsearchResponse implements
        ToCopyableBuilder<DescribeElasticsearchDomainsResponse.Builder, DescribeElasticsearchDomainsResponse> {
    private static final SdkField<List<ElasticsearchDomainStatus>> DOMAIN_STATUS_LIST_FIELD = SdkField
            .<List<ElasticsearchDomainStatus>> builder(MarshallingType.LIST)
            .memberName("DomainStatusList")
            .getter(getter(DescribeElasticsearchDomainsResponse::domainStatusList))
            .setter(setter(Builder::domainStatusList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainStatusList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ElasticsearchDomainStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(ElasticsearchDomainStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_STATUS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ElasticsearchDomainStatus> domainStatusList;

    private DescribeElasticsearchDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.domainStatusList = builder.domainStatusList;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainStatusList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDomainStatusList() {
        return domainStatusList != null && !(domainStatusList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainStatusList} method.
     * </p>
     * 
     * @return The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.
     */
    public final List<ElasticsearchDomainStatus> domainStatusList() {
        return domainStatusList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainStatusList() ? domainStatusList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticsearchDomainsResponse)) {
            return false;
        }
        DescribeElasticsearchDomainsResponse other = (DescribeElasticsearchDomainsResponse) obj;
        return hasDomainStatusList() == other.hasDomainStatusList()
                && Objects.equals(domainStatusList(), other.domainStatusList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeElasticsearchDomainsResponse")
                .add("DomainStatusList", hasDomainStatusList() ? domainStatusList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainStatusList":
            return Optional.ofNullable(clazz.cast(domainStatusList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainStatusList", DOMAIN_STATUS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeElasticsearchDomainsResponse, T> g) {
        return obj -> g.apply((DescribeElasticsearchDomainsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeElasticsearchDomainsResponse> {
        /**
         * <p>
         * The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.
         * </p>
         * 
         * @param domainStatusList
         *        The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainStatusList(Collection<ElasticsearchDomainStatus> domainStatusList);

        /**
         * <p>
         * The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.
         * </p>
         * 
         * @param domainStatusList
         *        The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainStatusList(ElasticsearchDomainStatus... domainStatusList);

        /**
         * <p>
         * The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatus.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatus.Builder#build()} is
         * called immediately and its result is passed to {@link #domainStatusList(List<ElasticsearchDomainStatus>)}.
         * 
         * @param domainStatusList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainStatusList(java.util.Collection<ElasticsearchDomainStatus>)
         */
        Builder domainStatusList(Consumer<ElasticsearchDomainStatus.Builder>... domainStatusList);
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private List<ElasticsearchDomainStatus> domainStatusList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticsearchDomainsResponse model) {
            super(model);
            domainStatusList(model.domainStatusList);
        }

        public final List<ElasticsearchDomainStatus.Builder> getDomainStatusList() {
            List<ElasticsearchDomainStatus.Builder> result = ElasticsearchDomainStatusListCopier
                    .copyToBuilder(this.domainStatusList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainStatusList(Collection<ElasticsearchDomainStatus.BuilderImpl> domainStatusList) {
            this.domainStatusList = ElasticsearchDomainStatusListCopier.copyFromBuilder(domainStatusList);
        }

        @Override
        public final Builder domainStatusList(Collection<ElasticsearchDomainStatus> domainStatusList) {
            this.domainStatusList = ElasticsearchDomainStatusListCopier.copy(domainStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainStatusList(ElasticsearchDomainStatus... domainStatusList) {
            domainStatusList(Arrays.asList(domainStatusList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainStatusList(Consumer<ElasticsearchDomainStatus.Builder>... domainStatusList) {
            domainStatusList(Stream.of(domainStatusList).map(c -> ElasticsearchDomainStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeElasticsearchDomainsResponse build() {
            return new DescribeElasticsearchDomainsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
