/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for request parameters to <code> <a>UpgradeElasticsearchDomain</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpgradeElasticsearchDomainRequest extends ElasticsearchRequest implements
        ToCopyableBuilder<UpgradeElasticsearchDomainRequest.Builder, UpgradeElasticsearchDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(UpgradeElasticsearchDomainRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetVersion").getter(getter(UpgradeElasticsearchDomainRequest::targetVersion))
            .setter(setter(Builder::targetVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVersion").build()).build();

    private static final SdkField<Boolean> PERFORM_CHECK_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PerformCheckOnly").getter(getter(UpgradeElasticsearchDomainRequest::performCheckOnly))
            .setter(setter(Builder::performCheckOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformCheckOnly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            TARGET_VERSION_FIELD, PERFORM_CHECK_ONLY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String targetVersion;

    private final Boolean performCheckOnly;

    private UpgradeElasticsearchDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.targetVersion = builder.targetVersion;
        this.performCheckOnly = builder.performCheckOnly;
    }

    /**
     * Returns the value of the DomainName property for this object.
     * 
     * @return The value of the DomainName property for this object.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The version of Elasticsearch that you intend to upgrade the domain to.
     * </p>
     * 
     * @return The version of Elasticsearch that you intend to upgrade the domain to.
     */
    public final String targetVersion() {
        return targetVersion;
    }

    /**
     * <p>
     * This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This will not
     * actually perform the Upgrade.
     * </p>
     * 
     * @return This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This will
     *         not actually perform the Upgrade.
     */
    public final Boolean performCheckOnly() {
        return performCheckOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(performCheckOnly());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeElasticsearchDomainRequest)) {
            return false;
        }
        UpgradeElasticsearchDomainRequest other = (UpgradeElasticsearchDomainRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(targetVersion(), other.targetVersion())
                && Objects.equals(performCheckOnly(), other.performCheckOnly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpgradeElasticsearchDomainRequest").add("DomainName", domainName())
                .add("TargetVersion", targetVersion()).add("PerformCheckOnly", performCheckOnly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "TargetVersion":
            return Optional.ofNullable(clazz.cast(targetVersion()));
        case "PerformCheckOnly":
            return Optional.ofNullable(clazz.cast(performCheckOnly()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("TargetVersion", TARGET_VERSION_FIELD);
        map.put("PerformCheckOnly", PERFORM_CHECK_ONLY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpgradeElasticsearchDomainRequest, T> g) {
        return obj -> g.apply((UpgradeElasticsearchDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElasticsearchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpgradeElasticsearchDomainRequest> {
        /**
         * Sets the value of the DomainName property for this object.
         *
         * @param domainName
         *        The new value for the DomainName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The version of Elasticsearch that you intend to upgrade the domain to.
         * </p>
         * 
         * @param targetVersion
         *        The version of Elasticsearch that you intend to upgrade the domain to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVersion(String targetVersion);

        /**
         * <p>
         * This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This will not
         * actually perform the Upgrade.
         * </p>
         * 
         * @param performCheckOnly
         *        This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This
         *        will not actually perform the Upgrade.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performCheckOnly(Boolean performCheckOnly);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticsearchRequest.BuilderImpl implements Builder {
        private String domainName;

        private String targetVersion;

        private Boolean performCheckOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeElasticsearchDomainRequest model) {
            super(model);
            domainName(model.domainName);
            targetVersion(model.targetVersion);
            performCheckOnly(model.performCheckOnly);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getTargetVersion() {
            return targetVersion;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final Boolean getPerformCheckOnly() {
            return performCheckOnly;
        }

        public final void setPerformCheckOnly(Boolean performCheckOnly) {
            this.performCheckOnly = performCheckOnly;
        }

        @Override
        public final Builder performCheckOnly(Boolean performCheckOnly) {
            this.performCheckOnly = performCheckOnly;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpgradeElasticsearchDomainRequest build() {
            return new UpgradeElasticsearchDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
