/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connection endpoint for connecting to an Amazon OpenSearch Service domain through a proxy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcEndpoint implements SdkPojo, Serializable, ToCopyableBuilder<VpcEndpoint.Builder, VpcEndpoint> {
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointId").getter(getter(VpcEndpoint::vpcEndpointId)).setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointOwner").getter(getter(VpcEndpoint::vpcEndpointOwner))
            .setter(setter(Builder::vpcEndpointOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointOwner").build()).build();

    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainArn").getter(getter(VpcEndpoint::domainArn)).setter(setter(Builder::domainArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainArn").build()).build();

    private static final SdkField<VPCDerivedInfo> VPC_OPTIONS_FIELD = SdkField.<VPCDerivedInfo> builder(MarshallingType.SDK_POJO)
            .memberName("VpcOptions").getter(getter(VpcEndpoint::vpcOptions)).setter(setter(Builder::vpcOptions))
            .constructor(VPCDerivedInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOptions").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(VpcEndpoint::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Endpoint").getter(getter(VpcEndpoint::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_ID_FIELD,
            VPC_ENDPOINT_OWNER_FIELD, DOMAIN_ARN_FIELD, VPC_OPTIONS_FIELD, STATUS_FIELD, ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vpcEndpointId;

    private final String vpcEndpointOwner;

    private final String domainArn;

    private final VPCDerivedInfo vpcOptions;

    private final String status;

    private final String endpoint;

    private VpcEndpoint(BuilderImpl builder) {
        this.vpcEndpointId = builder.vpcEndpointId;
        this.vpcEndpointOwner = builder.vpcEndpointOwner;
        this.domainArn = builder.domainArn;
        this.vpcOptions = builder.vpcOptions;
        this.status = builder.status;
        this.endpoint = builder.endpoint;
    }

    /**
     * <p>
     * The unique identifier of the endpoint.
     * </p>
     * 
     * @return The unique identifier of the endpoint.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * The creator of the endpoint.
     * </p>
     * 
     * @return The creator of the endpoint.
     */
    public final String vpcEndpointOwner() {
        return vpcEndpointOwner;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the domain associated with the endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the domain associated with the endpoint.
     */
    public final String domainArn() {
        return domainArn;
    }

    /**
     * <p>
     * Options to specify the subnets and security groups for an Amazon OpenSearch Service VPC endpoint.
     * </p>
     * 
     * @return Options to specify the subnets and security groups for an Amazon OpenSearch Service VPC endpoint.
     */
    public final VPCDerivedInfo vpcOptions() {
        return vpcOptions;
    }

    /**
     * <p>
     * The current status of the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VpcEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the endpoint.
     * @see VpcEndpointStatus
     */
    public final VpcEndpointStatus status() {
        return VpcEndpointStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VpcEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the endpoint.
     * @see VpcEndpointStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The connection endpoint ID for connecting to the domain.
     * </p>
     * 
     * @return The connection endpoint ID for connecting to the domain.
     */
    public final String endpoint() {
        return endpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointOwner());
        hashCode = 31 * hashCode + Objects.hashCode(domainArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpoint)) {
            return false;
        }
        VpcEndpoint other = (VpcEndpoint) obj;
        return Objects.equals(vpcEndpointId(), other.vpcEndpointId())
                && Objects.equals(vpcEndpointOwner(), other.vpcEndpointOwner()) && Objects.equals(domainArn(), other.domainArn())
                && Objects.equals(vpcOptions(), other.vpcOptions()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(endpoint(), other.endpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcEndpoint").add("VpcEndpointId", vpcEndpointId()).add("VpcEndpointOwner", vpcEndpointOwner())
                .add("DomainArn", domainArn()).add("VpcOptions", vpcOptions()).add("Status", statusAsString())
                .add("Endpoint", endpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "VpcEndpointOwner":
            return Optional.ofNullable(clazz.cast(vpcEndpointOwner()));
        case "DomainArn":
            return Optional.ofNullable(clazz.cast(domainArn()));
        case "VpcOptions":
            return Optional.ofNullable(clazz.cast(vpcOptions()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("VpcEndpointOwner", VPC_ENDPOINT_OWNER_FIELD);
        map.put("DomainArn", DOMAIN_ARN_FIELD);
        map.put("VpcOptions", VPC_OPTIONS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Endpoint", ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcEndpoint, T> g) {
        return obj -> g.apply((VpcEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcEndpoint> {
        /**
         * <p>
         * The unique identifier of the endpoint.
         * </p>
         * 
         * @param vpcEndpointId
         *        The unique identifier of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * The creator of the endpoint.
         * </p>
         * 
         * @param vpcEndpointOwner
         *        The creator of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointOwner(String vpcEndpointOwner);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the domain associated with the endpoint.
         * </p>
         * 
         * @param domainArn
         *        The Amazon Resource Name (ARN) of the domain associated with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainArn(String domainArn);

        /**
         * <p>
         * Options to specify the subnets and security groups for an Amazon OpenSearch Service VPC endpoint.
         * </p>
         * 
         * @param vpcOptions
         *        Options to specify the subnets and security groups for an Amazon OpenSearch Service VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOptions(VPCDerivedInfo vpcOptions);

        /**
         * <p>
         * Options to specify the subnets and security groups for an Amazon OpenSearch Service VPC endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link VPCDerivedInfo.Builder} avoiding the need
         * to create one manually via {@link VPCDerivedInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VPCDerivedInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcOptions(VPCDerivedInfo)}.
         * 
         * @param vpcOptions
         *        a consumer that will call methods on {@link VPCDerivedInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcOptions(VPCDerivedInfo)
         */
        default Builder vpcOptions(Consumer<VPCDerivedInfo.Builder> vpcOptions) {
            return vpcOptions(VPCDerivedInfo.builder().applyMutation(vpcOptions).build());
        }

        /**
         * <p>
         * The current status of the endpoint.
         * </p>
         * 
         * @param status
         *        The current status of the endpoint.
         * @see VpcEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcEndpointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the endpoint.
         * </p>
         * 
         * @param status
         *        The current status of the endpoint.
         * @see VpcEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcEndpointStatus
         */
        Builder status(VpcEndpointStatus status);

        /**
         * <p>
         * The connection endpoint ID for connecting to the domain.
         * </p>
         * 
         * @param endpoint
         *        The connection endpoint ID for connecting to the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);
    }

    static final class BuilderImpl implements Builder {
        private String vpcEndpointId;

        private String vpcEndpointOwner;

        private String domainArn;

        private VPCDerivedInfo vpcOptions;

        private String status;

        private String endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEndpoint model) {
            vpcEndpointId(model.vpcEndpointId);
            vpcEndpointOwner(model.vpcEndpointOwner);
            domainArn(model.domainArn);
            vpcOptions(model.vpcOptions);
            status(model.status);
            endpoint(model.endpoint);
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getVpcEndpointOwner() {
            return vpcEndpointOwner;
        }

        public final void setVpcEndpointOwner(String vpcEndpointOwner) {
            this.vpcEndpointOwner = vpcEndpointOwner;
        }

        @Override
        public final Builder vpcEndpointOwner(String vpcEndpointOwner) {
            this.vpcEndpointOwner = vpcEndpointOwner;
            return this;
        }

        public final String getDomainArn() {
            return domainArn;
        }

        public final void setDomainArn(String domainArn) {
            this.domainArn = domainArn;
        }

        @Override
        public final Builder domainArn(String domainArn) {
            this.domainArn = domainArn;
            return this;
        }

        public final VPCDerivedInfo.Builder getVpcOptions() {
            return vpcOptions != null ? vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(VPCDerivedInfo.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(VPCDerivedInfo vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VpcEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public VpcEndpoint build() {
            return new VpcEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
