/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the master playlist.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJobPlaylist implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateJobPlaylist.Builder, CreateJobPlaylist> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateJobPlaylist::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(CreateJobPlaylist::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<List<String>> OUTPUT_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OutputKeys")
            .getter(getter(CreateJobPlaylist::outputKeys))
            .setter(setter(Builder::outputKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<HlsContentProtection> HLS_CONTENT_PROTECTION_FIELD = SdkField
            .<HlsContentProtection> builder(MarshallingType.SDK_POJO).memberName("HlsContentProtection")
            .getter(getter(CreateJobPlaylist::hlsContentProtection)).setter(setter(Builder::hlsContentProtection))
            .constructor(HlsContentProtection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsContentProtection").build())
            .build();

    private static final SdkField<PlayReadyDrm> PLAY_READY_DRM_FIELD = SdkField.<PlayReadyDrm> builder(MarshallingType.SDK_POJO)
            .memberName("PlayReadyDrm").getter(getter(CreateJobPlaylist::playReadyDrm)).setter(setter(Builder::playReadyDrm))
            .constructor(PlayReadyDrm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayReadyDrm").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FORMAT_FIELD,
            OUTPUT_KEYS_FIELD, HLS_CONTENT_PROTECTION_FIELD, PLAY_READY_DRM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String format;

    private final List<String> outputKeys;

    private final HlsContentProtection hlsContentProtection;

    private final PlayReadyDrm playReadyDrm;

    private CreateJobPlaylist(BuilderImpl builder) {
        this.name = builder.name;
        this.format = builder.format;
        this.outputKeys = builder.outputKeys;
        this.hlsContentProtection = builder.hlsContentProtection;
        this.playReadyDrm = builder.playReadyDrm;
    }

    /**
     * <p>
     * The name that you want Elastic Transcoder to assign to the master playlist, for example, nyc-vacation.m3u8. If
     * the name includes a <code>/</code> character, the section of the name before the last <code>/</code> must be
     * identical for all <code>Name</code> objects. If you create more than one master playlist, the values of all
     * <code>Name</code> objects must be unique.
     * </p>
     * <note>
     * <p>
     * Elastic Transcoder automatically appends the relevant file extension to the file name (<code>.m3u8</code> for
     * <code>HLSv3</code> and <code>HLSv4</code> playlists, and <code>.ism</code> and <code>.ismc</code> for
     * <code>Smooth</code> playlists). If you include a file extension in <code>Name</code>, the file name will have two
     * extensions.
     * </p>
     * </note>
     * 
     * @return The name that you want Elastic Transcoder to assign to the master playlist, for example,
     *         nyc-vacation.m3u8. If the name includes a <code>/</code> character, the section of the name before the
     *         last <code>/</code> must be identical for all <code>Name</code> objects. If you create more than one
     *         master playlist, the values of all <code>Name</code> objects must be unique.</p> <note>
     *         <p>
     *         Elastic Transcoder automatically appends the relevant file extension to the file name (<code>.m3u8</code>
     *         for <code>HLSv3</code> and <code>HLSv4</code> playlists, and <code>.ism</code> and <code>.ismc</code> for
     *         <code>Smooth</code> playlists). If you include a file extension in <code>Name</code>, the file name will
     *         have two extensions.
     *         </p>
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The format of the output playlist. Valid formats include <code>HLSv3</code>, <code>HLSv4</code>, and
     * <code>Smooth</code>.
     * </p>
     * 
     * @return The format of the output playlist. Valid formats include <code>HLSv3</code>, <code>HLSv4</code>, and
     *         <code>Smooth</code>.
     */
    public final String format() {
        return format;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputKeys() {
        return outputKeys != null && !(outputKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For each output in this job that you want to include in a master playlist, the value of the
     * <code>Outputs:Key</code> object.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If your output is not <code>HLS</code> or does not have a segment duration set, the name of the output file is a
     * concatenation of <code>OutputKeyPrefix</code> and <code>Outputs:Key</code>:
     * </p>
     * <p>
     * OutputKeyPrefix<code>Outputs:Key</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * If your output is <code>HLSv3</code> and has a segment duration set, or is not included in a playlist, Elastic
     * Transcoder creates an output playlist file with a file extension of <code>.m3u8</code>, and a series of
     * <code>.ts</code> files that include a five-digit sequential counter beginning with 00000:
     * </p>
     * <p>
     * OutputKeyPrefix<code>Outputs:Key</code>.m3u8
     * </p>
     * <p>
     * OutputKeyPrefix<code>Outputs:Key</code>00000.ts
     * </p>
     * </li>
     * <li>
     * <p>
     * If your output is <code>HLSv4</code>, has a segment duration set, and is included in an <code>HLSv4</code>
     * playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>_v4.m3u8</code>. If
     * the output is video, Elastic Transcoder also creates an output file with an extension of
     * <code>_iframe.m3u8</code>:
     * </p>
     * <p>
     * OutputKeyPrefix<code>Outputs:Key</code>_v4.m3u8
     * </p>
     * <p>
     * OutputKeyPrefix<code>Outputs:Key</code>_iframe.m3u8
     * </p>
     * <p>
     * OutputKeyPrefix<code>Outputs:Key</code>.ts
     * </p>
     * </li>
     * </ul>
     * <p>
     * Elastic Transcoder automatically appends the relevant file extension to the file name. If you include a file
     * extension in Output Key, the file name will have two extensions.
     * </p>
     * <p>
     * If you include more than one output in a playlist, any segment duration settings, clip settings, or caption
     * settings must be the same for all outputs in the playlist. For <code>Smooth</code> playlists, the
     * <code>Audio:Profile</code>, <code>Video:Profile</code>, and <code>Video:FrameRate</code> to
     * <code>Video:KeyframesMaxDist</code> ratio must be the same for all outputs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputKeys} method.
     * </p>
     * 
     * @return For each output in this job that you want to include in a master playlist, the value of the
     *         <code>Outputs:Key</code> object. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If your output is not <code>HLS</code> or does not have a segment duration set, the name of the output
     *         file is a concatenation of <code>OutputKeyPrefix</code> and <code>Outputs:Key</code>:
     *         </p>
     *         <p>
     *         OutputKeyPrefix<code>Outputs:Key</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your output is <code>HLSv3</code> and has a segment duration set, or is not included in a playlist,
     *         Elastic Transcoder creates an output playlist file with a file extension of <code>.m3u8</code>, and a
     *         series of <code>.ts</code> files that include a five-digit sequential counter beginning with 00000:
     *         </p>
     *         <p>
     *         OutputKeyPrefix<code>Outputs:Key</code>.m3u8
     *         </p>
     *         <p>
     *         OutputKeyPrefix<code>Outputs:Key</code>00000.ts
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your output is <code>HLSv4</code>, has a segment duration set, and is included in an
     *         <code>HLSv4</code> playlist, Elastic Transcoder creates an output playlist file with a file extension of
     *         <code>_v4.m3u8</code>. If the output is video, Elastic Transcoder also creates an output file with an
     *         extension of <code>_iframe.m3u8</code>:
     *         </p>
     *         <p>
     *         OutputKeyPrefix<code>Outputs:Key</code>_v4.m3u8
     *         </p>
     *         <p>
     *         OutputKeyPrefix<code>Outputs:Key</code>_iframe.m3u8
     *         </p>
     *         <p>
     *         OutputKeyPrefix<code>Outputs:Key</code>.ts
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Elastic Transcoder automatically appends the relevant file extension to the file name. If you include a
     *         file extension in Output Key, the file name will have two extensions.
     *         </p>
     *         <p>
     *         If you include more than one output in a playlist, any segment duration settings, clip settings, or
     *         caption settings must be the same for all outputs in the playlist. For <code>Smooth</code> playlists, the
     *         <code>Audio:Profile</code>, <code>Video:Profile</code>, and <code>Video:FrameRate</code> to
     *         <code>Video:KeyframesMaxDist</code> ratio must be the same for all outputs.
     */
    public final List<String> outputKeys() {
        return outputKeys;
    }

    /**
     * <p>
     * The HLS content protection settings, if any, that you want Elastic Transcoder to apply to the output files
     * associated with this playlist.
     * </p>
     * 
     * @return The HLS content protection settings, if any, that you want Elastic Transcoder to apply to the output
     *         files associated with this playlist.
     */
    public final HlsContentProtection hlsContentProtection() {
        return hlsContentProtection;
    }

    /**
     * <p>
     * The DRM settings, if any, that you want Elastic Transcoder to apply to the output files associated with this
     * playlist.
     * </p>
     * 
     * @return The DRM settings, if any, that you want Elastic Transcoder to apply to the output files associated with
     *         this playlist.
     */
    public final PlayReadyDrm playReadyDrm() {
        return playReadyDrm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputKeys() ? outputKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hlsContentProtection());
        hashCode = 31 * hashCode + Objects.hashCode(playReadyDrm());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobPlaylist)) {
            return false;
        }
        CreateJobPlaylist other = (CreateJobPlaylist) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(format(), other.format())
                && hasOutputKeys() == other.hasOutputKeys() && Objects.equals(outputKeys(), other.outputKeys())
                && Objects.equals(hlsContentProtection(), other.hlsContentProtection())
                && Objects.equals(playReadyDrm(), other.playReadyDrm());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateJobPlaylist").add("Name", name()).add("Format", format())
                .add("OutputKeys", hasOutputKeys() ? outputKeys() : null).add("HlsContentProtection", hlsContentProtection())
                .add("PlayReadyDrm", playReadyDrm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        case "OutputKeys":
            return Optional.ofNullable(clazz.cast(outputKeys()));
        case "HlsContentProtection":
            return Optional.ofNullable(clazz.cast(hlsContentProtection()));
        case "PlayReadyDrm":
            return Optional.ofNullable(clazz.cast(playReadyDrm()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Format", FORMAT_FIELD);
        map.put("OutputKeys", OUTPUT_KEYS_FIELD);
        map.put("HlsContentProtection", HLS_CONTENT_PROTECTION_FIELD);
        map.put("PlayReadyDrm", PLAY_READY_DRM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateJobPlaylist, T> g) {
        return obj -> g.apply((CreateJobPlaylist) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateJobPlaylist> {
        /**
         * <p>
         * The name that you want Elastic Transcoder to assign to the master playlist, for example, nyc-vacation.m3u8.
         * If the name includes a <code>/</code> character, the section of the name before the last <code>/</code> must
         * be identical for all <code>Name</code> objects. If you create more than one master playlist, the values of
         * all <code>Name</code> objects must be unique.
         * </p>
         * <note>
         * <p>
         * Elastic Transcoder automatically appends the relevant file extension to the file name (<code>.m3u8</code> for
         * <code>HLSv3</code> and <code>HLSv4</code> playlists, and <code>.ism</code> and <code>.ismc</code> for
         * <code>Smooth</code> playlists). If you include a file extension in <code>Name</code>, the file name will have
         * two extensions.
         * </p>
         * </note>
         * 
         * @param name
         *        The name that you want Elastic Transcoder to assign to the master playlist, for example,
         *        nyc-vacation.m3u8. If the name includes a <code>/</code> character, the section of the name before the
         *        last <code>/</code> must be identical for all <code>Name</code> objects. If you create more than one
         *        master playlist, the values of all <code>Name</code> objects must be unique.</p> <note>
         *        <p>
         *        Elastic Transcoder automatically appends the relevant file extension to the file name (
         *        <code>.m3u8</code> for <code>HLSv3</code> and <code>HLSv4</code> playlists, and <code>.ism</code> and
         *        <code>.ismc</code> for <code>Smooth</code> playlists). If you include a file extension in
         *        <code>Name</code>, the file name will have two extensions.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The format of the output playlist. Valid formats include <code>HLSv3</code>, <code>HLSv4</code>, and
         * <code>Smooth</code>.
         * </p>
         * 
         * @param format
         *        The format of the output playlist. Valid formats include <code>HLSv3</code>, <code>HLSv4</code>, and
         *        <code>Smooth</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * For each output in this job that you want to include in a master playlist, the value of the
         * <code>Outputs:Key</code> object.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If your output is not <code>HLS</code> or does not have a segment duration set, the name of the output file
         * is a concatenation of <code>OutputKeyPrefix</code> and <code>Outputs:Key</code>:
         * </p>
         * <p>
         * OutputKeyPrefix<code>Outputs:Key</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * If your output is <code>HLSv3</code> and has a segment duration set, or is not included in a playlist,
         * Elastic Transcoder creates an output playlist file with a file extension of <code>.m3u8</code>, and a series
         * of <code>.ts</code> files that include a five-digit sequential counter beginning with 00000:
         * </p>
         * <p>
         * OutputKeyPrefix<code>Outputs:Key</code>.m3u8
         * </p>
         * <p>
         * OutputKeyPrefix<code>Outputs:Key</code>00000.ts
         * </p>
         * </li>
         * <li>
         * <p>
         * If your output is <code>HLSv4</code>, has a segment duration set, and is included in an <code>HLSv4</code>
         * playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>_v4.m3u8</code>.
         * If the output is video, Elastic Transcoder also creates an output file with an extension of
         * <code>_iframe.m3u8</code>:
         * </p>
         * <p>
         * OutputKeyPrefix<code>Outputs:Key</code>_v4.m3u8
         * </p>
         * <p>
         * OutputKeyPrefix<code>Outputs:Key</code>_iframe.m3u8
         * </p>
         * <p>
         * OutputKeyPrefix<code>Outputs:Key</code>.ts
         * </p>
         * </li>
         * </ul>
         * <p>
         * Elastic Transcoder automatically appends the relevant file extension to the file name. If you include a file
         * extension in Output Key, the file name will have two extensions.
         * </p>
         * <p>
         * If you include more than one output in a playlist, any segment duration settings, clip settings, or caption
         * settings must be the same for all outputs in the playlist. For <code>Smooth</code> playlists, the
         * <code>Audio:Profile</code>, <code>Video:Profile</code>, and <code>Video:FrameRate</code> to
         * <code>Video:KeyframesMaxDist</code> ratio must be the same for all outputs.
         * </p>
         * 
         * @param outputKeys
         *        For each output in this job that you want to include in a master playlist, the value of the
         *        <code>Outputs:Key</code> object. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If your output is not <code>HLS</code> or does not have a segment duration set, the name of the output
         *        file is a concatenation of <code>OutputKeyPrefix</code> and <code>Outputs:Key</code>:
         *        </p>
         *        <p>
         *        OutputKeyPrefix<code>Outputs:Key</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your output is <code>HLSv3</code> and has a segment duration set, or is not included in a playlist,
         *        Elastic Transcoder creates an output playlist file with a file extension of <code>.m3u8</code>, and a
         *        series of <code>.ts</code> files that include a five-digit sequential counter beginning with 00000:
         *        </p>
         *        <p>
         *        OutputKeyPrefix<code>Outputs:Key</code>.m3u8
         *        </p>
         *        <p>
         *        OutputKeyPrefix<code>Outputs:Key</code>00000.ts
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your output is <code>HLSv4</code>, has a segment duration set, and is included in an
         *        <code>HLSv4</code> playlist, Elastic Transcoder creates an output playlist file with a file extension
         *        of <code>_v4.m3u8</code>. If the output is video, Elastic Transcoder also creates an output file with
         *        an extension of <code>_iframe.m3u8</code>:
         *        </p>
         *        <p>
         *        OutputKeyPrefix<code>Outputs:Key</code>_v4.m3u8
         *        </p>
         *        <p>
         *        OutputKeyPrefix<code>Outputs:Key</code>_iframe.m3u8
         *        </p>
         *        <p>
         *        OutputKeyPrefix<code>Outputs:Key</code>.ts
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Elastic Transcoder automatically appends the relevant file extension to the file name. If you include
         *        a file extension in Output Key, the file name will have two extensions.
         *        </p>
         *        <p>
         *        If you include more than one output in a playlist, any segment duration settings, clip settings, or
         *        caption settings must be the same for all outputs in the playlist. For <code>Smooth</code> playlists,
         *        the <code>Audio:Profile</code>, <code>Video:Profile</code>, and <code>Video:FrameRate</code> to
         *        <code>Video:KeyframesMaxDist</code> ratio must be the same for all outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputKeys(Collection<String> outputKeys);

        /**
         * <p>
         * For each output in this job that you want to include in a master playlist, the value of the
         * <code>Outputs:Key</code> object.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If your output is not <code>HLS</code> or does not have a segment duration set, the name of the output file
         * is a concatenation of <code>OutputKeyPrefix</code> and <code>Outputs:Key</code>:
         * </p>
         * <p>
         * OutputKeyPrefix<code>Outputs:Key</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * If your output is <code>HLSv3</code> and has a segment duration set, or is not included in a playlist,
         * Elastic Transcoder creates an output playlist file with a file extension of <code>.m3u8</code>, and a series
         * of <code>.ts</code> files that include a five-digit sequential counter beginning with 00000:
         * </p>
         * <p>
         * OutputKeyPrefix<code>Outputs:Key</code>.m3u8
         * </p>
         * <p>
         * OutputKeyPrefix<code>Outputs:Key</code>00000.ts
         * </p>
         * </li>
         * <li>
         * <p>
         * If your output is <code>HLSv4</code>, has a segment duration set, and is included in an <code>HLSv4</code>
         * playlist, Elastic Transcoder creates an output playlist file with a file extension of <code>_v4.m3u8</code>.
         * If the output is video, Elastic Transcoder also creates an output file with an extension of
         * <code>_iframe.m3u8</code>:
         * </p>
         * <p>
         * OutputKeyPrefix<code>Outputs:Key</code>_v4.m3u8
         * </p>
         * <p>
         * OutputKeyPrefix<code>Outputs:Key</code>_iframe.m3u8
         * </p>
         * <p>
         * OutputKeyPrefix<code>Outputs:Key</code>.ts
         * </p>
         * </li>
         * </ul>
         * <p>
         * Elastic Transcoder automatically appends the relevant file extension to the file name. If you include a file
         * extension in Output Key, the file name will have two extensions.
         * </p>
         * <p>
         * If you include more than one output in a playlist, any segment duration settings, clip settings, or caption
         * settings must be the same for all outputs in the playlist. For <code>Smooth</code> playlists, the
         * <code>Audio:Profile</code>, <code>Video:Profile</code>, and <code>Video:FrameRate</code> to
         * <code>Video:KeyframesMaxDist</code> ratio must be the same for all outputs.
         * </p>
         * 
         * @param outputKeys
         *        For each output in this job that you want to include in a master playlist, the value of the
         *        <code>Outputs:Key</code> object. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If your output is not <code>HLS</code> or does not have a segment duration set, the name of the output
         *        file is a concatenation of <code>OutputKeyPrefix</code> and <code>Outputs:Key</code>:
         *        </p>
         *        <p>
         *        OutputKeyPrefix<code>Outputs:Key</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your output is <code>HLSv3</code> and has a segment duration set, or is not included in a playlist,
         *        Elastic Transcoder creates an output playlist file with a file extension of <code>.m3u8</code>, and a
         *        series of <code>.ts</code> files that include a five-digit sequential counter beginning with 00000:
         *        </p>
         *        <p>
         *        OutputKeyPrefix<code>Outputs:Key</code>.m3u8
         *        </p>
         *        <p>
         *        OutputKeyPrefix<code>Outputs:Key</code>00000.ts
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your output is <code>HLSv4</code>, has a segment duration set, and is included in an
         *        <code>HLSv4</code> playlist, Elastic Transcoder creates an output playlist file with a file extension
         *        of <code>_v4.m3u8</code>. If the output is video, Elastic Transcoder also creates an output file with
         *        an extension of <code>_iframe.m3u8</code>:
         *        </p>
         *        <p>
         *        OutputKeyPrefix<code>Outputs:Key</code>_v4.m3u8
         *        </p>
         *        <p>
         *        OutputKeyPrefix<code>Outputs:Key</code>_iframe.m3u8
         *        </p>
         *        <p>
         *        OutputKeyPrefix<code>Outputs:Key</code>.ts
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Elastic Transcoder automatically appends the relevant file extension to the file name. If you include
         *        a file extension in Output Key, the file name will have two extensions.
         *        </p>
         *        <p>
         *        If you include more than one output in a playlist, any segment duration settings, clip settings, or
         *        caption settings must be the same for all outputs in the playlist. For <code>Smooth</code> playlists,
         *        the <code>Audio:Profile</code>, <code>Video:Profile</code>, and <code>Video:FrameRate</code> to
         *        <code>Video:KeyframesMaxDist</code> ratio must be the same for all outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputKeys(String... outputKeys);

        /**
         * <p>
         * The HLS content protection settings, if any, that you want Elastic Transcoder to apply to the output files
         * associated with this playlist.
         * </p>
         * 
         * @param hlsContentProtection
         *        The HLS content protection settings, if any, that you want Elastic Transcoder to apply to the output
         *        files associated with this playlist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsContentProtection(HlsContentProtection hlsContentProtection);

        /**
         * <p>
         * The HLS content protection settings, if any, that you want Elastic Transcoder to apply to the output files
         * associated with this playlist.
         * </p>
         * This is a convenience method that creates an instance of the {@link HlsContentProtection.Builder} avoiding
         * the need to create one manually via {@link HlsContentProtection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HlsContentProtection.Builder#build()} is called immediately and
         * its result is passed to {@link #hlsContentProtection(HlsContentProtection)}.
         * 
         * @param hlsContentProtection
         *        a consumer that will call methods on {@link HlsContentProtection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsContentProtection(HlsContentProtection)
         */
        default Builder hlsContentProtection(Consumer<HlsContentProtection.Builder> hlsContentProtection) {
            return hlsContentProtection(HlsContentProtection.builder().applyMutation(hlsContentProtection).build());
        }

        /**
         * <p>
         * The DRM settings, if any, that you want Elastic Transcoder to apply to the output files associated with this
         * playlist.
         * </p>
         * 
         * @param playReadyDrm
         *        The DRM settings, if any, that you want Elastic Transcoder to apply to the output files associated
         *        with this playlist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playReadyDrm(PlayReadyDrm playReadyDrm);

        /**
         * <p>
         * The DRM settings, if any, that you want Elastic Transcoder to apply to the output files associated with this
         * playlist.
         * </p>
         * This is a convenience method that creates an instance of the {@link PlayReadyDrm.Builder} avoiding the need
         * to create one manually via {@link PlayReadyDrm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PlayReadyDrm.Builder#build()} is called immediately and its
         * result is passed to {@link #playReadyDrm(PlayReadyDrm)}.
         * 
         * @param playReadyDrm
         *        a consumer that will call methods on {@link PlayReadyDrm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #playReadyDrm(PlayReadyDrm)
         */
        default Builder playReadyDrm(Consumer<PlayReadyDrm.Builder> playReadyDrm) {
            return playReadyDrm(PlayReadyDrm.builder().applyMutation(playReadyDrm).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String format;

        private List<String> outputKeys = DefaultSdkAutoConstructList.getInstance();

        private HlsContentProtection hlsContentProtection;

        private PlayReadyDrm playReadyDrm;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobPlaylist model) {
            name(model.name);
            format(model.format);
            outputKeys(model.outputKeys);
            hlsContentProtection(model.hlsContentProtection);
            playReadyDrm(model.playReadyDrm);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final Collection<String> getOutputKeys() {
            if (outputKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return outputKeys;
        }

        public final void setOutputKeys(Collection<String> outputKeys) {
            this.outputKeys = OutputKeysCopier.copy(outputKeys);
        }

        @Override
        public final Builder outputKeys(Collection<String> outputKeys) {
            this.outputKeys = OutputKeysCopier.copy(outputKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputKeys(String... outputKeys) {
            outputKeys(Arrays.asList(outputKeys));
            return this;
        }

        public final HlsContentProtection.Builder getHlsContentProtection() {
            return hlsContentProtection != null ? hlsContentProtection.toBuilder() : null;
        }

        public final void setHlsContentProtection(HlsContentProtection.BuilderImpl hlsContentProtection) {
            this.hlsContentProtection = hlsContentProtection != null ? hlsContentProtection.build() : null;
        }

        @Override
        public final Builder hlsContentProtection(HlsContentProtection hlsContentProtection) {
            this.hlsContentProtection = hlsContentProtection;
            return this;
        }

        public final PlayReadyDrm.Builder getPlayReadyDrm() {
            return playReadyDrm != null ? playReadyDrm.toBuilder() : null;
        }

        public final void setPlayReadyDrm(PlayReadyDrm.BuilderImpl playReadyDrm) {
            this.playReadyDrm = playReadyDrm != null ? playReadyDrm.build() : null;
        }

        @Override
        public final Builder playReadyDrm(PlayReadyDrm playReadyDrm) {
            this.playReadyDrm = playReadyDrm;
            return this;
        }

        @Override
        public CreateJobPlaylist build() {
            return new CreateJobPlaylist(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
