/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Simple Notification Service (Amazon SNS) topic or topics to notify in order to report job status.
 * </p>
 * <important>
 * <p>
 * To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Notifications implements SdkPojo, Serializable, ToCopyableBuilder<Notifications.Builder, Notifications> {
    private static final SdkField<String> PROGRESSING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Progressing").getter(getter(Notifications::progressing)).setter(setter(Builder::progressing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progressing").build()).build();

    private static final SdkField<String> COMPLETED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Completed").getter(getter(Notifications::completed)).setter(setter(Builder::completed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Completed").build()).build();

    private static final SdkField<String> WARNING_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Warning")
            .getter(getter(Notifications::warning)).setter(setter(Builder::warning))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warning").build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Error")
            .getter(getter(Notifications::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESSING_FIELD,
            COMPLETED_FIELD, WARNING_FIELD, ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String progressing;

    private final String completed;

    private final String warning;

    private final String error;

    private Notifications(BuilderImpl builder) {
        this.progressing = builder.progressing;
        this.completed = builder.completed;
        this.warning = builder.warning;
        this.error = builder.error;
    }

    /**
     * <p>
     * The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has
     * started to process the job.
     * </p>
     * 
     * @return The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder
     *         has started to process the job.
     */
    public final String progressing() {
        return progressing;
    }

    /**
     * <p>
     * The Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing the job.
     * </p>
     * 
     * @return The Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing the job.
     */
    public final String completed() {
        return completed;
    }

    /**
     * <p>
     * The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition.
     * </p>
     * 
     * @return The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition.
     */
    public final String warning() {
        return warning;
    }

    /**
     * <p>
     * The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition.
     * </p>
     * 
     * @return The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition.
     */
    public final String error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(progressing());
        hashCode = 31 * hashCode + Objects.hashCode(completed());
        hashCode = 31 * hashCode + Objects.hashCode(warning());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Notifications)) {
            return false;
        }
        Notifications other = (Notifications) obj;
        return Objects.equals(progressing(), other.progressing()) && Objects.equals(completed(), other.completed())
                && Objects.equals(warning(), other.warning()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Notifications").add("Progressing", progressing()).add("Completed", completed())
                .add("Warning", warning()).add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Progressing":
            return Optional.ofNullable(clazz.cast(progressing()));
        case "Completed":
            return Optional.ofNullable(clazz.cast(completed()));
        case "Warning":
            return Optional.ofNullable(clazz.cast(warning()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Progressing", PROGRESSING_FIELD);
        map.put("Completed", COMPLETED_FIELD);
        map.put("Warning", WARNING_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Notifications, T> g) {
        return obj -> g.apply((Notifications) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Notifications> {
        /**
         * <p>
         * The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has
         * started to process the job.
         * </p>
         * 
         * @param progressing
         *        The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic
         *        Transcoder has started to process the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressing(String progressing);

        /**
         * <p>
         * The Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing the job.
         * </p>
         * 
         * @param completed
         *        The Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completed(String completed);

        /**
         * <p>
         * The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition.
         * </p>
         * 
         * @param warning
         *        The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warning(String warning);

        /**
         * <p>
         * The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition.
         * </p>
         * 
         * @param error
         *        The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);
    }

    static final class BuilderImpl implements Builder {
        private String progressing;

        private String completed;

        private String warning;

        private String error;

        private BuilderImpl() {
        }

        private BuilderImpl(Notifications model) {
            progressing(model.progressing);
            completed(model.completed);
            warning(model.warning);
            error(model.error);
        }

        public final String getProgressing() {
            return progressing;
        }

        public final void setProgressing(String progressing) {
            this.progressing = progressing;
        }

        @Override
        public final Builder progressing(String progressing) {
            this.progressing = progressing;
            return this;
        }

        public final String getCompleted() {
            return completed;
        }

        public final void setCompleted(String completed) {
            this.completed = completed;
        }

        @Override
        public final Builder completed(String completed) {
            this.completed = completed;
            return this;
        }

        public final String getWarning() {
            return warning;
        }

        public final void setWarning(String warning) {
            this.warning = warning;
        }

        @Override
        public final Builder warning(String warning) {
            this.warning = warning;
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public Notifications build() {
            return new Notifications(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
