/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.KeyValue;
import software.amazon.awssdk.services.emr.model.KeyValueListCopier;
import software.amazon.awssdk.services.emr.model.XmlStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HadoopJarStepConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HadoopJarStepConfig> {
    private static final SdkField<List<KeyValue>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Properties").getter(HadoopJarStepConfig.getter(HadoopJarStepConfig::properties)).setter(HadoopJarStepConfig.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> JAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Jar").getter(HadoopJarStepConfig.getter(HadoopJarStepConfig::jar)).setter(HadoopJarStepConfig.setter(Builder::jar)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Jar").build()}).build();
    private static final SdkField<String> MAIN_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MainClass").getter(HadoopJarStepConfig.getter(HadoopJarStepConfig::mainClass)).setter(HadoopJarStepConfig.setter(Builder::mainClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MainClass").build()}).build();
    private static final SdkField<List<String>> ARGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Args").getter(HadoopJarStepConfig.getter(HadoopJarStepConfig::args)).setter(HadoopJarStepConfig.setter(Builder::args)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Args").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTIES_FIELD, JAR_FIELD, MAIN_CLASS_FIELD, ARGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<KeyValue> properties;
    private final String jar;
    private final String mainClass;
    private final List<String> args;

    private HadoopJarStepConfig(BuilderImpl builder) {
        this.properties = builder.properties;
        this.jar = builder.jar;
        this.mainClass = builder.mainClass;
        this.args = builder.args;
    }

    public boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructList);
    }

    public List<KeyValue> properties() {
        return this.properties;
    }

    public String jar() {
        return this.jar;
    }

    public String mainClass() {
        return this.mainClass;
    }

    public boolean hasArgs() {
        return this.args != null && !(this.args instanceof SdkAutoConstructList);
    }

    public List<String> args() {
        return this.args;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jar());
        hashCode = 31 * hashCode + Objects.hashCode(this.mainClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArgs() ? this.args() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HadoopJarStepConfig)) {
            return false;
        }
        HadoopJarStepConfig other = (HadoopJarStepConfig)obj;
        return this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties()) && Objects.equals(this.jar(), other.jar()) && Objects.equals(this.mainClass(), other.mainClass()) && this.hasArgs() == other.hasArgs() && Objects.equals(this.args(), other.args());
    }

    public String toString() {
        return ToString.builder((String)"HadoopJarStepConfig").add("Properties", this.hasProperties() ? this.properties() : null).add("Jar", (Object)this.jar()).add("MainClass", (Object)this.mainClass()).add("Args", this.hasArgs() ? this.args() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "Jar": {
                return Optional.ofNullable(clazz.cast(this.jar()));
            }
            case "MainClass": {
                return Optional.ofNullable(clazz.cast(this.mainClass()));
            }
            case "Args": {
                return Optional.ofNullable(clazz.cast(this.args()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HadoopJarStepConfig, T> g) {
        return obj -> g.apply((HadoopJarStepConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<KeyValue> properties = DefaultSdkAutoConstructList.getInstance();
        private String jar;
        private String mainClass;
        private List<String> args = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HadoopJarStepConfig model) {
            this.properties(model.properties);
            this.jar(model.jar);
            this.mainClass(model.mainClass);
            this.args(model.args);
        }

        public final Collection<KeyValue.Builder> getProperties() {
            if (this.properties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.properties != null ? (Collection)this.properties.stream().map(KeyValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder properties(Collection<KeyValue> properties) {
            this.properties = KeyValueListCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(KeyValue ... properties) {
            this.properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(Consumer<KeyValue.Builder> ... properties) {
            this.properties(Stream.of(properties).map(c -> (KeyValue)((KeyValue.Builder)KeyValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProperties(Collection<KeyValue.BuilderImpl> properties) {
            this.properties = KeyValueListCopier.copyFromBuilder(properties);
        }

        public final String getJar() {
            return this.jar;
        }

        @Override
        public final Builder jar(String jar) {
            this.jar = jar;
            return this;
        }

        public final void setJar(String jar) {
            this.jar = jar;
        }

        public final String getMainClass() {
            return this.mainClass;
        }

        @Override
        public final Builder mainClass(String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public final void setMainClass(String mainClass) {
            this.mainClass = mainClass;
        }

        public final Collection<String> getArgs() {
            if (this.args instanceof SdkAutoConstructList) {
                return null;
            }
            return this.args;
        }

        @Override
        public final Builder args(Collection<String> args) {
            this.args = XmlStringListCopier.copy(args);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder args(String ... args) {
            this.args(Arrays.asList(args));
            return this;
        }

        public final void setArgs(Collection<String> args) {
            this.args = XmlStringListCopier.copy(args);
        }

        public HadoopJarStepConfig build() {
            return new HadoopJarStepConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HadoopJarStepConfig> {
        public Builder properties(Collection<KeyValue> var1);

        public Builder properties(KeyValue ... var1);

        public Builder properties(Consumer<KeyValue.Builder> ... var1);

        public Builder jar(String var1);

        public Builder mainClass(String var1);

        public Builder args(Collection<String> var1);

        public Builder args(String ... var1);
    }
}

