/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.services.emr.model.InstanceFleet;
import software.amazon.awssdk.services.emr.model.InstanceFleetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInstanceFleetsResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, ListInstanceFleetsResponse> {
    private static final SdkField<List<InstanceFleet>> INSTANCE_FLEETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceFleets").getter(ListInstanceFleetsResponse.getter(ListInstanceFleetsResponse::instanceFleets)).setter(ListInstanceFleetsResponse.setter(Builder::instanceFleets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFleets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceFleet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListInstanceFleetsResponse.getter(ListInstanceFleetsResponse::marker)).setter(ListInstanceFleetsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FLEETS_FIELD, MARKER_FIELD));
    private final List<InstanceFleet> instanceFleets;
    private final String marker;

    private ListInstanceFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceFleets = builder.instanceFleets;
        this.marker = builder.marker;
    }

    public final boolean hasInstanceFleets() {
        return this.instanceFleets != null && !(this.instanceFleets instanceof SdkAutoConstructList);
    }

    public final List<InstanceFleet> instanceFleets() {
        return this.instanceFleets;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceFleets() ? this.instanceFleets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceFleetsResponse)) {
            return false;
        }
        ListInstanceFleetsResponse other = (ListInstanceFleetsResponse)((Object)obj);
        return this.hasInstanceFleets() == other.hasInstanceFleets() && Objects.equals(this.instanceFleets(), other.instanceFleets()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListInstanceFleetsResponse").add("InstanceFleets", this.hasInstanceFleets() ? this.instanceFleets() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceFleets": {
                return Optional.ofNullable(clazz.cast(this.instanceFleets()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInstanceFleetsResponse, T> g) {
        return obj -> g.apply((ListInstanceFleetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private List<InstanceFleet> instanceFleets = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceFleetsResponse model) {
            super(model);
            this.instanceFleets(model.instanceFleets);
            this.marker(model.marker);
        }

        public final Collection<InstanceFleet.Builder> getInstanceFleets() {
            if (this.instanceFleets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceFleets != null ? (Collection)this.instanceFleets.stream().map(InstanceFleet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceFleets(Collection<InstanceFleet> instanceFleets) {
            this.instanceFleets = InstanceFleetListCopier.copy(instanceFleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceFleets(InstanceFleet ... instanceFleets) {
            this.instanceFleets(Arrays.asList(instanceFleets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceFleets(Consumer<InstanceFleet.Builder> ... instanceFleets) {
            this.instanceFleets(Stream.of(instanceFleets).map(c -> (InstanceFleet)((InstanceFleet.Builder)InstanceFleet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceFleets(Collection<InstanceFleet.BuilderImpl> instanceFleets) {
            this.instanceFleets = InstanceFleetListCopier.copyFromBuilder(instanceFleets);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListInstanceFleetsResponse build() {
            return new ListInstanceFleetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInstanceFleetsResponse> {
        public Builder instanceFleets(Collection<InstanceFleet> var1);

        public Builder instanceFleets(InstanceFleet ... var1);

        public Builder instanceFleets(Consumer<InstanceFleet.Builder> ... var1);

        public Builder marker(String var1);
    }
}

