/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.AuthMode;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.SubnetIdListCopier;
import software.amazon.awssdk.services.emr.model.Tag;
import software.amazon.awssdk.services.emr.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStudioRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, CreateStudioRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateStudioRequest.getter(CreateStudioRequest::name)).setter(CreateStudioRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateStudioRequest.getter(CreateStudioRequest::description)).setter(CreateStudioRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> AUTH_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthMode").getter(CreateStudioRequest.getter(CreateStudioRequest::authModeAsString)).setter(CreateStudioRequest.setter(Builder::authMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthMode").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(CreateStudioRequest.getter(CreateStudioRequest::vpcId)).setter(CreateStudioRequest.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(CreateStudioRequest.getter(CreateStudioRequest::subnetIds)).setter(CreateStudioRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRole").getter(CreateStudioRequest.getter(CreateStudioRequest::serviceRole)).setter(CreateStudioRequest.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()}).build();
    private static final SdkField<String> USER_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserRole").getter(CreateStudioRequest.getter(CreateStudioRequest::userRole)).setter(CreateStudioRequest.setter(Builder::userRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRole").build()}).build();
    private static final SdkField<String> WORKSPACE_SECURITY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkspaceSecurityGroupId").getter(CreateStudioRequest.getter(CreateStudioRequest::workspaceSecurityGroupId)).setter(CreateStudioRequest.setter(Builder::workspaceSecurityGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceSecurityGroupId").build()}).build();
    private static final SdkField<String> ENGINE_SECURITY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineSecurityGroupId").getter(CreateStudioRequest.getter(CreateStudioRequest::engineSecurityGroupId)).setter(CreateStudioRequest.setter(Builder::engineSecurityGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineSecurityGroupId").build()}).build();
    private static final SdkField<String> DEFAULT_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultS3Location").getter(CreateStudioRequest.getter(CreateStudioRequest::defaultS3Location)).setter(CreateStudioRequest.setter(Builder::defaultS3Location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultS3Location").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateStudioRequest.getter(CreateStudioRequest::tags)).setter(CreateStudioRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, AUTH_MODE_FIELD, VPC_ID_FIELD, SUBNET_IDS_FIELD, SERVICE_ROLE_FIELD, USER_ROLE_FIELD, WORKSPACE_SECURITY_GROUP_ID_FIELD, ENGINE_SECURITY_GROUP_ID_FIELD, DEFAULT_S3_LOCATION_FIELD, TAGS_FIELD));
    private final String name;
    private final String description;
    private final String authMode;
    private final String vpcId;
    private final List<String> subnetIds;
    private final String serviceRole;
    private final String userRole;
    private final String workspaceSecurityGroupId;
    private final String engineSecurityGroupId;
    private final String defaultS3Location;
    private final List<Tag> tags;

    private CreateStudioRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.authMode = builder.authMode;
        this.vpcId = builder.vpcId;
        this.subnetIds = builder.subnetIds;
        this.serviceRole = builder.serviceRole;
        this.userRole = builder.userRole;
        this.workspaceSecurityGroupId = builder.workspaceSecurityGroupId;
        this.engineSecurityGroupId = builder.engineSecurityGroupId;
        this.defaultS3Location = builder.defaultS3Location;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final AuthMode authMode() {
        return AuthMode.fromValue(this.authMode);
    }

    public final String authModeAsString() {
        return this.authMode;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final String userRole() {
        return this.userRole;
    }

    public final String workspaceSecurityGroupId() {
        return this.workspaceSecurityGroupId;
    }

    public final String engineSecurityGroupId() {
        return this.engineSecurityGroupId;
    }

    public final String defaultS3Location() {
        return this.defaultS3Location;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.authModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.userRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStudioRequest)) {
            return false;
        }
        CreateStudioRequest other = (CreateStudioRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.authModeAsString(), other.authModeAsString()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.userRole(), other.userRole()) && Objects.equals(this.workspaceSecurityGroupId(), other.workspaceSecurityGroupId()) && Objects.equals(this.engineSecurityGroupId(), other.engineSecurityGroupId()) && Objects.equals(this.defaultS3Location(), other.defaultS3Location()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStudioRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("AuthMode", (Object)this.authModeAsString()).add("VpcId", (Object)this.vpcId()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("ServiceRole", (Object)this.serviceRole()).add("UserRole", (Object)this.userRole()).add("WorkspaceSecurityGroupId", (Object)this.workspaceSecurityGroupId()).add("EngineSecurityGroupId", (Object)this.engineSecurityGroupId()).add("DefaultS3Location", (Object)this.defaultS3Location()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AuthMode": {
                return Optional.ofNullable(clazz.cast(this.authModeAsString()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "ServiceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "UserRole": {
                return Optional.ofNullable(clazz.cast(this.userRole()));
            }
            case "WorkspaceSecurityGroupId": {
                return Optional.ofNullable(clazz.cast(this.workspaceSecurityGroupId()));
            }
            case "EngineSecurityGroupId": {
                return Optional.ofNullable(clazz.cast(this.engineSecurityGroupId()));
            }
            case "DefaultS3Location": {
                return Optional.ofNullable(clazz.cast(this.defaultS3Location()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStudioRequest, T> g) {
        return obj -> g.apply((CreateStudioRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String authMode;
        private String vpcId;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private String serviceRole;
        private String userRole;
        private String workspaceSecurityGroupId;
        private String engineSecurityGroupId;
        private String defaultS3Location;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStudioRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.authMode(model.authMode);
            this.vpcId(model.vpcId);
            this.subnetIds(model.subnetIds);
            this.serviceRole(model.serviceRole);
            this.userRole(model.userRole);
            this.workspaceSecurityGroupId(model.workspaceSecurityGroupId);
            this.engineSecurityGroupId(model.engineSecurityGroupId);
            this.defaultS3Location(model.defaultS3Location);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getAuthMode() {
            return this.authMode;
        }

        @Override
        public final Builder authMode(String authMode) {
            this.authMode = authMode;
            return this;
        }

        @Override
        public final Builder authMode(AuthMode authMode) {
            this.authMode(authMode == null ? null : authMode.toString());
            return this;
        }

        public final void setAuthMode(String authMode) {
            this.authMode = authMode;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final String getUserRole() {
            return this.userRole;
        }

        @Override
        public final Builder userRole(String userRole) {
            this.userRole = userRole;
            return this;
        }

        public final void setUserRole(String userRole) {
            this.userRole = userRole;
        }

        public final String getWorkspaceSecurityGroupId() {
            return this.workspaceSecurityGroupId;
        }

        @Override
        public final Builder workspaceSecurityGroupId(String workspaceSecurityGroupId) {
            this.workspaceSecurityGroupId = workspaceSecurityGroupId;
            return this;
        }

        public final void setWorkspaceSecurityGroupId(String workspaceSecurityGroupId) {
            this.workspaceSecurityGroupId = workspaceSecurityGroupId;
        }

        public final String getEngineSecurityGroupId() {
            return this.engineSecurityGroupId;
        }

        @Override
        public final Builder engineSecurityGroupId(String engineSecurityGroupId) {
            this.engineSecurityGroupId = engineSecurityGroupId;
            return this;
        }

        public final void setEngineSecurityGroupId(String engineSecurityGroupId) {
            this.engineSecurityGroupId = engineSecurityGroupId;
        }

        public final String getDefaultS3Location() {
            return this.defaultS3Location;
        }

        @Override
        public final Builder defaultS3Location(String defaultS3Location) {
            this.defaultS3Location = defaultS3Location;
            return this;
        }

        public final void setDefaultS3Location(String defaultS3Location) {
            this.defaultS3Location = defaultS3Location;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStudioRequest build() {
            return new CreateStudioRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStudioRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder authMode(String var1);

        public Builder authMode(AuthMode var1);

        public Builder vpcId(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder serviceRole(String var1);

        public Builder userRole(String var1);

        public Builder workspaceSecurityGroupId(String var1);

        public Builder engineSecurityGroupId(String var1);

        public Builder defaultS3Location(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

