/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.emr.EmrAsyncClient;
import software.amazon.awssdk.services.emr.model.DescribeClusterRequest;
import software.amazon.awssdk.services.emr.model.DescribeClusterResponse;
import software.amazon.awssdk.services.emr.model.DescribeStepRequest;
import software.amazon.awssdk.services.emr.model.DescribeStepResponse;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.waiters.EmrAsyncWaiter;
import software.amazon.awssdk.services.emr.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultEmrAsyncWaiter
implements EmrAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final EmrAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeClusterResponse> clusterRunningWaiter;
    private final AsyncWaiter<DescribeStepResponse> stepCompleteWaiter;
    private final AsyncWaiter<DescribeClusterResponse> clusterTerminatedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultEmrAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (EmrAsyncClient)EmrAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.clusterRunningWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeClusterResponse.class).acceptors(DefaultEmrAsyncWaiter.clusterRunningWaiterAcceptors())).overrideConfiguration(DefaultEmrAsyncWaiter.clusterRunningWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.stepCompleteWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeStepResponse.class).acceptors(DefaultEmrAsyncWaiter.stepCompleteWaiterAcceptors())).overrideConfiguration(DefaultEmrAsyncWaiter.stepCompleteWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.clusterTerminatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeClusterResponse.class).acceptors(DefaultEmrAsyncWaiter.clusterTerminatedWaiterAcceptors())).overrideConfiguration(DefaultEmrAsyncWaiter.clusterTerminatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterRunning(DescribeClusterRequest describeClusterRequest) {
        return this.clusterRunningWaiter.runAsync(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterRunning(DescribeClusterRequest describeClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterRunningWaiter.runAsync(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)), DefaultEmrAsyncWaiter.clusterRunningWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterTerminated(DescribeClusterRequest describeClusterRequest) {
        return this.clusterTerminatedWaiter.runAsync(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterTerminated(DescribeClusterRequest describeClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterTerminatedWaiter.runAsync(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)), DefaultEmrAsyncWaiter.clusterTerminatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStepResponse>> waitUntilStepComplete(DescribeStepRequest describeStepRequest) {
        return this.stepCompleteWaiter.runAsync(() -> this.client.describeStep(this.applyWaitersUserAgent(describeStepRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStepResponse>> waitUntilStepComplete(DescribeStepRequest describeStepRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.stepCompleteWaiter.runAsync(() -> this.client.describeStep(this.applyWaitersUserAgent(describeStepRequest)), DefaultEmrAsyncWaiter.stepCompleteWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeClusterResponse>> clusterRunningWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClusterResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClusterResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").field("State").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").field("State").value(), "WAITING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").field("State").value(), "TERMINATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").field("State").value(), "TERMINATED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").field("State").value(), "TERMINATED_WITH_ERRORS");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStepResponse>> stepCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStepResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStepResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("Step").field("Status").field("State").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("Step").field("Status").field("State").value(), "FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("Step").field("Status").field("State").value(), "CANCELLED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeClusterResponse>> clusterTerminatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClusterResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClusterResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").field("State").value(), "TERMINATED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").field("State").value(), "TERMINATED_WITH_ERRORS");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration clusterRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration stepCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration clusterTerminatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static EmrAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends EmrRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((EmrRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements EmrAsyncWaiter.Builder {
        private EmrAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public EmrAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public EmrAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public EmrAsyncWaiter.Builder client(EmrAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public EmrAsyncWaiter build() {
            return new DefaultEmrAsyncWaiter(this);
        }
    }
}

