/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input argument to the <a>AddJobFlowSteps</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddJobFlowStepsRequest extends EmrRequest implements
        ToCopyableBuilder<AddJobFlowStepsRequest.Builder, AddJobFlowStepsRequest> {
    private static final SdkField<String> JOB_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobFlowId").getter(getter(AddJobFlowStepsRequest::jobFlowId)).setter(setter(Builder::jobFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFlowId").build()).build();

    private static final SdkField<List<StepConfig>> STEPS_FIELD = SdkField
            .<List<StepConfig>> builder(MarshallingType.LIST)
            .memberName("Steps")
            .getter(getter(AddJobFlowStepsRequest::steps))
            .setter(setter(Builder::steps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Steps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StepConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(StepConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(JOB_FLOW_ID_FIELD, STEPS_FIELD));

    private final String jobFlowId;

    private final List<StepConfig> steps;

    private AddJobFlowStepsRequest(BuilderImpl builder) {
        super(builder);
        this.jobFlowId = builder.jobFlowId;
        this.steps = builder.steps;
    }

    /**
     * <p>
     * A string that uniquely identifies the job flow. This identifier is returned by <a>RunJobFlow</a> and can also be
     * obtained from <a>ListClusters</a>.
     * </p>
     * 
     * @return A string that uniquely identifies the job flow. This identifier is returned by <a>RunJobFlow</a> and can
     *         also be obtained from <a>ListClusters</a>.
     */
    public final String jobFlowId() {
        return jobFlowId;
    }

    /**
     * Returns true if the Steps property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSteps() {
        return steps != null && !(steps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a>StepConfig</a> to be executed by the job flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSteps()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <a>StepConfig</a> to be executed by the job flow.
     */
    public final List<StepConfig> steps() {
        return steps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSteps() ? steps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddJobFlowStepsRequest)) {
            return false;
        }
        AddJobFlowStepsRequest other = (AddJobFlowStepsRequest) obj;
        return Objects.equals(jobFlowId(), other.jobFlowId()) && hasSteps() == other.hasSteps()
                && Objects.equals(steps(), other.steps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddJobFlowStepsRequest").add("JobFlowId", jobFlowId()).add("Steps", hasSteps() ? steps() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobFlowId":
            return Optional.ofNullable(clazz.cast(jobFlowId()));
        case "Steps":
            return Optional.ofNullable(clazz.cast(steps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddJobFlowStepsRequest, T> g) {
        return obj -> g.apply((AddJobFlowStepsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddJobFlowStepsRequest> {
        /**
         * <p>
         * A string that uniquely identifies the job flow. This identifier is returned by <a>RunJobFlow</a> and can also
         * be obtained from <a>ListClusters</a>.
         * </p>
         * 
         * @param jobFlowId
         *        A string that uniquely identifies the job flow. This identifier is returned by <a>RunJobFlow</a> and
         *        can also be obtained from <a>ListClusters</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobFlowId(String jobFlowId);

        /**
         * <p>
         * A list of <a>StepConfig</a> to be executed by the job flow.
         * </p>
         * 
         * @param steps
         *        A list of <a>StepConfig</a> to be executed by the job flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Collection<StepConfig> steps);

        /**
         * <p>
         * A list of <a>StepConfig</a> to be executed by the job flow.
         * </p>
         * 
         * @param steps
         *        A list of <a>StepConfig</a> to be executed by the job flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(StepConfig... steps);

        /**
         * <p>
         * A list of <a>StepConfig</a> to be executed by the job flow.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StepConfig>.Builder} avoiding the need to
         * create one manually via {@link List<StepConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StepConfig>.Builder#build()} is called immediately and its
         * result is passed to {@link #steps(List<StepConfig>)}.
         * 
         * @param steps
         *        a consumer that will call methods on {@link List<StepConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #steps(List<StepConfig>)
         */
        Builder steps(Consumer<StepConfig.Builder>... steps);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String jobFlowId;

        private List<StepConfig> steps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddJobFlowStepsRequest model) {
            super(model);
            jobFlowId(model.jobFlowId);
            steps(model.steps);
        }

        public final String getJobFlowId() {
            return jobFlowId;
        }

        @Override
        public final Builder jobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
            return this;
        }

        public final void setJobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
        }

        public final List<StepConfig.Builder> getSteps() {
            List<StepConfig.Builder> result = StepConfigListCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder steps(Collection<StepConfig> steps) {
            this.steps = StepConfigListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(StepConfig... steps) {
            steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<StepConfig.Builder>... steps) {
            steps(Stream.of(steps).map(c -> StepConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSteps(Collection<StepConfig.BuilderImpl> steps) {
            this.steps = StepConfigListCopier.copyFromBuilder(steps);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddJobFlowStepsRequest build() {
            return new AddJobFlowStepsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
