/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotebookExecutionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<NotebookExecutionSummary.Builder, NotebookExecutionSummary> {
    private static final SdkField<String> NOTEBOOK_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookExecutionId").getter(getter(NotebookExecutionSummary::notebookExecutionId))
            .setter(setter(Builder::notebookExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookExecutionId").build())
            .build();

    private static final SdkField<String> EDITOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EditorId").getter(getter(NotebookExecutionSummary::editorId)).setter(setter(Builder::editorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EditorId").build()).build();

    private static final SdkField<String> NOTEBOOK_EXECUTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookExecutionName").getter(getter(NotebookExecutionSummary::notebookExecutionName))
            .setter(setter(Builder::notebookExecutionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookExecutionName").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(NotebookExecutionSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(NotebookExecutionSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(NotebookExecutionSummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_EXECUTION_ID_FIELD,
            EDITOR_ID_FIELD, NOTEBOOK_EXECUTION_NAME_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String notebookExecutionId;

    private final String editorId;

    private final String notebookExecutionName;

    private final String status;

    private final Instant startTime;

    private final Instant endTime;

    private NotebookExecutionSummary(BuilderImpl builder) {
        this.notebookExecutionId = builder.notebookExecutionId;
        this.editorId = builder.editorId;
        this.notebookExecutionName = builder.notebookExecutionName;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The unique identifier of the notebook execution.
     * </p>
     * 
     * @return The unique identifier of the notebook execution.
     */
    public final String notebookExecutionId() {
        return notebookExecutionId;
    }

    /**
     * <p>
     * The unique identifier of the editor associated with the notebook execution.
     * </p>
     * 
     * @return The unique identifier of the editor associated with the notebook execution.
     */
    public final String editorId() {
        return editorId;
    }

    /**
     * <p>
     * The name of the notebook execution.
     * </p>
     * 
     * @return The name of the notebook execution.
     */
    public final String notebookExecutionName() {
        return notebookExecutionName;
    }

    /**
     * <p>
     * The status of the notebook execution.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>START_PENDING</code> indicates that the cluster has received the execution request but execution has not
     * begun.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STARTING</code> indicates that the execution is starting on the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> indicates that the execution is being processed by the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FINISHING</code> indicates that execution processing is in the final stages.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FINISHED</code> indicates that the execution has completed without error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILING</code> indicates that the execution is failing and will not finish successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> indicates that the execution failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code> request
     * and the stop is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a result of a
     * <code>StopNotebookExecution</code> request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> indicates that the execution stopped because of a <code>StopNotebookExecution</code>
     * request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NotebookExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the notebook execution.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>START_PENDING</code> indicates that the cluster has received the execution request but execution
     *         has not begun.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STARTING</code> indicates that the execution is starting on the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> indicates that the execution is being processed by the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FINISHING</code> indicates that execution processing is in the final stages.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FINISHED</code> indicates that the execution has completed without error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILING</code> indicates that the execution is failing and will not finish successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> indicates that the execution failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code>
     *         request and the stop is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a result
     *         of a <code>StopNotebookExecution</code> request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code> indicates that the execution stopped because of a <code>StopNotebookExecution</code>
     *         request.
     *         </p>
     *         </li>
     * @see NotebookExecutionStatus
     */
    public final NotebookExecutionStatus status() {
        return NotebookExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the notebook execution.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>START_PENDING</code> indicates that the cluster has received the execution request but execution has not
     * begun.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STARTING</code> indicates that the execution is starting on the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> indicates that the execution is being processed by the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FINISHING</code> indicates that execution processing is in the final stages.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FINISHED</code> indicates that the execution has completed without error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILING</code> indicates that the execution is failing and will not finish successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> indicates that the execution failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code> request
     * and the stop is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a result of a
     * <code>StopNotebookExecution</code> request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> indicates that the execution stopped because of a <code>StopNotebookExecution</code>
     * request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NotebookExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the notebook execution.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>START_PENDING</code> indicates that the cluster has received the execution request but execution
     *         has not begun.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STARTING</code> indicates that the execution is starting on the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> indicates that the execution is being processed by the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FINISHING</code> indicates that execution processing is in the final stages.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FINISHED</code> indicates that the execution has completed without error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILING</code> indicates that the execution is failing and will not finish successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> indicates that the execution failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code>
     *         request and the stop is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a result
     *         of a <code>StopNotebookExecution</code> request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code> indicates that the execution stopped because of a <code>StopNotebookExecution</code>
     *         request.
     *         </p>
     *         </li>
     * @see NotebookExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when notebook execution started.
     * </p>
     * 
     * @return The timestamp when notebook execution started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The timestamp when notebook execution started.
     * </p>
     * 
     * @return The timestamp when notebook execution started.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notebookExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(editorId());
        hashCode = 31 * hashCode + Objects.hashCode(notebookExecutionName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotebookExecutionSummary)) {
            return false;
        }
        NotebookExecutionSummary other = (NotebookExecutionSummary) obj;
        return Objects.equals(notebookExecutionId(), other.notebookExecutionId()) && Objects.equals(editorId(), other.editorId())
                && Objects.equals(notebookExecutionName(), other.notebookExecutionName())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotebookExecutionSummary").add("NotebookExecutionId", notebookExecutionId())
                .add("EditorId", editorId()).add("NotebookExecutionName", notebookExecutionName())
                .add("Status", statusAsString()).add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotebookExecutionId":
            return Optional.ofNullable(clazz.cast(notebookExecutionId()));
        case "EditorId":
            return Optional.ofNullable(clazz.cast(editorId()));
        case "NotebookExecutionName":
            return Optional.ofNullable(clazz.cast(notebookExecutionName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotebookExecutionSummary, T> g) {
        return obj -> g.apply((NotebookExecutionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotebookExecutionSummary> {
        /**
         * <p>
         * The unique identifier of the notebook execution.
         * </p>
         * 
         * @param notebookExecutionId
         *        The unique identifier of the notebook execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookExecutionId(String notebookExecutionId);

        /**
         * <p>
         * The unique identifier of the editor associated with the notebook execution.
         * </p>
         * 
         * @param editorId
         *        The unique identifier of the editor associated with the notebook execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder editorId(String editorId);

        /**
         * <p>
         * The name of the notebook execution.
         * </p>
         * 
         * @param notebookExecutionName
         *        The name of the notebook execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookExecutionName(String notebookExecutionName);

        /**
         * <p>
         * The status of the notebook execution.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>START_PENDING</code> indicates that the cluster has received the execution request but execution has
         * not begun.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STARTING</code> indicates that the execution is starting on the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code> indicates that the execution is being processed by the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FINISHING</code> indicates that execution processing is in the final stages.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FINISHED</code> indicates that the execution has completed without error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILING</code> indicates that the execution is failing and will not finish successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> indicates that the execution failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code>
         * request and the stop is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a result of a
         * <code>StopNotebookExecution</code> request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPED</code> indicates that the execution stopped because of a <code>StopNotebookExecution</code>
         * request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the notebook execution.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>START_PENDING</code> indicates that the cluster has received the execution request but execution
         *        has not begun.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STARTING</code> indicates that the execution is starting on the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> indicates that the execution is being processed by the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FINISHING</code> indicates that execution processing is in the final stages.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FINISHED</code> indicates that the execution has completed without error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILING</code> indicates that the execution is failing and will not finish successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> indicates that the execution failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code>
         *        request and the stop is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a
         *        result of a <code>StopNotebookExecution</code> request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPED</code> indicates that the execution stopped because of a
         *        <code>StopNotebookExecution</code> request.
         *        </p>
         *        </li>
         * @see NotebookExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotebookExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the notebook execution.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>START_PENDING</code> indicates that the cluster has received the execution request but execution has
         * not begun.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STARTING</code> indicates that the execution is starting on the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code> indicates that the execution is being processed by the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FINISHING</code> indicates that execution processing is in the final stages.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FINISHED</code> indicates that the execution has completed without error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILING</code> indicates that the execution is failing and will not finish successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> indicates that the execution failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code>
         * request and the stop is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a result of a
         * <code>StopNotebookExecution</code> request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPED</code> indicates that the execution stopped because of a <code>StopNotebookExecution</code>
         * request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the notebook execution.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>START_PENDING</code> indicates that the cluster has received the execution request but execution
         *        has not begun.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STARTING</code> indicates that the execution is starting on the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> indicates that the execution is being processed by the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FINISHING</code> indicates that execution processing is in the final stages.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FINISHED</code> indicates that the execution has completed without error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILING</code> indicates that the execution is failing and will not finish successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> indicates that the execution failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code>
         *        request and the stop is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a
         *        result of a <code>StopNotebookExecution</code> request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPED</code> indicates that the execution stopped because of a
         *        <code>StopNotebookExecution</code> request.
         *        </p>
         *        </li>
         * @see NotebookExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotebookExecutionStatus
         */
        Builder status(NotebookExecutionStatus status);

        /**
         * <p>
         * The timestamp when notebook execution started.
         * </p>
         * 
         * @param startTime
         *        The timestamp when notebook execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The timestamp when notebook execution started.
         * </p>
         * 
         * @param endTime
         *        The timestamp when notebook execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private String notebookExecutionId;

        private String editorId;

        private String notebookExecutionName;

        private String status;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(NotebookExecutionSummary model) {
            notebookExecutionId(model.notebookExecutionId);
            editorId(model.editorId);
            notebookExecutionName(model.notebookExecutionName);
            status(model.status);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getNotebookExecutionId() {
            return notebookExecutionId;
        }

        @Override
        public final Builder notebookExecutionId(String notebookExecutionId) {
            this.notebookExecutionId = notebookExecutionId;
            return this;
        }

        public final void setNotebookExecutionId(String notebookExecutionId) {
            this.notebookExecutionId = notebookExecutionId;
        }

        public final String getEditorId() {
            return editorId;
        }

        @Override
        public final Builder editorId(String editorId) {
            this.editorId = editorId;
            return this;
        }

        public final void setEditorId(String editorId) {
            this.editorId = editorId;
        }

        public final String getNotebookExecutionName() {
            return notebookExecutionName;
        }

        @Override
        public final Builder notebookExecutionName(String notebookExecutionName) {
            this.notebookExecutionName = notebookExecutionName;
            return this;
        }

        public final void setNotebookExecutionName(String notebookExecutionName) {
            this.notebookExecutionName = notebookExecutionName;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NotebookExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public NotebookExecutionSummary build() {
            return new NotebookExecutionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
