/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The launch specification for On-Demand Instances in the instance fleet, which determines the allocation strategy.
 * </p>
 * <note>
 * <p>
 * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
 * On-Demand Instances allocation strategy is available in Amazon EMR version 5.12.1 and later.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OnDemandProvisioningSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<OnDemandProvisioningSpecification.Builder, OnDemandProvisioningSpecification> {
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AllocationStrategy").getter(getter(OnDemandProvisioningSpecification::allocationStrategyAsString))
            .setter(setter(Builder::allocationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationStrategy").build())
            .build();

    private static final SdkField<OnDemandCapacityReservationOptions> CAPACITY_RESERVATION_OPTIONS_FIELD = SdkField
            .<OnDemandCapacityReservationOptions> builder(MarshallingType.SDK_POJO)
            .memberName("CapacityReservationOptions")
            .getter(getter(OnDemandProvisioningSpecification::capacityReservationOptions))
            .setter(setter(Builder::capacityReservationOptions))
            .constructor(OnDemandCapacityReservationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_STRATEGY_FIELD,
            CAPACITY_RESERVATION_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String allocationStrategy;

    private final OnDemandCapacityReservationOptions capacityReservationOptions;

    private OnDemandProvisioningSpecification(BuilderImpl builder) {
        this.allocationStrategy = builder.allocationStrategy;
        this.capacityReservationOptions = builder.capacityReservationOptions;
    }

    /**
     * <p>
     * Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is
     * <code>lowest-price</code> (the default), which launches the lowest price first.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link OnDemandProvisioningAllocationStrategy#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is
     *         <code>lowest-price</code> (the default), which launches the lowest price first.
     * @see OnDemandProvisioningAllocationStrategy
     */
    public final OnDemandProvisioningAllocationStrategy allocationStrategy() {
        return OnDemandProvisioningAllocationStrategy.fromValue(allocationStrategy);
    }

    /**
     * <p>
     * Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is
     * <code>lowest-price</code> (the default), which launches the lowest price first.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link OnDemandProvisioningAllocationStrategy#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is
     *         <code>lowest-price</code> (the default), which launches the lowest price first.
     * @see OnDemandProvisioningAllocationStrategy
     */
    public final String allocationStrategyAsString() {
        return allocationStrategy;
    }

    /**
     * <p>
     * The launch specification for On-Demand instances in the instance fleet, which determines the allocation strategy.
     * </p>
     * 
     * @return The launch specification for On-Demand instances in the instance fleet, which determines the allocation
     *         strategy.
     */
    public final OnDemandCapacityReservationOptions capacityReservationOptions() {
        return capacityReservationOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnDemandProvisioningSpecification)) {
            return false;
        }
        OnDemandProvisioningSpecification other = (OnDemandProvisioningSpecification) obj;
        return Objects.equals(allocationStrategyAsString(), other.allocationStrategyAsString())
                && Objects.equals(capacityReservationOptions(), other.capacityReservationOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OnDemandProvisioningSpecification").add("AllocationStrategy", allocationStrategyAsString())
                .add("CapacityReservationOptions", capacityReservationOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationStrategy":
            return Optional.ofNullable(clazz.cast(allocationStrategyAsString()));
        case "CapacityReservationOptions":
            return Optional.ofNullable(clazz.cast(capacityReservationOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OnDemandProvisioningSpecification, T> g) {
        return obj -> g.apply((OnDemandProvisioningSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OnDemandProvisioningSpecification> {
        /**
         * <p>
         * Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is
         * <code>lowest-price</code> (the default), which launches the lowest price first.
         * </p>
         * 
         * @param allocationStrategy
         *        Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is
         *        <code>lowest-price</code> (the default), which launches the lowest price first.
         * @see OnDemandProvisioningAllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnDemandProvisioningAllocationStrategy
         */
        Builder allocationStrategy(String allocationStrategy);

        /**
         * <p>
         * Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is
         * <code>lowest-price</code> (the default), which launches the lowest price first.
         * </p>
         * 
         * @param allocationStrategy
         *        Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is
         *        <code>lowest-price</code> (the default), which launches the lowest price first.
         * @see OnDemandProvisioningAllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnDemandProvisioningAllocationStrategy
         */
        Builder allocationStrategy(OnDemandProvisioningAllocationStrategy allocationStrategy);

        /**
         * <p>
         * The launch specification for On-Demand instances in the instance fleet, which determines the allocation
         * strategy.
         * </p>
         * 
         * @param capacityReservationOptions
         *        The launch specification for On-Demand instances in the instance fleet, which determines the
         *        allocation strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationOptions(OnDemandCapacityReservationOptions capacityReservationOptions);

        /**
         * <p>
         * The launch specification for On-Demand instances in the instance fleet, which determines the allocation
         * strategy.
         * </p>
         * This is a convenience that creates an instance of the {@link OnDemandCapacityReservationOptions.Builder}
         * avoiding the need to create one manually via {@link OnDemandCapacityReservationOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link OnDemandCapacityReservationOptions.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #capacityReservationOptions(OnDemandCapacityReservationOptions)}.
         * 
         * @param capacityReservationOptions
         *        a consumer that will call methods on {@link OnDemandCapacityReservationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationOptions(OnDemandCapacityReservationOptions)
         */
        default Builder capacityReservationOptions(Consumer<OnDemandCapacityReservationOptions.Builder> capacityReservationOptions) {
            return capacityReservationOptions(OnDemandCapacityReservationOptions.builder()
                    .applyMutation(capacityReservationOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String allocationStrategy;

        private OnDemandCapacityReservationOptions capacityReservationOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(OnDemandProvisioningSpecification model) {
            allocationStrategy(model.allocationStrategy);
            capacityReservationOptions(model.capacityReservationOptions);
        }

        public final String getAllocationStrategy() {
            return allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(OnDemandProvisioningAllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy == null ? null : allocationStrategy.toString());
            return this;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        public final OnDemandCapacityReservationOptions.Builder getCapacityReservationOptions() {
            return capacityReservationOptions != null ? capacityReservationOptions.toBuilder() : null;
        }

        @Override
        public final Builder capacityReservationOptions(OnDemandCapacityReservationOptions capacityReservationOptions) {
            this.capacityReservationOptions = capacityReservationOptions;
            return this;
        }

        public final void setCapacityReservationOptions(OnDemandCapacityReservationOptions.BuilderImpl capacityReservationOptions) {
            this.capacityReservationOptions = capacityReservationOptions != null ? capacityReservationOptions.build() : null;
        }

        @Override
        public OnDemandProvisioningSpecification build() {
            return new OnDemandProvisioningSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
