/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The detailed description of the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Cluster implements SdkPojo, Serializable, ToCopyableBuilder<Cluster.Builder, Cluster> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Cluster::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Cluster::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<ClusterStatus> STATUS_FIELD = SdkField.<ClusterStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status").getter(getter(Cluster::status)).setter(setter(Builder::status))
            .constructor(ClusterStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Ec2InstanceAttributes> EC2_INSTANCE_ATTRIBUTES_FIELD = SdkField
            .<Ec2InstanceAttributes> builder(MarshallingType.SDK_POJO).memberName("Ec2InstanceAttributes")
            .getter(getter(Cluster::ec2InstanceAttributes)).setter(setter(Builder::ec2InstanceAttributes))
            .constructor(Ec2InstanceAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceAttributes").build())
            .build();

    private static final SdkField<String> INSTANCE_COLLECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceCollectionType").getter(getter(Cluster::instanceCollectionTypeAsString))
            .setter(setter(Builder::instanceCollectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCollectionType").build())
            .build();

    private static final SdkField<String> LOG_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("LogUri")
            .getter(getter(Cluster::logUri)).setter(setter(Builder::logUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogUri").build()).build();

    private static final SdkField<String> LOG_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogEncryptionKmsKeyId").getter(getter(Cluster::logEncryptionKmsKeyId))
            .setter(setter(Builder::logEncryptionKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogEncryptionKmsKeyId").build())
            .build();

    private static final SdkField<String> REQUESTED_AMI_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestedAmiVersion").getter(getter(Cluster::requestedAmiVersion))
            .setter(setter(Builder::requestedAmiVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedAmiVersion").build())
            .build();

    private static final SdkField<String> RUNNING_AMI_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RunningAmiVersion").getter(getter(Cluster::runningAmiVersion))
            .setter(setter(Builder::runningAmiVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunningAmiVersion").build()).build();

    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReleaseLabel").getter(getter(Cluster::releaseLabel)).setter(setter(Builder::releaseLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseLabel").build()).build();

    private static final SdkField<Boolean> AUTO_TERMINATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoTerminate").getter(getter(Cluster::autoTerminate)).setter(setter(Builder::autoTerminate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTerminate").build()).build();

    private static final SdkField<Boolean> TERMINATION_PROTECTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TerminationProtected").getter(getter(Cluster::terminationProtected))
            .setter(setter(Builder::terminationProtected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtected").build())
            .build();

    private static final SdkField<Boolean> VISIBLE_TO_ALL_USERS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("VisibleToAllUsers").getter(getter(Cluster::visibleToAllUsers))
            .setter(setter(Builder::visibleToAllUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibleToAllUsers").build()).build();

    private static final SdkField<List<Application>> APPLICATIONS_FIELD = SdkField
            .<List<Application>> builder(MarshallingType.LIST)
            .memberName("Applications")
            .getter(getter(Cluster::applications))
            .setter(setter(Builder::applications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Application> builder(MarshallingType.SDK_POJO)
                                            .constructor(Application::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Cluster::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRole").getter(getter(Cluster::serviceRole)).setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()).build();

    private static final SdkField<Integer> NORMALIZED_INSTANCE_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NormalizedInstanceHours").getter(getter(Cluster::normalizedInstanceHours))
            .setter(setter(Builder::normalizedInstanceHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NormalizedInstanceHours").build())
            .build();

    private static final SdkField<String> MASTER_PUBLIC_DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterPublicDnsName").getter(getter(Cluster::masterPublicDnsName))
            .setter(setter(Builder::masterPublicDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterPublicDnsName").build())
            .build();

    private static final SdkField<List<Configuration>> CONFIGURATIONS_FIELD = SdkField
            .<List<Configuration>> builder(MarshallingType.LIST)
            .memberName("Configurations")
            .getter(getter(Cluster::configurations))
            .setter(setter(Builder::configurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Configuration> builder(MarshallingType.SDK_POJO)
                                            .constructor(Configuration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityConfiguration").getter(getter(Cluster::securityConfiguration))
            .setter(setter(Builder::securityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build())
            .build();

    private static final SdkField<String> AUTO_SCALING_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingRole").getter(getter(Cluster::autoScalingRole)).setter(setter(Builder::autoScalingRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingRole").build()).build();

    private static final SdkField<String> SCALE_DOWN_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScaleDownBehavior").getter(getter(Cluster::scaleDownBehaviorAsString))
            .setter(setter(Builder::scaleDownBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleDownBehavior").build()).build();

    private static final SdkField<String> CUSTOM_AMI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomAmiId").getter(getter(Cluster::customAmiId)).setter(setter(Builder::customAmiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAmiId").build()).build();

    private static final SdkField<Integer> EBS_ROOT_VOLUME_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EbsRootVolumeSize").getter(getter(Cluster::ebsRootVolumeSize))
            .setter(setter(Builder::ebsRootVolumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsRootVolumeSize").build()).build();

    private static final SdkField<String> REPO_UPGRADE_ON_BOOT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepoUpgradeOnBoot").getter(getter(Cluster::repoUpgradeOnBootAsString))
            .setter(setter(Builder::repoUpgradeOnBoot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepoUpgradeOnBoot").build()).build();

    private static final SdkField<KerberosAttributes> KERBEROS_ATTRIBUTES_FIELD = SdkField
            .<KerberosAttributes> builder(MarshallingType.SDK_POJO).memberName("KerberosAttributes")
            .getter(getter(Cluster::kerberosAttributes)).setter(setter(Builder::kerberosAttributes))
            .constructor(KerberosAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KerberosAttributes").build())
            .build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(Cluster::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn").getter(getter(Cluster::outpostArn)).setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").build()).build();

    private static final SdkField<Integer> STEP_CONCURRENCY_LEVEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StepConcurrencyLevel").getter(getter(Cluster::stepConcurrencyLevel))
            .setter(setter(Builder::stepConcurrencyLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepConcurrencyLevel").build())
            .build();

    private static final SdkField<List<PlacementGroupConfig>> PLACEMENT_GROUPS_FIELD = SdkField
            .<List<PlacementGroupConfig>> builder(MarshallingType.LIST)
            .memberName("PlacementGroups")
            .getter(getter(Cluster::placementGroups))
            .setter(setter(Builder::placementGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlacementGroupConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlacementGroupConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            STATUS_FIELD, EC2_INSTANCE_ATTRIBUTES_FIELD, INSTANCE_COLLECTION_TYPE_FIELD, LOG_URI_FIELD,
            LOG_ENCRYPTION_KMS_KEY_ID_FIELD, REQUESTED_AMI_VERSION_FIELD, RUNNING_AMI_VERSION_FIELD, RELEASE_LABEL_FIELD,
            AUTO_TERMINATE_FIELD, TERMINATION_PROTECTED_FIELD, VISIBLE_TO_ALL_USERS_FIELD, APPLICATIONS_FIELD, TAGS_FIELD,
            SERVICE_ROLE_FIELD, NORMALIZED_INSTANCE_HOURS_FIELD, MASTER_PUBLIC_DNS_NAME_FIELD, CONFIGURATIONS_FIELD,
            SECURITY_CONFIGURATION_FIELD, AUTO_SCALING_ROLE_FIELD, SCALE_DOWN_BEHAVIOR_FIELD, CUSTOM_AMI_ID_FIELD,
            EBS_ROOT_VOLUME_SIZE_FIELD, REPO_UPGRADE_ON_BOOT_FIELD, KERBEROS_ATTRIBUTES_FIELD, CLUSTER_ARN_FIELD,
            OUTPOST_ARN_FIELD, STEP_CONCURRENCY_LEVEL_FIELD, PLACEMENT_GROUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final ClusterStatus status;

    private final Ec2InstanceAttributes ec2InstanceAttributes;

    private final String instanceCollectionType;

    private final String logUri;

    private final String logEncryptionKmsKeyId;

    private final String requestedAmiVersion;

    private final String runningAmiVersion;

    private final String releaseLabel;

    private final Boolean autoTerminate;

    private final Boolean terminationProtected;

    private final Boolean visibleToAllUsers;

    private final List<Application> applications;

    private final List<Tag> tags;

    private final String serviceRole;

    private final Integer normalizedInstanceHours;

    private final String masterPublicDnsName;

    private final List<Configuration> configurations;

    private final String securityConfiguration;

    private final String autoScalingRole;

    private final String scaleDownBehavior;

    private final String customAmiId;

    private final Integer ebsRootVolumeSize;

    private final String repoUpgradeOnBoot;

    private final KerberosAttributes kerberosAttributes;

    private final String clusterArn;

    private final String outpostArn;

    private final Integer stepConcurrencyLevel;

    private final List<PlacementGroupConfig> placementGroups;

    private Cluster(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.ec2InstanceAttributes = builder.ec2InstanceAttributes;
        this.instanceCollectionType = builder.instanceCollectionType;
        this.logUri = builder.logUri;
        this.logEncryptionKmsKeyId = builder.logEncryptionKmsKeyId;
        this.requestedAmiVersion = builder.requestedAmiVersion;
        this.runningAmiVersion = builder.runningAmiVersion;
        this.releaseLabel = builder.releaseLabel;
        this.autoTerminate = builder.autoTerminate;
        this.terminationProtected = builder.terminationProtected;
        this.visibleToAllUsers = builder.visibleToAllUsers;
        this.applications = builder.applications;
        this.tags = builder.tags;
        this.serviceRole = builder.serviceRole;
        this.normalizedInstanceHours = builder.normalizedInstanceHours;
        this.masterPublicDnsName = builder.masterPublicDnsName;
        this.configurations = builder.configurations;
        this.securityConfiguration = builder.securityConfiguration;
        this.autoScalingRole = builder.autoScalingRole;
        this.scaleDownBehavior = builder.scaleDownBehavior;
        this.customAmiId = builder.customAmiId;
        this.ebsRootVolumeSize = builder.ebsRootVolumeSize;
        this.repoUpgradeOnBoot = builder.repoUpgradeOnBoot;
        this.kerberosAttributes = builder.kerberosAttributes;
        this.clusterArn = builder.clusterArn;
        this.outpostArn = builder.outpostArn;
        this.stepConcurrencyLevel = builder.stepConcurrencyLevel;
        this.placementGroups = builder.placementGroups;
    }

    /**
     * <p>
     * The unique identifier for the cluster.
     * </p>
     * 
     * @return The unique identifier for the cluster.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the cluster.
     * </p>
     * 
     * @return The name of the cluster.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current status details about the cluster.
     * </p>
     * 
     * @return The current status details about the cluster.
     */
    public final ClusterStatus status() {
        return status;
    }

    /**
     * <p>
     * Provides information about the EC2 instances in a cluster grouped by category. For example, key name, subnet ID,
     * IAM instance profile, and so on.
     * </p>
     * 
     * @return Provides information about the EC2 instances in a cluster grouped by category. For example, key name,
     *         subnet ID, IAM instance profile, and so on.
     */
    public final Ec2InstanceAttributes ec2InstanceAttributes() {
        return ec2InstanceAttributes;
    }

    /**
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions.
     * </p>
     * </note>
     * <p>
     * The instance group configuration of the cluster. A value of <code>INSTANCE_GROUP</code> indicates a uniform
     * instance group configuration. A value of <code>INSTANCE_FLEET</code> indicates an instance fleets configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceCollectionType} will return {@link InstanceCollectionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #instanceCollectionTypeAsString}.
     * </p>
     * 
     * @return <p>
     *         The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding
     *         5.0.x versions.
     *         </p>
     *         </note>
     *         <p>
     *         The instance group configuration of the cluster. A value of <code>INSTANCE_GROUP</code> indicates a
     *         uniform instance group configuration. A value of <code>INSTANCE_FLEET</code> indicates an instance fleets
     *         configuration.
     * @see InstanceCollectionType
     */
    public final InstanceCollectionType instanceCollectionType() {
        return InstanceCollectionType.fromValue(instanceCollectionType);
    }

    /**
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions.
     * </p>
     * </note>
     * <p>
     * The instance group configuration of the cluster. A value of <code>INSTANCE_GROUP</code> indicates a uniform
     * instance group configuration. A value of <code>INSTANCE_FLEET</code> indicates an instance fleets configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceCollectionType} will return {@link InstanceCollectionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #instanceCollectionTypeAsString}.
     * </p>
     * 
     * @return <p>
     *         The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding
     *         5.0.x versions.
     *         </p>
     *         </note>
     *         <p>
     *         The instance group configuration of the cluster. A value of <code>INSTANCE_GROUP</code> indicates a
     *         uniform instance group configuration. A value of <code>INSTANCE_FLEET</code> indicates an instance fleets
     *         configuration.
     * @see InstanceCollectionType
     */
    public final String instanceCollectionTypeAsString() {
        return instanceCollectionType;
    }

    /**
     * <p>
     * The path to the Amazon S3 location where logs for this cluster are stored.
     * </p>
     * 
     * @return The path to the Amazon S3 location where logs for this cluster are stored.
     */
    public final String logUri() {
        return logUri;
    }

    /**
     * <p>
     * The AWS KMS customer master key (CMK) used for encrypting log files. This attribute is only available with EMR
     * version 5.30.0 and later, excluding EMR 6.0.0.
     * </p>
     * 
     * @return The AWS KMS customer master key (CMK) used for encrypting log files. This attribute is only available
     *         with EMR version 5.30.0 and later, excluding EMR 6.0.0.
     */
    public final String logEncryptionKmsKeyId() {
        return logEncryptionKmsKeyId;
    }

    /**
     * <p>
     * The AMI version requested for this cluster.
     * </p>
     * 
     * @return The AMI version requested for this cluster.
     */
    public final String requestedAmiVersion() {
        return requestedAmiVersion;
    }

    /**
     * <p>
     * The AMI version running on this cluster.
     * </p>
     * 
     * @return The AMI version running on this cluster.
     */
    public final String runningAmiVersion() {
        return runningAmiVersion;
    }

    /**
     * <p>
     * The Amazon EMR release label, which determines the version of open-source application packages installed on the
     * cluster. Release labels are in the form <code>emr-x.x.x</code>, where x.x.x is an Amazon EMR release version such
     * as <code>emr-5.14.0</code>. For more information about Amazon EMR release versions and included application
     * versions and features, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://docs.aws.amazon.
     * com/emr/latest/ReleaseGuide/</a>. The release label applies only to Amazon EMR releases version 4.0 and later.
     * Earlier versions use <code>AmiVersion</code>.
     * </p>
     * 
     * @return The Amazon EMR release label, which determines the version of open-source application packages installed
     *         on the cluster. Release labels are in the form <code>emr-x.x.x</code>, where x.x.x is an Amazon EMR
     *         release version such as <code>emr-5.14.0</code>. For more information about Amazon EMR release versions
     *         and included application versions and features, see <a
     *         href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/"
     *         >https://docs.aws.amazon.com/emr/latest/ReleaseGuide/</a>. The release label applies only to Amazon EMR
     *         releases version 4.0 and later. Earlier versions use <code>AmiVersion</code>.
     */
    public final String releaseLabel() {
        return releaseLabel;
    }

    /**
     * <p>
     * Specifies whether the cluster should terminate after completing all steps.
     * </p>
     * 
     * @return Specifies whether the cluster should terminate after completing all steps.
     */
    public final Boolean autoTerminate() {
        return autoTerminate;
    }

    /**
     * <p>
     * Indicates whether Amazon EMR will lock the cluster to prevent the EC2 instances from being terminated by an API
     * call or user intervention, or in the event of a cluster error.
     * </p>
     * 
     * @return Indicates whether Amazon EMR will lock the cluster to prevent the EC2 instances from being terminated by
     *         an API call or user intervention, or in the event of a cluster error.
     */
    public final Boolean terminationProtected() {
        return terminationProtected;
    }

    /**
     * <p>
     * Indicates whether the cluster is visible to all IAM users of the AWS account associated with the cluster. The
     * default value, <code>true</code>, indicates that all IAM users in the AWS account can perform cluster actions if
     * they have the proper IAM policy permissions. If this value is <code>false</code>, only the IAM user that created
     * the cluster can perform actions. This value can be changed on a running cluster by using the
     * <a>SetVisibleToAllUsers</a> action. You can override the default value of <code>true</code> when you create a
     * cluster by using the <code>VisibleToAllUsers</code> parameter of the <code>RunJobFlow</code> action.
     * </p>
     * 
     * @return Indicates whether the cluster is visible to all IAM users of the AWS account associated with the cluster.
     *         The default value, <code>true</code>, indicates that all IAM users in the AWS account can perform cluster
     *         actions if they have the proper IAM policy permissions. If this value is <code>false</code>, only the IAM
     *         user that created the cluster can perform actions. This value can be changed on a running cluster by
     *         using the <a>SetVisibleToAllUsers</a> action. You can override the default value of <code>true</code>
     *         when you create a cluster by using the <code>VisibleToAllUsers</code> parameter of the
     *         <code>RunJobFlow</code> action.
     */
    public final Boolean visibleToAllUsers() {
        return visibleToAllUsers;
    }

    /**
     * Returns true if the Applications property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasApplications() {
        return applications != null && !(applications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The applications installed on this cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasApplications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The applications installed on this cluster.
     */
    public final List<Application> applications() {
        return applications;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags associated with a cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags associated with a cluster.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The IAM role that will be assumed by the Amazon EMR service to access AWS resources on your behalf.
     * </p>
     * 
     * @return The IAM role that will be assumed by the Amazon EMR service to access AWS resources on your behalf.
     */
    public final String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * An approximation of the cost of the cluster, represented in m1.small/hours. This value is incremented one time
     * for every hour an m1.small instance runs. Larger instances are weighted more, so an EC2 instance that is roughly
     * four times more expensive would result in the normalized instance hours being incremented by four. This result is
     * only an approximation and does not reflect the actual billing rate.
     * </p>
     * 
     * @return An approximation of the cost of the cluster, represented in m1.small/hours. This value is incremented one
     *         time for every hour an m1.small instance runs. Larger instances are weighted more, so an EC2 instance
     *         that is roughly four times more expensive would result in the normalized instance hours being incremented
     *         by four. This result is only an approximation and does not reflect the actual billing rate.
     */
    public final Integer normalizedInstanceHours() {
        return normalizedInstanceHours;
    }

    /**
     * <p>
     * The DNS name of the master node. If the cluster is on a private subnet, this is the private DNS name. On a public
     * subnet, this is the public DNS name.
     * </p>
     * 
     * @return The DNS name of the master node. If the cluster is on a private subnet, this is the private DNS name. On
     *         a public subnet, this is the public DNS name.
     */
    public final String masterPublicDnsName() {
        return masterPublicDnsName;
    }

    /**
     * Returns true if the Configurations property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasConfigurations() {
        return configurations != null && !(configurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied to the EMR cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied to the EMR
     *         cluster.
     */
    public final List<Configuration> configurations() {
        return configurations;
    }

    /**
     * <p>
     * The name of the security configuration applied to the cluster.
     * </p>
     * 
     * @return The name of the security configuration applied to the cluster.
     */
    public final String securityConfiguration() {
        return securityConfiguration;
    }

    /**
     * <p>
     * An IAM role for automatic scaling policies. The default role is <code>EMR_AutoScaling_DefaultRole</code>. The IAM
     * role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an
     * instance group.
     * </p>
     * 
     * @return An IAM role for automatic scaling policies. The default role is <code>EMR_AutoScaling_DefaultRole</code>.
     *         The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2
     *         instances in an instance group.
     */
    public final String autoScalingRole() {
        return autoScalingRole;
    }

    /**
     * <p>
     * The way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance
     * group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at the
     * instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option is
     * only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version.
     * <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list and drains tasks
     * from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either
     * behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to
     * HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> is available only in Amazon EMR version 4.1.0 and
     * later, and is the default for versions of Amazon EMR earlier than 5.1.0.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scaleDownBehavior}
     * will return {@link ScaleDownBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scaleDownBehaviorAsString}.
     * </p>
     * 
     * @return The way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an
     *         instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates
     *         nodes at the instance-hour boundary, regardless of when the request to terminate the instance was
     *         submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters
     *         created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds
     *         nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless
     *         of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes first and
     *         blocks instance termination if it could lead to HDFS corruption.
     *         <code>TERMINATE_AT_TASK_COMPLETION</code> is available only in Amazon EMR version 4.1.0 and later, and is
     *         the default for versions of Amazon EMR earlier than 5.1.0.
     * @see ScaleDownBehavior
     */
    public final ScaleDownBehavior scaleDownBehavior() {
        return ScaleDownBehavior.fromValue(scaleDownBehavior);
    }

    /**
     * <p>
     * The way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance
     * group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at the
     * instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option is
     * only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version.
     * <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list and drains tasks
     * from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either
     * behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to
     * HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> is available only in Amazon EMR version 4.1.0 and
     * later, and is the default for versions of Amazon EMR earlier than 5.1.0.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scaleDownBehavior}
     * will return {@link ScaleDownBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scaleDownBehaviorAsString}.
     * </p>
     * 
     * @return The way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an
     *         instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates
     *         nodes at the instance-hour boundary, regardless of when the request to terminate the instance was
     *         submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters
     *         created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds
     *         nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless
     *         of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes first and
     *         blocks instance termination if it could lead to HDFS corruption.
     *         <code>TERMINATE_AT_TASK_COMPLETION</code> is available only in Amazon EMR version 4.1.0 and later, and is
     *         the default for versions of Amazon EMR earlier than 5.1.0.
     * @see ScaleDownBehavior
     */
    public final String scaleDownBehaviorAsString() {
        return scaleDownBehavior;
    }

    /**
     * <p>
     * Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI if the
     * cluster uses a custom AMI.
     * </p>
     * 
     * @return Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI if
     *         the cluster uses a custom AMI.
     */
    public final String customAmiId() {
        return customAmiId;
    }

    /**
     * <p>
     * The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each EC2 instance.
     * Available in Amazon EMR version 4.x and later.
     * </p>
     * 
     * @return The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each EC2
     *         instance. Available in Amazon EMR version 4.x and later.
     */
    public final Integer ebsRootVolumeSize() {
        return ebsRootVolumeSize;
    }

    /**
     * <p>
     * Applies only when <code>CustomAmiID</code> is used. Specifies the type of updates that are applied from the
     * Amazon Linux AMI package repositories when an instance boots using the AMI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #repoUpgradeOnBoot}
     * will return {@link RepoUpgradeOnBoot#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #repoUpgradeOnBootAsString}.
     * </p>
     * 
     * @return Applies only when <code>CustomAmiID</code> is used. Specifies the type of updates that are applied from
     *         the Amazon Linux AMI package repositories when an instance boots using the AMI.
     * @see RepoUpgradeOnBoot
     */
    public final RepoUpgradeOnBoot repoUpgradeOnBoot() {
        return RepoUpgradeOnBoot.fromValue(repoUpgradeOnBoot);
    }

    /**
     * <p>
     * Applies only when <code>CustomAmiID</code> is used. Specifies the type of updates that are applied from the
     * Amazon Linux AMI package repositories when an instance boots using the AMI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #repoUpgradeOnBoot}
     * will return {@link RepoUpgradeOnBoot#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #repoUpgradeOnBootAsString}.
     * </p>
     * 
     * @return Applies only when <code>CustomAmiID</code> is used. Specifies the type of updates that are applied from
     *         the Amazon Linux AMI package repositories when an instance boots using the AMI.
     * @see RepoUpgradeOnBoot
     */
    public final String repoUpgradeOnBootAsString() {
        return repoUpgradeOnBoot;
    }

    /**
     * <p>
     * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration. For
     * more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use
     * Kerberos Authentication</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     * 
     * @return Attributes for Kerberos configuration when Kerberos authentication is enabled using a security
     *         configuration. For more information see <a
     *         href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos
     *         Authentication</a> in the <i>Amazon EMR Management Guide</i>.
     */
    public final KerberosAttributes kerberosAttributes() {
        return kerberosAttributes;
    }

    /**
     * <p>
     * The Amazon Resource Name of the cluster.
     * </p>
     * 
     * @return The Amazon Resource Name of the cluster.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost where the cluster is launched.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Outpost where the cluster is launched.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * Specifies the number of steps that can be executed concurrently.
     * </p>
     * 
     * @return Specifies the number of steps that can be executed concurrently.
     */
    public final Integer stepConcurrencyLevel() {
        return stepConcurrencyLevel;
    }

    /**
     * Returns true if the PlacementGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPlacementGroups() {
        return placementGroups != null && !(placementGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Placement group configured for an Amazon EMR cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPlacementGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Placement group configured for an Amazon EMR cluster.
     */
    public final List<PlacementGroupConfig> placementGroups() {
        return placementGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCollectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logUri());
        hashCode = 31 * hashCode + Objects.hashCode(logEncryptionKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(requestedAmiVersion());
        hashCode = 31 * hashCode + Objects.hashCode(runningAmiVersion());
        hashCode = 31 * hashCode + Objects.hashCode(releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(autoTerminate());
        hashCode = 31 * hashCode + Objects.hashCode(terminationProtected());
        hashCode = 31 * hashCode + Objects.hashCode(visibleToAllUsers());
        hashCode = 31 * hashCode + Objects.hashCode(hasApplications() ? applications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(normalizedInstanceHours());
        hashCode = 31 * hashCode + Objects.hashCode(masterPublicDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurations() ? configurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingRole());
        hashCode = 31 * hashCode + Objects.hashCode(scaleDownBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customAmiId());
        hashCode = 31 * hashCode + Objects.hashCode(ebsRootVolumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(repoUpgradeOnBootAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kerberosAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(stepConcurrencyLevel());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlacementGroups() ? placementGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(status(), other.status())
                && Objects.equals(ec2InstanceAttributes(), other.ec2InstanceAttributes())
                && Objects.equals(instanceCollectionTypeAsString(), other.instanceCollectionTypeAsString())
                && Objects.equals(logUri(), other.logUri())
                && Objects.equals(logEncryptionKmsKeyId(), other.logEncryptionKmsKeyId())
                && Objects.equals(requestedAmiVersion(), other.requestedAmiVersion())
                && Objects.equals(runningAmiVersion(), other.runningAmiVersion())
                && Objects.equals(releaseLabel(), other.releaseLabel()) && Objects.equals(autoTerminate(), other.autoTerminate())
                && Objects.equals(terminationProtected(), other.terminationProtected())
                && Objects.equals(visibleToAllUsers(), other.visibleToAllUsers()) && hasApplications() == other.hasApplications()
                && Objects.equals(applications(), other.applications()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(serviceRole(), other.serviceRole())
                && Objects.equals(normalizedInstanceHours(), other.normalizedInstanceHours())
                && Objects.equals(masterPublicDnsName(), other.masterPublicDnsName())
                && hasConfigurations() == other.hasConfigurations() && Objects.equals(configurations(), other.configurations())
                && Objects.equals(securityConfiguration(), other.securityConfiguration())
                && Objects.equals(autoScalingRole(), other.autoScalingRole())
                && Objects.equals(scaleDownBehaviorAsString(), other.scaleDownBehaviorAsString())
                && Objects.equals(customAmiId(), other.customAmiId())
                && Objects.equals(ebsRootVolumeSize(), other.ebsRootVolumeSize())
                && Objects.equals(repoUpgradeOnBootAsString(), other.repoUpgradeOnBootAsString())
                && Objects.equals(kerberosAttributes(), other.kerberosAttributes())
                && Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(outpostArn(), other.outpostArn())
                && Objects.equals(stepConcurrencyLevel(), other.stepConcurrencyLevel())
                && hasPlacementGroups() == other.hasPlacementGroups()
                && Objects.equals(placementGroups(), other.placementGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Cluster").add("Id", id()).add("Name", name()).add("Status", status())
                .add("Ec2InstanceAttributes", ec2InstanceAttributes())
                .add("InstanceCollectionType", instanceCollectionTypeAsString()).add("LogUri", logUri())
                .add("LogEncryptionKmsKeyId", logEncryptionKmsKeyId()).add("RequestedAmiVersion", requestedAmiVersion())
                .add("RunningAmiVersion", runningAmiVersion()).add("ReleaseLabel", releaseLabel())
                .add("AutoTerminate", autoTerminate()).add("TerminationProtected", terminationProtected())
                .add("VisibleToAllUsers", visibleToAllUsers()).add("Applications", hasApplications() ? applications() : null)
                .add("Tags", hasTags() ? tags() : null).add("ServiceRole", serviceRole())
                .add("NormalizedInstanceHours", normalizedInstanceHours()).add("MasterPublicDnsName", masterPublicDnsName())
                .add("Configurations", hasConfigurations() ? configurations() : null)
                .add("SecurityConfiguration", securityConfiguration()).add("AutoScalingRole", autoScalingRole())
                .add("ScaleDownBehavior", scaleDownBehaviorAsString()).add("CustomAmiId", customAmiId())
                .add("EbsRootVolumeSize", ebsRootVolumeSize()).add("RepoUpgradeOnBoot", repoUpgradeOnBootAsString())
                .add("KerberosAttributes", kerberosAttributes()).add("ClusterArn", clusterArn()).add("OutpostArn", outpostArn())
                .add("StepConcurrencyLevel", stepConcurrencyLevel())
                .add("PlacementGroups", hasPlacementGroups() ? placementGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Ec2InstanceAttributes":
            return Optional.ofNullable(clazz.cast(ec2InstanceAttributes()));
        case "InstanceCollectionType":
            return Optional.ofNullable(clazz.cast(instanceCollectionTypeAsString()));
        case "LogUri":
            return Optional.ofNullable(clazz.cast(logUri()));
        case "LogEncryptionKmsKeyId":
            return Optional.ofNullable(clazz.cast(logEncryptionKmsKeyId()));
        case "RequestedAmiVersion":
            return Optional.ofNullable(clazz.cast(requestedAmiVersion()));
        case "RunningAmiVersion":
            return Optional.ofNullable(clazz.cast(runningAmiVersion()));
        case "ReleaseLabel":
            return Optional.ofNullable(clazz.cast(releaseLabel()));
        case "AutoTerminate":
            return Optional.ofNullable(clazz.cast(autoTerminate()));
        case "TerminationProtected":
            return Optional.ofNullable(clazz.cast(terminationProtected()));
        case "VisibleToAllUsers":
            return Optional.ofNullable(clazz.cast(visibleToAllUsers()));
        case "Applications":
            return Optional.ofNullable(clazz.cast(applications()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ServiceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "NormalizedInstanceHours":
            return Optional.ofNullable(clazz.cast(normalizedInstanceHours()));
        case "MasterPublicDnsName":
            return Optional.ofNullable(clazz.cast(masterPublicDnsName()));
        case "Configurations":
            return Optional.ofNullable(clazz.cast(configurations()));
        case "SecurityConfiguration":
            return Optional.ofNullable(clazz.cast(securityConfiguration()));
        case "AutoScalingRole":
            return Optional.ofNullable(clazz.cast(autoScalingRole()));
        case "ScaleDownBehavior":
            return Optional.ofNullable(clazz.cast(scaleDownBehaviorAsString()));
        case "CustomAmiId":
            return Optional.ofNullable(clazz.cast(customAmiId()));
        case "EbsRootVolumeSize":
            return Optional.ofNullable(clazz.cast(ebsRootVolumeSize()));
        case "RepoUpgradeOnBoot":
            return Optional.ofNullable(clazz.cast(repoUpgradeOnBootAsString()));
        case "KerberosAttributes":
            return Optional.ofNullable(clazz.cast(kerberosAttributes()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "StepConcurrencyLevel":
            return Optional.ofNullable(clazz.cast(stepConcurrencyLevel()));
        case "PlacementGroups":
            return Optional.ofNullable(clazz.cast(placementGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Cluster> {
        /**
         * <p>
         * The unique identifier for the cluster.
         * </p>
         * 
         * @param id
         *        The unique identifier for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the cluster.
         * </p>
         * 
         * @param name
         *        The name of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status details about the cluster.
         * </p>
         * 
         * @param status
         *        The current status details about the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ClusterStatus status);

        /**
         * <p>
         * The current status details about the cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link ClusterStatus.Builder} avoiding the need to
         * create one manually via {@link ClusterStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClusterStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(ClusterStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ClusterStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ClusterStatus)
         */
        default Builder status(Consumer<ClusterStatus.Builder> status) {
            return status(ClusterStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * Provides information about the EC2 instances in a cluster grouped by category. For example, key name, subnet
         * ID, IAM instance profile, and so on.
         * </p>
         * 
         * @param ec2InstanceAttributes
         *        Provides information about the EC2 instances in a cluster grouped by category. For example, key name,
         *        subnet ID, IAM instance profile, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceAttributes(Ec2InstanceAttributes ec2InstanceAttributes);

        /**
         * <p>
         * Provides information about the EC2 instances in a cluster grouped by category. For example, key name, subnet
         * ID, IAM instance profile, and so on.
         * </p>
         * This is a convenience that creates an instance of the {@link Ec2InstanceAttributes.Builder} avoiding the need
         * to create one manually via {@link Ec2InstanceAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link Ec2InstanceAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #ec2InstanceAttributes(Ec2InstanceAttributes)}.
         * 
         * @param ec2InstanceAttributes
         *        a consumer that will call methods on {@link Ec2InstanceAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2InstanceAttributes(Ec2InstanceAttributes)
         */
        default Builder ec2InstanceAttributes(Consumer<Ec2InstanceAttributes.Builder> ec2InstanceAttributes) {
            return ec2InstanceAttributes(Ec2InstanceAttributes.builder().applyMutation(ec2InstanceAttributes).build());
        }

        /**
         * <note>
         * <p>
         * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
         * versions.
         * </p>
         * </note>
         * <p>
         * The instance group configuration of the cluster. A value of <code>INSTANCE_GROUP</code> indicates a uniform
         * instance group configuration. A value of <code>INSTANCE_FLEET</code> indicates an instance fleets
         * configuration.
         * </p>
         * 
         * @param instanceCollectionType
         *        <p>
         *        The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding
         *        5.0.x versions.
         *        </p>
         *        </note>
         *        <p>
         *        The instance group configuration of the cluster. A value of <code>INSTANCE_GROUP</code> indicates a
         *        uniform instance group configuration. A value of <code>INSTANCE_FLEET</code> indicates an instance
         *        fleets configuration.
         * @see InstanceCollectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceCollectionType
         */
        Builder instanceCollectionType(String instanceCollectionType);

        /**
         * <note>
         * <p>
         * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
         * versions.
         * </p>
         * </note>
         * <p>
         * The instance group configuration of the cluster. A value of <code>INSTANCE_GROUP</code> indicates a uniform
         * instance group configuration. A value of <code>INSTANCE_FLEET</code> indicates an instance fleets
         * configuration.
         * </p>
         * 
         * @param instanceCollectionType
         *        <p>
         *        The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding
         *        5.0.x versions.
         *        </p>
         *        </note>
         *        <p>
         *        The instance group configuration of the cluster. A value of <code>INSTANCE_GROUP</code> indicates a
         *        uniform instance group configuration. A value of <code>INSTANCE_FLEET</code> indicates an instance
         *        fleets configuration.
         * @see InstanceCollectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceCollectionType
         */
        Builder instanceCollectionType(InstanceCollectionType instanceCollectionType);

        /**
         * <p>
         * The path to the Amazon S3 location where logs for this cluster are stored.
         * </p>
         * 
         * @param logUri
         *        The path to the Amazon S3 location where logs for this cluster are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logUri(String logUri);

        /**
         * <p>
         * The AWS KMS customer master key (CMK) used for encrypting log files. This attribute is only available with
         * EMR version 5.30.0 and later, excluding EMR 6.0.0.
         * </p>
         * 
         * @param logEncryptionKmsKeyId
         *        The AWS KMS customer master key (CMK) used for encrypting log files. This attribute is only available
         *        with EMR version 5.30.0 and later, excluding EMR 6.0.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logEncryptionKmsKeyId(String logEncryptionKmsKeyId);

        /**
         * <p>
         * The AMI version requested for this cluster.
         * </p>
         * 
         * @param requestedAmiVersion
         *        The AMI version requested for this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedAmiVersion(String requestedAmiVersion);

        /**
         * <p>
         * The AMI version running on this cluster.
         * </p>
         * 
         * @param runningAmiVersion
         *        The AMI version running on this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runningAmiVersion(String runningAmiVersion);

        /**
         * <p>
         * The Amazon EMR release label, which determines the version of open-source application packages installed on
         * the cluster. Release labels are in the form <code>emr-x.x.x</code>, where x.x.x is an Amazon EMR release
         * version such as <code>emr-5.14.0</code>. For more information about Amazon EMR release versions and included
         * application versions and features, see <a
         * href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://
         * docs.aws.amazon.com/emr/latest/ReleaseGuide/</a>. The release label applies only to Amazon EMR releases
         * version 4.0 and later. Earlier versions use <code>AmiVersion</code>.
         * </p>
         * 
         * @param releaseLabel
         *        The Amazon EMR release label, which determines the version of open-source application packages
         *        installed on the cluster. Release labels are in the form <code>emr-x.x.x</code>, where x.x.x is an
         *        Amazon EMR release version such as <code>emr-5.14.0</code>. For more information about Amazon EMR
         *        release versions and included application versions and features, see <a
         *        href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/"
         *        >https://docs.aws.amazon.com/emr/latest/ReleaseGuide/</a>. The release label applies only to Amazon
         *        EMR releases version 4.0 and later. Earlier versions use <code>AmiVersion</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseLabel(String releaseLabel);

        /**
         * <p>
         * Specifies whether the cluster should terminate after completing all steps.
         * </p>
         * 
         * @param autoTerminate
         *        Specifies whether the cluster should terminate after completing all steps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoTerminate(Boolean autoTerminate);

        /**
         * <p>
         * Indicates whether Amazon EMR will lock the cluster to prevent the EC2 instances from being terminated by an
         * API call or user intervention, or in the event of a cluster error.
         * </p>
         * 
         * @param terminationProtected
         *        Indicates whether Amazon EMR will lock the cluster to prevent the EC2 instances from being terminated
         *        by an API call or user intervention, or in the event of a cluster error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationProtected(Boolean terminationProtected);

        /**
         * <p>
         * Indicates whether the cluster is visible to all IAM users of the AWS account associated with the cluster. The
         * default value, <code>true</code>, indicates that all IAM users in the AWS account can perform cluster actions
         * if they have the proper IAM policy permissions. If this value is <code>false</code>, only the IAM user that
         * created the cluster can perform actions. This value can be changed on a running cluster by using the
         * <a>SetVisibleToAllUsers</a> action. You can override the default value of <code>true</code> when you create a
         * cluster by using the <code>VisibleToAllUsers</code> parameter of the <code>RunJobFlow</code> action.
         * </p>
         * 
         * @param visibleToAllUsers
         *        Indicates whether the cluster is visible to all IAM users of the AWS account associated with the
         *        cluster. The default value, <code>true</code>, indicates that all IAM users in the AWS account can
         *        perform cluster actions if they have the proper IAM policy permissions. If this value is
         *        <code>false</code>, only the IAM user that created the cluster can perform actions. This value can be
         *        changed on a running cluster by using the <a>SetVisibleToAllUsers</a> action. You can override the
         *        default value of <code>true</code> when you create a cluster by using the
         *        <code>VisibleToAllUsers</code> parameter of the <code>RunJobFlow</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibleToAllUsers(Boolean visibleToAllUsers);

        /**
         * <p>
         * The applications installed on this cluster.
         * </p>
         * 
         * @param applications
         *        The applications installed on this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Collection<Application> applications);

        /**
         * <p>
         * The applications installed on this cluster.
         * </p>
         * 
         * @param applications
         *        The applications installed on this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Application... applications);

        /**
         * <p>
         * The applications installed on this cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Application>.Builder} avoiding the need to
         * create one manually via {@link List<Application>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Application>.Builder#build()} is called immediately and its
         * result is passed to {@link #applications(List<Application>)}.
         * 
         * @param applications
         *        a consumer that will call methods on {@link List<Application>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applications(List<Application>)
         */
        Builder applications(Consumer<Application.Builder>... applications);

        /**
         * <p>
         * A list of tags associated with a cluster.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with a cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags associated with a cluster.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with a cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags associated with a cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The IAM role that will be assumed by the Amazon EMR service to access AWS resources on your behalf.
         * </p>
         * 
         * @param serviceRole
         *        The IAM role that will be assumed by the Amazon EMR service to access AWS resources on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * An approximation of the cost of the cluster, represented in m1.small/hours. This value is incremented one
         * time for every hour an m1.small instance runs. Larger instances are weighted more, so an EC2 instance that is
         * roughly four times more expensive would result in the normalized instance hours being incremented by four.
         * This result is only an approximation and does not reflect the actual billing rate.
         * </p>
         * 
         * @param normalizedInstanceHours
         *        An approximation of the cost of the cluster, represented in m1.small/hours. This value is incremented
         *        one time for every hour an m1.small instance runs. Larger instances are weighted more, so an EC2
         *        instance that is roughly four times more expensive would result in the normalized instance hours being
         *        incremented by four. This result is only an approximation and does not reflect the actual billing
         *        rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder normalizedInstanceHours(Integer normalizedInstanceHours);

        /**
         * <p>
         * The DNS name of the master node. If the cluster is on a private subnet, this is the private DNS name. On a
         * public subnet, this is the public DNS name.
         * </p>
         * 
         * @param masterPublicDnsName
         *        The DNS name of the master node. If the cluster is on a private subnet, this is the private DNS name.
         *        On a public subnet, this is the public DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterPublicDnsName(String masterPublicDnsName);

        /**
         * <p>
         * Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied to the EMR cluster.
         * </p>
         * 
         * @param configurations
         *        Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied to the EMR
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Collection<Configuration> configurations);

        /**
         * <p>
         * Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied to the EMR cluster.
         * </p>
         * 
         * @param configurations
         *        Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied to the EMR
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Configuration... configurations);

        /**
         * <p>
         * Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied to the EMR cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Configuration>.Builder} avoiding the need
         * to create one manually via {@link List<Configuration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Configuration>.Builder#build()} is called immediately and
         * its result is passed to {@link #configurations(List<Configuration>)}.
         * 
         * @param configurations
         *        a consumer that will call methods on {@link List<Configuration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurations(List<Configuration>)
         */
        Builder configurations(Consumer<Configuration.Builder>... configurations);

        /**
         * <p>
         * The name of the security configuration applied to the cluster.
         * </p>
         * 
         * @param securityConfiguration
         *        The name of the security configuration applied to the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfiguration(String securityConfiguration);

        /**
         * <p>
         * An IAM role for automatic scaling policies. The default role is <code>EMR_AutoScaling_DefaultRole</code>. The
         * IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2
         * instances in an instance group.
         * </p>
         * 
         * @param autoScalingRole
         *        An IAM role for automatic scaling policies. The default role is
         *        <code>EMR_AutoScaling_DefaultRole</code>. The IAM role provides permissions that the automatic scaling
         *        feature requires to launch and terminate EC2 instances in an instance group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingRole(String autoScalingRole);

        /**
         * <p>
         * The way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an
         * instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes
         * at the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This
         * option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that
         * version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list and
         * drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour
         * boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance
         * termination if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> is available only
         * in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR earlier than 5.1.0.
         * </p>
         * 
         * @param scaleDownBehavior
         *        The way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or
         *        an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR
         *        terminates nodes at the instance-hour boundary, regardless of when the request to terminate the
         *        instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the
         *        default for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates
         *        that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon
         *        EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the
         *        least active nodes first and blocks instance termination if it could lead to HDFS corruption.
         *        <code>TERMINATE_AT_TASK_COMPLETION</code> is available only in Amazon EMR version 4.1.0 and later, and
         *        is the default for versions of Amazon EMR earlier than 5.1.0.
         * @see ScaleDownBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScaleDownBehavior
         */
        Builder scaleDownBehavior(String scaleDownBehavior);

        /**
         * <p>
         * The way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an
         * instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes
         * at the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This
         * option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that
         * version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list and
         * drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour
         * boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance
         * termination if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> is available only
         * in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR earlier than 5.1.0.
         * </p>
         * 
         * @param scaleDownBehavior
         *        The way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or
         *        an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR
         *        terminates nodes at the instance-hour boundary, regardless of when the request to terminate the
         *        instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the
         *        default for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates
         *        that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon
         *        EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the
         *        least active nodes first and blocks instance termination if it could lead to HDFS corruption.
         *        <code>TERMINATE_AT_TASK_COMPLETION</code> is available only in Amazon EMR version 4.1.0 and later, and
         *        is the default for versions of Amazon EMR earlier than 5.1.0.
         * @see ScaleDownBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScaleDownBehavior
         */
        Builder scaleDownBehavior(ScaleDownBehavior scaleDownBehavior);

        /**
         * <p>
         * Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI if the
         * cluster uses a custom AMI.
         * </p>
         * 
         * @param customAmiId
         *        Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI
         *        if the cluster uses a custom AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAmiId(String customAmiId);

        /**
         * <p>
         * The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each EC2 instance.
         * Available in Amazon EMR version 4.x and later.
         * </p>
         * 
         * @param ebsRootVolumeSize
         *        The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each EC2
         *        instance. Available in Amazon EMR version 4.x and later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsRootVolumeSize(Integer ebsRootVolumeSize);

        /**
         * <p>
         * Applies only when <code>CustomAmiID</code> is used. Specifies the type of updates that are applied from the
         * Amazon Linux AMI package repositories when an instance boots using the AMI.
         * </p>
         * 
         * @param repoUpgradeOnBoot
         *        Applies only when <code>CustomAmiID</code> is used. Specifies the type of updates that are applied
         *        from the Amazon Linux AMI package repositories when an instance boots using the AMI.
         * @see RepoUpgradeOnBoot
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepoUpgradeOnBoot
         */
        Builder repoUpgradeOnBoot(String repoUpgradeOnBoot);

        /**
         * <p>
         * Applies only when <code>CustomAmiID</code> is used. Specifies the type of updates that are applied from the
         * Amazon Linux AMI package repositories when an instance boots using the AMI.
         * </p>
         * 
         * @param repoUpgradeOnBoot
         *        Applies only when <code>CustomAmiID</code> is used. Specifies the type of updates that are applied
         *        from the Amazon Linux AMI package repositories when an instance boots using the AMI.
         * @see RepoUpgradeOnBoot
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepoUpgradeOnBoot
         */
        Builder repoUpgradeOnBoot(RepoUpgradeOnBoot repoUpgradeOnBoot);

        /**
         * <p>
         * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
         * For more information see <a
         * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos
         * Authentication</a> in the <i>Amazon EMR Management Guide</i>.
         * </p>
         * 
         * @param kerberosAttributes
         *        Attributes for Kerberos configuration when Kerberos authentication is enabled using a security
         *        configuration. For more information see <a
         *        href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos
         *        Authentication</a> in the <i>Amazon EMR Management Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kerberosAttributes(KerberosAttributes kerberosAttributes);

        /**
         * <p>
         * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
         * For more information see <a
         * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos
         * Authentication</a> in the <i>Amazon EMR Management Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link KerberosAttributes.Builder} avoiding the need to
         * create one manually via {@link KerberosAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link KerberosAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #kerberosAttributes(KerberosAttributes)}.
         * 
         * @param kerberosAttributes
         *        a consumer that will call methods on {@link KerberosAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kerberosAttributes(KerberosAttributes)
         */
        default Builder kerberosAttributes(Consumer<KerberosAttributes.Builder> kerberosAttributes) {
            return kerberosAttributes(KerberosAttributes.builder().applyMutation(kerberosAttributes).build());
        }

        /**
         * <p>
         * The Amazon Resource Name of the cluster.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Outpost where the cluster is launched.
         * </p>
         * 
         * @param outpostArn
         *        The Amazon Resource Name (ARN) of the Outpost where the cluster is launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * Specifies the number of steps that can be executed concurrently.
         * </p>
         * 
         * @param stepConcurrencyLevel
         *        Specifies the number of steps that can be executed concurrently.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepConcurrencyLevel(Integer stepConcurrencyLevel);

        /**
         * <p>
         * Placement group configured for an Amazon EMR cluster.
         * </p>
         * 
         * @param placementGroups
         *        Placement group configured for an Amazon EMR cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroups(Collection<PlacementGroupConfig> placementGroups);

        /**
         * <p>
         * Placement group configured for an Amazon EMR cluster.
         * </p>
         * 
         * @param placementGroups
         *        Placement group configured for an Amazon EMR cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroups(PlacementGroupConfig... placementGroups);

        /**
         * <p>
         * Placement group configured for an Amazon EMR cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PlacementGroupConfig>.Builder} avoiding the
         * need to create one manually via {@link List<PlacementGroupConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PlacementGroupConfig>.Builder#build()} is called immediately
         * and its result is passed to {@link #placementGroups(List<PlacementGroupConfig>)}.
         * 
         * @param placementGroups
         *        a consumer that will call methods on {@link List<PlacementGroupConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementGroups(List<PlacementGroupConfig>)
         */
        Builder placementGroups(Consumer<PlacementGroupConfig.Builder>... placementGroups);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private ClusterStatus status;

        private Ec2InstanceAttributes ec2InstanceAttributes;

        private String instanceCollectionType;

        private String logUri;

        private String logEncryptionKmsKeyId;

        private String requestedAmiVersion;

        private String runningAmiVersion;

        private String releaseLabel;

        private Boolean autoTerminate;

        private Boolean terminationProtected;

        private Boolean visibleToAllUsers;

        private List<Application> applications = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String serviceRole;

        private Integer normalizedInstanceHours;

        private String masterPublicDnsName;

        private List<Configuration> configurations = DefaultSdkAutoConstructList.getInstance();

        private String securityConfiguration;

        private String autoScalingRole;

        private String scaleDownBehavior;

        private String customAmiId;

        private Integer ebsRootVolumeSize;

        private String repoUpgradeOnBoot;

        private KerberosAttributes kerberosAttributes;

        private String clusterArn;

        private String outpostArn;

        private Integer stepConcurrencyLevel;

        private List<PlacementGroupConfig> placementGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            id(model.id);
            name(model.name);
            status(model.status);
            ec2InstanceAttributes(model.ec2InstanceAttributes);
            instanceCollectionType(model.instanceCollectionType);
            logUri(model.logUri);
            logEncryptionKmsKeyId(model.logEncryptionKmsKeyId);
            requestedAmiVersion(model.requestedAmiVersion);
            runningAmiVersion(model.runningAmiVersion);
            releaseLabel(model.releaseLabel);
            autoTerminate(model.autoTerminate);
            terminationProtected(model.terminationProtected);
            visibleToAllUsers(model.visibleToAllUsers);
            applications(model.applications);
            tags(model.tags);
            serviceRole(model.serviceRole);
            normalizedInstanceHours(model.normalizedInstanceHours);
            masterPublicDnsName(model.masterPublicDnsName);
            configurations(model.configurations);
            securityConfiguration(model.securityConfiguration);
            autoScalingRole(model.autoScalingRole);
            scaleDownBehavior(model.scaleDownBehavior);
            customAmiId(model.customAmiId);
            ebsRootVolumeSize(model.ebsRootVolumeSize);
            repoUpgradeOnBoot(model.repoUpgradeOnBoot);
            kerberosAttributes(model.kerberosAttributes);
            clusterArn(model.clusterArn);
            outpostArn(model.outpostArn);
            stepConcurrencyLevel(model.stepConcurrencyLevel);
            placementGroups(model.placementGroups);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ClusterStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(ClusterStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ClusterStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final Ec2InstanceAttributes.Builder getEc2InstanceAttributes() {
            return ec2InstanceAttributes != null ? ec2InstanceAttributes.toBuilder() : null;
        }

        @Override
        public final Builder ec2InstanceAttributes(Ec2InstanceAttributes ec2InstanceAttributes) {
            this.ec2InstanceAttributes = ec2InstanceAttributes;
            return this;
        }

        public final void setEc2InstanceAttributes(Ec2InstanceAttributes.BuilderImpl ec2InstanceAttributes) {
            this.ec2InstanceAttributes = ec2InstanceAttributes != null ? ec2InstanceAttributes.build() : null;
        }

        public final String getInstanceCollectionType() {
            return instanceCollectionType;
        }

        @Override
        public final Builder instanceCollectionType(String instanceCollectionType) {
            this.instanceCollectionType = instanceCollectionType;
            return this;
        }

        @Override
        public final Builder instanceCollectionType(InstanceCollectionType instanceCollectionType) {
            this.instanceCollectionType(instanceCollectionType == null ? null : instanceCollectionType.toString());
            return this;
        }

        public final void setInstanceCollectionType(String instanceCollectionType) {
            this.instanceCollectionType = instanceCollectionType;
        }

        public final String getLogUri() {
            return logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        public final String getLogEncryptionKmsKeyId() {
            return logEncryptionKmsKeyId;
        }

        @Override
        public final Builder logEncryptionKmsKeyId(String logEncryptionKmsKeyId) {
            this.logEncryptionKmsKeyId = logEncryptionKmsKeyId;
            return this;
        }

        public final void setLogEncryptionKmsKeyId(String logEncryptionKmsKeyId) {
            this.logEncryptionKmsKeyId = logEncryptionKmsKeyId;
        }

        public final String getRequestedAmiVersion() {
            return requestedAmiVersion;
        }

        @Override
        public final Builder requestedAmiVersion(String requestedAmiVersion) {
            this.requestedAmiVersion = requestedAmiVersion;
            return this;
        }

        public final void setRequestedAmiVersion(String requestedAmiVersion) {
            this.requestedAmiVersion = requestedAmiVersion;
        }

        public final String getRunningAmiVersion() {
            return runningAmiVersion;
        }

        @Override
        public final Builder runningAmiVersion(String runningAmiVersion) {
            this.runningAmiVersion = runningAmiVersion;
            return this;
        }

        public final void setRunningAmiVersion(String runningAmiVersion) {
            this.runningAmiVersion = runningAmiVersion;
        }

        public final String getReleaseLabel() {
            return releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        public final Boolean getAutoTerminate() {
            return autoTerminate;
        }

        @Override
        public final Builder autoTerminate(Boolean autoTerminate) {
            this.autoTerminate = autoTerminate;
            return this;
        }

        public final void setAutoTerminate(Boolean autoTerminate) {
            this.autoTerminate = autoTerminate;
        }

        public final Boolean getTerminationProtected() {
            return terminationProtected;
        }

        @Override
        public final Builder terminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
            return this;
        }

        public final void setTerminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
        }

        public final Boolean getVisibleToAllUsers() {
            return visibleToAllUsers;
        }

        @Override
        public final Builder visibleToAllUsers(Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
            return this;
        }

        public final void setVisibleToAllUsers(Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
        }

        public final List<Application.Builder> getApplications() {
            List<Application.Builder> result = ApplicationListCopier.copyToBuilder(this.applications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder applications(Collection<Application> applications) {
            this.applications = ApplicationListCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Application... applications) {
            applications(Arrays.asList(applications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Consumer<Application.Builder>... applications) {
            applications(Stream.of(applications).map(c -> Application.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setApplications(Collection<Application.BuilderImpl> applications) {
            this.applications = ApplicationListCopier.copyFromBuilder(applications);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final Integer getNormalizedInstanceHours() {
            return normalizedInstanceHours;
        }

        @Override
        public final Builder normalizedInstanceHours(Integer normalizedInstanceHours) {
            this.normalizedInstanceHours = normalizedInstanceHours;
            return this;
        }

        public final void setNormalizedInstanceHours(Integer normalizedInstanceHours) {
            this.normalizedInstanceHours = normalizedInstanceHours;
        }

        public final String getMasterPublicDnsName() {
            return masterPublicDnsName;
        }

        @Override
        public final Builder masterPublicDnsName(String masterPublicDnsName) {
            this.masterPublicDnsName = masterPublicDnsName;
            return this;
        }

        public final void setMasterPublicDnsName(String masterPublicDnsName) {
            this.masterPublicDnsName = masterPublicDnsName;
        }

        public final List<Configuration.Builder> getConfigurations() {
            List<Configuration.Builder> result = ConfigurationListCopier.copyToBuilder(this.configurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration... configurations) {
            configurations(Arrays.asList(configurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Consumer<Configuration.Builder>... configurations) {
            configurations(Stream.of(configurations).map(c -> Configuration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurations(Collection<Configuration.BuilderImpl> configurations) {
            this.configurations = ConfigurationListCopier.copyFromBuilder(configurations);
        }

        public final String getSecurityConfiguration() {
            return securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        public final String getAutoScalingRole() {
            return autoScalingRole;
        }

        @Override
        public final Builder autoScalingRole(String autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
            return this;
        }

        public final void setAutoScalingRole(String autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
        }

        public final String getScaleDownBehavior() {
            return scaleDownBehavior;
        }

        @Override
        public final Builder scaleDownBehavior(String scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
            return this;
        }

        @Override
        public final Builder scaleDownBehavior(ScaleDownBehavior scaleDownBehavior) {
            this.scaleDownBehavior(scaleDownBehavior == null ? null : scaleDownBehavior.toString());
            return this;
        }

        public final void setScaleDownBehavior(String scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
        }

        public final String getCustomAmiId() {
            return customAmiId;
        }

        @Override
        public final Builder customAmiId(String customAmiId) {
            this.customAmiId = customAmiId;
            return this;
        }

        public final void setCustomAmiId(String customAmiId) {
            this.customAmiId = customAmiId;
        }

        public final Integer getEbsRootVolumeSize() {
            return ebsRootVolumeSize;
        }

        @Override
        public final Builder ebsRootVolumeSize(Integer ebsRootVolumeSize) {
            this.ebsRootVolumeSize = ebsRootVolumeSize;
            return this;
        }

        public final void setEbsRootVolumeSize(Integer ebsRootVolumeSize) {
            this.ebsRootVolumeSize = ebsRootVolumeSize;
        }

        public final String getRepoUpgradeOnBoot() {
            return repoUpgradeOnBoot;
        }

        @Override
        public final Builder repoUpgradeOnBoot(String repoUpgradeOnBoot) {
            this.repoUpgradeOnBoot = repoUpgradeOnBoot;
            return this;
        }

        @Override
        public final Builder repoUpgradeOnBoot(RepoUpgradeOnBoot repoUpgradeOnBoot) {
            this.repoUpgradeOnBoot(repoUpgradeOnBoot == null ? null : repoUpgradeOnBoot.toString());
            return this;
        }

        public final void setRepoUpgradeOnBoot(String repoUpgradeOnBoot) {
            this.repoUpgradeOnBoot = repoUpgradeOnBoot;
        }

        public final KerberosAttributes.Builder getKerberosAttributes() {
            return kerberosAttributes != null ? kerberosAttributes.toBuilder() : null;
        }

        @Override
        public final Builder kerberosAttributes(KerberosAttributes kerberosAttributes) {
            this.kerberosAttributes = kerberosAttributes;
            return this;
        }

        public final void setKerberosAttributes(KerberosAttributes.BuilderImpl kerberosAttributes) {
            this.kerberosAttributes = kerberosAttributes != null ? kerberosAttributes.build() : null;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        public final Integer getStepConcurrencyLevel() {
            return stepConcurrencyLevel;
        }

        @Override
        public final Builder stepConcurrencyLevel(Integer stepConcurrencyLevel) {
            this.stepConcurrencyLevel = stepConcurrencyLevel;
            return this;
        }

        public final void setStepConcurrencyLevel(Integer stepConcurrencyLevel) {
            this.stepConcurrencyLevel = stepConcurrencyLevel;
        }

        public final List<PlacementGroupConfig.Builder> getPlacementGroups() {
            List<PlacementGroupConfig.Builder> result = PlacementGroupConfigListCopier.copyToBuilder(this.placementGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder placementGroups(Collection<PlacementGroupConfig> placementGroups) {
            this.placementGroups = PlacementGroupConfigListCopier.copy(placementGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementGroups(PlacementGroupConfig... placementGroups) {
            placementGroups(Arrays.asList(placementGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementGroups(Consumer<PlacementGroupConfig.Builder>... placementGroups) {
            placementGroups(Stream.of(placementGroups).map(c -> PlacementGroupConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementGroups(Collection<PlacementGroupConfig.BuilderImpl> placementGroups) {
            this.placementGroups = PlacementGroupConfigListCopier.copyFromBuilder(placementGroups);
        }

        @Override
        public Cluster build() {
            return new Cluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
