/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specification of a cluster (job flow) step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StepConfig implements SdkPojo, Serializable, ToCopyableBuilder<StepConfig.Builder, StepConfig> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(StepConfig::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ACTION_ON_FAILURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionOnFailure").getter(getter(StepConfig::actionOnFailureAsString))
            .setter(setter(Builder::actionOnFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionOnFailure").build()).build();

    private static final SdkField<HadoopJarStepConfig> HADOOP_JAR_STEP_FIELD = SdkField
            .<HadoopJarStepConfig> builder(MarshallingType.SDK_POJO).memberName("HadoopJarStep")
            .getter(getter(StepConfig::hadoopJarStep)).setter(setter(Builder::hadoopJarStep))
            .constructor(HadoopJarStepConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HadoopJarStep").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ACTION_ON_FAILURE_FIELD, HADOOP_JAR_STEP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String actionOnFailure;

    private final HadoopJarStepConfig hadoopJarStep;

    private StepConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.actionOnFailure = builder.actionOnFailure;
        this.hadoopJarStep = builder.hadoopJarStep;
    }

    /**
     * <p>
     * The name of the step.
     * </p>
     * 
     * @return The name of the step.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER, CANCEL_AND_WAIT, and
     * CONTINUE. TERMINATE_JOB_FLOW is provided for backward compatibility. We recommend using TERMINATE_CLUSTER
     * instead.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionOnFailure}
     * will return {@link ActionOnFailure#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionOnFailureAsString}.
     * </p>
     * 
     * @return The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER, CANCEL_AND_WAIT,
     *         and CONTINUE. TERMINATE_JOB_FLOW is provided for backward compatibility. We recommend using
     *         TERMINATE_CLUSTER instead.
     * @see ActionOnFailure
     */
    public final ActionOnFailure actionOnFailure() {
        return ActionOnFailure.fromValue(actionOnFailure);
    }

    /**
     * <p>
     * The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER, CANCEL_AND_WAIT, and
     * CONTINUE. TERMINATE_JOB_FLOW is provided for backward compatibility. We recommend using TERMINATE_CLUSTER
     * instead.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionOnFailure}
     * will return {@link ActionOnFailure#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionOnFailureAsString}.
     * </p>
     * 
     * @return The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER, CANCEL_AND_WAIT,
     *         and CONTINUE. TERMINATE_JOB_FLOW is provided for backward compatibility. We recommend using
     *         TERMINATE_CLUSTER instead.
     * @see ActionOnFailure
     */
    public final String actionOnFailureAsString() {
        return actionOnFailure;
    }

    /**
     * <p>
     * The JAR file used for the step.
     * </p>
     * 
     * @return The JAR file used for the step.
     */
    public final HadoopJarStepConfig hadoopJarStep() {
        return hadoopJarStep;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(actionOnFailureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hadoopJarStep());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepConfig)) {
            return false;
        }
        StepConfig other = (StepConfig) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(actionOnFailureAsString(), other.actionOnFailureAsString())
                && Objects.equals(hadoopJarStep(), other.hadoopJarStep());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StepConfig").add("Name", name()).add("ActionOnFailure", actionOnFailureAsString())
                .add("HadoopJarStep", hadoopJarStep()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ActionOnFailure":
            return Optional.ofNullable(clazz.cast(actionOnFailureAsString()));
        case "HadoopJarStep":
            return Optional.ofNullable(clazz.cast(hadoopJarStep()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StepConfig, T> g) {
        return obj -> g.apply((StepConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StepConfig> {
        /**
         * <p>
         * The name of the step.
         * </p>
         * 
         * @param name
         *        The name of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER, CANCEL_AND_WAIT, and
         * CONTINUE. TERMINATE_JOB_FLOW is provided for backward compatibility. We recommend using TERMINATE_CLUSTER
         * instead.
         * </p>
         * 
         * @param actionOnFailure
         *        The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER,
         *        CANCEL_AND_WAIT, and CONTINUE. TERMINATE_JOB_FLOW is provided for backward compatibility. We recommend
         *        using TERMINATE_CLUSTER instead.
         * @see ActionOnFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionOnFailure
         */
        Builder actionOnFailure(String actionOnFailure);

        /**
         * <p>
         * The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER, CANCEL_AND_WAIT, and
         * CONTINUE. TERMINATE_JOB_FLOW is provided for backward compatibility. We recommend using TERMINATE_CLUSTER
         * instead.
         * </p>
         * 
         * @param actionOnFailure
         *        The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER,
         *        CANCEL_AND_WAIT, and CONTINUE. TERMINATE_JOB_FLOW is provided for backward compatibility. We recommend
         *        using TERMINATE_CLUSTER instead.
         * @see ActionOnFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionOnFailure
         */
        Builder actionOnFailure(ActionOnFailure actionOnFailure);

        /**
         * <p>
         * The JAR file used for the step.
         * </p>
         * 
         * @param hadoopJarStep
         *        The JAR file used for the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hadoopJarStep(HadoopJarStepConfig hadoopJarStep);

        /**
         * <p>
         * The JAR file used for the step.
         * </p>
         * This is a convenience that creates an instance of the {@link HadoopJarStepConfig.Builder} avoiding the need
         * to create one manually via {@link HadoopJarStepConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HadoopJarStepConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #hadoopJarStep(HadoopJarStepConfig)}.
         * 
         * @param hadoopJarStep
         *        a consumer that will call methods on {@link HadoopJarStepConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hadoopJarStep(HadoopJarStepConfig)
         */
        default Builder hadoopJarStep(Consumer<HadoopJarStepConfig.Builder> hadoopJarStep) {
            return hadoopJarStep(HadoopJarStepConfig.builder().applyMutation(hadoopJarStep).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String actionOnFailure;

        private HadoopJarStepConfig hadoopJarStep;

        private BuilderImpl() {
        }

        private BuilderImpl(StepConfig model) {
            name(model.name);
            actionOnFailure(model.actionOnFailure);
            hadoopJarStep(model.hadoopJarStep);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getActionOnFailure() {
            return actionOnFailure;
        }

        @Override
        public final Builder actionOnFailure(String actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
            return this;
        }

        @Override
        public final Builder actionOnFailure(ActionOnFailure actionOnFailure) {
            this.actionOnFailure(actionOnFailure == null ? null : actionOnFailure.toString());
            return this;
        }

        public final void setActionOnFailure(String actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
        }

        public final HadoopJarStepConfig.Builder getHadoopJarStep() {
            return hadoopJarStep != null ? hadoopJarStep.toBuilder() : null;
        }

        @Override
        public final Builder hadoopJarStep(HadoopJarStepConfig hadoopJarStep) {
            this.hadoopJarStep = hadoopJarStep;
            return this;
        }

        public final void setHadoopJarStep(HadoopJarStepConfig.BuilderImpl hadoopJarStep) {
            this.hadoopJarStep = hadoopJarStep != null ? hadoopJarStep.build() : null;
        }

        @Override
        public StepConfig build() {
            return new StepConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
