/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specification of the status of a CancelSteps request. Available only in Amazon EMR version 4.8.0 and later, excluding
 * version 5.0.0.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelStepsInfo implements SdkPojo, Serializable, ToCopyableBuilder<CancelStepsInfo.Builder, CancelStepsInfo> {
    private static final SdkField<String> STEP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("StepId")
            .getter(getter(CancelStepsInfo::stepId)).setter(setter(Builder::stepId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CancelStepsInfo::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(CancelStepsInfo::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_ID_FIELD, STATUS_FIELD,
            REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stepId;

    private final String status;

    private final String reason;

    private CancelStepsInfo(BuilderImpl builder) {
        this.stepId = builder.stepId;
        this.status = builder.status;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The encrypted StepId of a step.
     * </p>
     * 
     * @return The encrypted StepId of a step.
     */
    public final String stepId() {
        return stepId;
    }

    /**
     * <p>
     * The status of a CancelSteps Request. The value may be SUBMITTED or FAILED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CancelStepsRequestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a CancelSteps Request. The value may be SUBMITTED or FAILED.
     * @see CancelStepsRequestStatus
     */
    public final CancelStepsRequestStatus status() {
        return CancelStepsRequestStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a CancelSteps Request. The value may be SUBMITTED or FAILED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CancelStepsRequestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a CancelSteps Request. The value may be SUBMITTED or FAILED.
     * @see CancelStepsRequestStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the failure if the CancelSteps request fails.
     * </p>
     * 
     * @return The reason for the failure if the CancelSteps request fails.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelStepsInfo)) {
            return false;
        }
        CancelStepsInfo other = (CancelStepsInfo) obj;
        return Objects.equals(stepId(), other.stepId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelStepsInfo").add("StepId", stepId()).add("Status", statusAsString())
                .add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StepId":
            return Optional.ofNullable(clazz.cast(stepId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelStepsInfo, T> g) {
        return obj -> g.apply((CancelStepsInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CancelStepsInfo> {
        /**
         * <p>
         * The encrypted StepId of a step.
         * </p>
         * 
         * @param stepId
         *        The encrypted StepId of a step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepId(String stepId);

        /**
         * <p>
         * The status of a CancelSteps Request. The value may be SUBMITTED or FAILED.
         * </p>
         * 
         * @param status
         *        The status of a CancelSteps Request. The value may be SUBMITTED or FAILED.
         * @see CancelStepsRequestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CancelStepsRequestStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a CancelSteps Request. The value may be SUBMITTED or FAILED.
         * </p>
         * 
         * @param status
         *        The status of a CancelSteps Request. The value may be SUBMITTED or FAILED.
         * @see CancelStepsRequestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CancelStepsRequestStatus
         */
        Builder status(CancelStepsRequestStatus status);

        /**
         * <p>
         * The reason for the failure if the CancelSteps request fails.
         * </p>
         * 
         * @param reason
         *        The reason for the failure if the CancelSteps request fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);
    }

    static final class BuilderImpl implements Builder {
        private String stepId;

        private String status;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelStepsInfo model) {
            stepId(model.stepId);
            status(model.status);
            reason(model.reason);
        }

        public final String getStepId() {
            return stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        @Transient
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(CancelStepsRequestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        @Transient
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public CancelStepsInfo build() {
            return new CancelStepsInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
