/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input argument to the <a>CancelSteps</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelStepsRequest extends EmrRequest implements
        ToCopyableBuilder<CancelStepsRequest.Builder, CancelStepsRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(CancelStepsRequest::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<List<String>> STEP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StepIds")
            .getter(getter(CancelStepsRequest::stepIds))
            .setter(setter(Builder::stepIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STEP_CANCELLATION_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StepCancellationOption").getter(getter(CancelStepsRequest::stepCancellationOptionAsString))
            .setter(setter(Builder::stepCancellationOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepCancellationOption").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD,
            STEP_IDS_FIELD, STEP_CANCELLATION_OPTION_FIELD));

    private final String clusterId;

    private final List<String> stepIds;

    private final String stepCancellationOption;

    private CancelStepsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.stepIds = builder.stepIds;
        this.stepCancellationOption = builder.stepCancellationOption;
    }

    /**
     * <p>
     * The <code>ClusterID</code> for the specified steps that will be canceled. Use <a>RunJobFlow</a> and
     * <a>ListClusters</a> to get ClusterIDs.
     * </p>
     * 
     * @return The <code>ClusterID</code> for the specified steps that will be canceled. Use <a>RunJobFlow</a> and
     *         <a>ListClusters</a> to get ClusterIDs.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * For responses, this returns true if the service returned a value for the StepIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStepIds() {
        return stepIds != null && !(stepIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <code>StepIDs</code> to cancel. Use <a>ListSteps</a> to get steps and their states for the specified
     * cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStepIds} method.
     * </p>
     * 
     * @return The list of <code>StepIDs</code> to cancel. Use <a>ListSteps</a> to get steps and their states for the
     *         specified cluster.
     */
    public final List<String> stepIds() {
        return stepIds;
    }

    /**
     * <p>
     * The option to choose to cancel <code>RUNNING</code> steps. By default, the value is <code>SEND_INTERRUPT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #stepCancellationOption} will return {@link StepCancellationOption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #stepCancellationOptionAsString}.
     * </p>
     * 
     * @return The option to choose to cancel <code>RUNNING</code> steps. By default, the value is
     *         <code>SEND_INTERRUPT</code>.
     * @see StepCancellationOption
     */
    public final StepCancellationOption stepCancellationOption() {
        return StepCancellationOption.fromValue(stepCancellationOption);
    }

    /**
     * <p>
     * The option to choose to cancel <code>RUNNING</code> steps. By default, the value is <code>SEND_INTERRUPT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #stepCancellationOption} will return {@link StepCancellationOption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #stepCancellationOptionAsString}.
     * </p>
     * 
     * @return The option to choose to cancel <code>RUNNING</code> steps. By default, the value is
     *         <code>SEND_INTERRUPT</code>.
     * @see StepCancellationOption
     */
    public final String stepCancellationOptionAsString() {
        return stepCancellationOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(hasStepIds() ? stepIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stepCancellationOptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelStepsRequest)) {
            return false;
        }
        CancelStepsRequest other = (CancelStepsRequest) obj;
        return Objects.equals(clusterId(), other.clusterId()) && hasStepIds() == other.hasStepIds()
                && Objects.equals(stepIds(), other.stepIds())
                && Objects.equals(stepCancellationOptionAsString(), other.stepCancellationOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelStepsRequest").add("ClusterId", clusterId())
                .add("StepIds", hasStepIds() ? stepIds() : null).add("StepCancellationOption", stepCancellationOptionAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "StepIds":
            return Optional.ofNullable(clazz.cast(stepIds()));
        case "StepCancellationOption":
            return Optional.ofNullable(clazz.cast(stepCancellationOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelStepsRequest, T> g) {
        return obj -> g.apply((CancelStepsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, CancelStepsRequest> {
        /**
         * <p>
         * The <code>ClusterID</code> for the specified steps that will be canceled. Use <a>RunJobFlow</a> and
         * <a>ListClusters</a> to get ClusterIDs.
         * </p>
         * 
         * @param clusterId
         *        The <code>ClusterID</code> for the specified steps that will be canceled. Use <a>RunJobFlow</a> and
         *        <a>ListClusters</a> to get ClusterIDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The list of <code>StepIDs</code> to cancel. Use <a>ListSteps</a> to get steps and their states for the
         * specified cluster.
         * </p>
         * 
         * @param stepIds
         *        The list of <code>StepIDs</code> to cancel. Use <a>ListSteps</a> to get steps and their states for the
         *        specified cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepIds(Collection<String> stepIds);

        /**
         * <p>
         * The list of <code>StepIDs</code> to cancel. Use <a>ListSteps</a> to get steps and their states for the
         * specified cluster.
         * </p>
         * 
         * @param stepIds
         *        The list of <code>StepIDs</code> to cancel. Use <a>ListSteps</a> to get steps and their states for the
         *        specified cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepIds(String... stepIds);

        /**
         * <p>
         * The option to choose to cancel <code>RUNNING</code> steps. By default, the value is
         * <code>SEND_INTERRUPT</code>.
         * </p>
         * 
         * @param stepCancellationOption
         *        The option to choose to cancel <code>RUNNING</code> steps. By default, the value is
         *        <code>SEND_INTERRUPT</code>.
         * @see StepCancellationOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepCancellationOption
         */
        Builder stepCancellationOption(String stepCancellationOption);

        /**
         * <p>
         * The option to choose to cancel <code>RUNNING</code> steps. By default, the value is
         * <code>SEND_INTERRUPT</code>.
         * </p>
         * 
         * @param stepCancellationOption
         *        The option to choose to cancel <code>RUNNING</code> steps. By default, the value is
         *        <code>SEND_INTERRUPT</code>.
         * @see StepCancellationOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepCancellationOption
         */
        Builder stepCancellationOption(StepCancellationOption stepCancellationOption);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String clusterId;

        private List<String> stepIds = DefaultSdkAutoConstructList.getInstance();

        private String stepCancellationOption;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelStepsRequest model) {
            super(model);
            clusterId(model.clusterId);
            stepIds(model.stepIds);
            stepCancellationOption(model.stepCancellationOption);
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        @Transient
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final Collection<String> getStepIds() {
            if (stepIds instanceof SdkAutoConstructList) {
                return null;
            }
            return stepIds;
        }

        public final void setStepIds(Collection<String> stepIds) {
            this.stepIds = StepIdsListCopier.copy(stepIds);
        }

        @Override
        @Transient
        public final Builder stepIds(Collection<String> stepIds) {
            this.stepIds = StepIdsListCopier.copy(stepIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stepIds(String... stepIds) {
            stepIds(Arrays.asList(stepIds));
            return this;
        }

        public final String getStepCancellationOption() {
            return stepCancellationOption;
        }

        public final void setStepCancellationOption(String stepCancellationOption) {
            this.stepCancellationOption = stepCancellationOption;
        }

        @Override
        @Transient
        public final Builder stepCancellationOption(String stepCancellationOption) {
            this.stepCancellationOption = stepCancellationOption;
            return this;
        }

        @Override
        @Transient
        public final Builder stepCancellationOption(StepCancellationOption stepCancellationOption) {
            this.stepCancellationOption(stepCancellationOption == null ? null : stepCancellationOption.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelStepsRequest build() {
            return new CancelStepsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
