/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * EBS block device that's attached to an EC2 instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbsVolume implements SdkPojo, Serializable, ToCopyableBuilder<EbsVolume.Builder, EbsVolume> {
    private static final SdkField<String> DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Device")
            .getter(getter(EbsVolume::device)).setter(setter(Builder::device))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Device").build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeId").getter(getter(EbsVolume::volumeId)).setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DEVICE_FIELD, VOLUME_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String device;

    private final String volumeId;

    private EbsVolume(BuilderImpl builder) {
        this.device = builder.device;
        this.volumeId = builder.volumeId;
    }

    /**
     * <p>
     * The device name that is exposed to the instance, such as /dev/sdh.
     * </p>
     * 
     * @return The device name that is exposed to the instance, such as /dev/sdh.
     */
    public final String device() {
        return device;
    }

    /**
     * <p>
     * The volume identifier of the EBS volume.
     * </p>
     * 
     * @return The volume identifier of the EBS volume.
     */
    public final String volumeId() {
        return volumeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(device());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsVolume)) {
            return false;
        }
        EbsVolume other = (EbsVolume) obj;
        return Objects.equals(device(), other.device()) && Objects.equals(volumeId(), other.volumeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EbsVolume").add("Device", device()).add("VolumeId", volumeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Device":
            return Optional.ofNullable(clazz.cast(device()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsVolume, T> g) {
        return obj -> g.apply((EbsVolume) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbsVolume> {
        /**
         * <p>
         * The device name that is exposed to the instance, such as /dev/sdh.
         * </p>
         * 
         * @param device
         *        The device name that is exposed to the instance, such as /dev/sdh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(String device);

        /**
         * <p>
         * The volume identifier of the EBS volume.
         * </p>
         * 
         * @param volumeId
         *        The volume identifier of the EBS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);
    }

    static final class BuilderImpl implements Builder {
        private String device;

        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsVolume model) {
            device(model.device);
            volumeId(model.volumeId);
        }

        public final String getDevice() {
            return device;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        @Override
        @Transient
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        @Transient
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        @Override
        public EbsVolume build() {
            return new EbsVolume(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
