/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBlockPublicAccessConfigurationResponse extends EmrResponse implements
        ToCopyableBuilder<GetBlockPublicAccessConfigurationResponse.Builder, GetBlockPublicAccessConfigurationResponse> {
    private static final SdkField<BlockPublicAccessConfiguration> BLOCK_PUBLIC_ACCESS_CONFIGURATION_FIELD = SdkField
            .<BlockPublicAccessConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("BlockPublicAccessConfiguration")
            .getter(getter(GetBlockPublicAccessConfigurationResponse::blockPublicAccessConfiguration))
            .setter(setter(Builder::blockPublicAccessConfiguration))
            .constructor(BlockPublicAccessConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockPublicAccessConfiguration")
                    .build()).build();

    private static final SdkField<BlockPublicAccessConfigurationMetadata> BLOCK_PUBLIC_ACCESS_CONFIGURATION_METADATA_FIELD = SdkField
            .<BlockPublicAccessConfigurationMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("BlockPublicAccessConfigurationMetadata")
            .getter(getter(GetBlockPublicAccessConfigurationResponse::blockPublicAccessConfigurationMetadata))
            .setter(setter(Builder::blockPublicAccessConfigurationMetadata))
            .constructor(BlockPublicAccessConfigurationMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("BlockPublicAccessConfigurationMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BLOCK_PUBLIC_ACCESS_CONFIGURATION_FIELD, BLOCK_PUBLIC_ACCESS_CONFIGURATION_METADATA_FIELD));

    private final BlockPublicAccessConfiguration blockPublicAccessConfiguration;

    private final BlockPublicAccessConfigurationMetadata blockPublicAccessConfigurationMetadata;

    private GetBlockPublicAccessConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.blockPublicAccessConfiguration = builder.blockPublicAccessConfiguration;
        this.blockPublicAccessConfigurationMetadata = builder.blockPublicAccessConfigurationMetadata;
    }

    /**
     * <p>
     * A configuration for Amazon EMR block public access. The configuration applies to all clusters created in your
     * account for the current Region. The configuration specifies whether block public access is enabled. If block
     * public access is enabled, security groups associated with the cluster cannot have rules that allow inbound
     * traffic from 0.0.0.0/0 or ::/0 on a port, unless the port is specified as an exception using
     * <code>PermittedPublicSecurityGroupRuleRanges</code> in the <code>BlockPublicAccessConfiguration</code>. By
     * default, Port 22 (SSH) is an exception, and public access is allowed on this port. You can change this by
     * updating the block public access configuration to remove the exception.
     * </p>
     * <note>
     * <p>
     * For accounts that created clusters in a Region before November 25, 2019, block public access is disabled by
     * default in that Region. To use this feature, you must manually enable and configure it. For accounts that did not
     * create an EMR cluster in a Region before this date, block public access is enabled by default in that Region.
     * </p>
     * </note>
     * 
     * @return A configuration for Amazon EMR block public access. The configuration applies to all clusters created in
     *         your account for the current Region. The configuration specifies whether block public access is enabled.
     *         If block public access is enabled, security groups associated with the cluster cannot have rules that
     *         allow inbound traffic from 0.0.0.0/0 or ::/0 on a port, unless the port is specified as an exception
     *         using <code>PermittedPublicSecurityGroupRuleRanges</code> in the
     *         <code>BlockPublicAccessConfiguration</code>. By default, Port 22 (SSH) is an exception, and public access
     *         is allowed on this port. You can change this by updating the block public access configuration to remove
     *         the exception.</p> <note>
     *         <p>
     *         For accounts that created clusters in a Region before November 25, 2019, block public access is disabled
     *         by default in that Region. To use this feature, you must manually enable and configure it. For accounts
     *         that did not create an EMR cluster in a Region before this date, block public access is enabled by
     *         default in that Region.
     *         </p>
     */
    public final BlockPublicAccessConfiguration blockPublicAccessConfiguration() {
        return blockPublicAccessConfiguration;
    }

    /**
     * <p>
     * Properties that describe the Amazon Web Services principal that created the
     * <code>BlockPublicAccessConfiguration</code> using the <code>PutBlockPublicAccessConfiguration</code> action as
     * well as the date and time that the configuration was created. Each time a configuration for block public access
     * is updated, Amazon EMR updates this metadata.
     * </p>
     * 
     * @return Properties that describe the Amazon Web Services principal that created the
     *         <code>BlockPublicAccessConfiguration</code> using the <code>PutBlockPublicAccessConfiguration</code>
     *         action as well as the date and time that the configuration was created. Each time a configuration for
     *         block public access is updated, Amazon EMR updates this metadata.
     */
    public final BlockPublicAccessConfigurationMetadata blockPublicAccessConfigurationMetadata() {
        return blockPublicAccessConfigurationMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(blockPublicAccessConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(blockPublicAccessConfigurationMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlockPublicAccessConfigurationResponse)) {
            return false;
        }
        GetBlockPublicAccessConfigurationResponse other = (GetBlockPublicAccessConfigurationResponse) obj;
        return Objects.equals(blockPublicAccessConfiguration(), other.blockPublicAccessConfiguration())
                && Objects.equals(blockPublicAccessConfigurationMetadata(), other.blockPublicAccessConfigurationMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBlockPublicAccessConfigurationResponse")
                .add("BlockPublicAccessConfiguration", blockPublicAccessConfiguration())
                .add("BlockPublicAccessConfigurationMetadata", blockPublicAccessConfigurationMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockPublicAccessConfiguration":
            return Optional.ofNullable(clazz.cast(blockPublicAccessConfiguration()));
        case "BlockPublicAccessConfigurationMetadata":
            return Optional.ofNullable(clazz.cast(blockPublicAccessConfigurationMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBlockPublicAccessConfigurationResponse, T> g) {
        return obj -> g.apply((GetBlockPublicAccessConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBlockPublicAccessConfigurationResponse> {
        /**
         * <p>
         * A configuration for Amazon EMR block public access. The configuration applies to all clusters created in your
         * account for the current Region. The configuration specifies whether block public access is enabled. If block
         * public access is enabled, security groups associated with the cluster cannot have rules that allow inbound
         * traffic from 0.0.0.0/0 or ::/0 on a port, unless the port is specified as an exception using
         * <code>PermittedPublicSecurityGroupRuleRanges</code> in the <code>BlockPublicAccessConfiguration</code>. By
         * default, Port 22 (SSH) is an exception, and public access is allowed on this port. You can change this by
         * updating the block public access configuration to remove the exception.
         * </p>
         * <note>
         * <p>
         * For accounts that created clusters in a Region before November 25, 2019, block public access is disabled by
         * default in that Region. To use this feature, you must manually enable and configure it. For accounts that did
         * not create an EMR cluster in a Region before this date, block public access is enabled by default in that
         * Region.
         * </p>
         * </note>
         * 
         * @param blockPublicAccessConfiguration
         *        A configuration for Amazon EMR block public access. The configuration applies to all clusters created
         *        in your account for the current Region. The configuration specifies whether block public access is
         *        enabled. If block public access is enabled, security groups associated with the cluster cannot have
         *        rules that allow inbound traffic from 0.0.0.0/0 or ::/0 on a port, unless the port is specified as an
         *        exception using <code>PermittedPublicSecurityGroupRuleRanges</code> in the
         *        <code>BlockPublicAccessConfiguration</code>. By default, Port 22 (SSH) is an exception, and public
         *        access is allowed on this port. You can change this by updating the block public access configuration
         *        to remove the exception.</p> <note>
         *        <p>
         *        For accounts that created clusters in a Region before November 25, 2019, block public access is
         *        disabled by default in that Region. To use this feature, you must manually enable and configure it.
         *        For accounts that did not create an EMR cluster in a Region before this date, block public access is
         *        enabled by default in that Region.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockPublicAccessConfiguration(BlockPublicAccessConfiguration blockPublicAccessConfiguration);

        /**
         * <p>
         * A configuration for Amazon EMR block public access. The configuration applies to all clusters created in your
         * account for the current Region. The configuration specifies whether block public access is enabled. If block
         * public access is enabled, security groups associated with the cluster cannot have rules that allow inbound
         * traffic from 0.0.0.0/0 or ::/0 on a port, unless the port is specified as an exception using
         * <code>PermittedPublicSecurityGroupRuleRanges</code> in the <code>BlockPublicAccessConfiguration</code>. By
         * default, Port 22 (SSH) is an exception, and public access is allowed on this port. You can change this by
         * updating the block public access configuration to remove the exception.
         * </p>
         * <note>
         * <p>
         * For accounts that created clusters in a Region before November 25, 2019, block public access is disabled by
         * default in that Region. To use this feature, you must manually enable and configure it. For accounts that did
         * not create an EMR cluster in a Region before this date, block public access is enabled by default in that
         * Region.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link BlockPublicAccessConfiguration.Builder}
         * avoiding the need to create one manually via {@link BlockPublicAccessConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link BlockPublicAccessConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #blockPublicAccessConfiguration(BlockPublicAccessConfiguration)}.
         * 
         * @param blockPublicAccessConfiguration
         *        a consumer that will call methods on {@link BlockPublicAccessConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockPublicAccessConfiguration(BlockPublicAccessConfiguration)
         */
        default Builder blockPublicAccessConfiguration(
                Consumer<BlockPublicAccessConfiguration.Builder> blockPublicAccessConfiguration) {
            return blockPublicAccessConfiguration(BlockPublicAccessConfiguration.builder()
                    .applyMutation(blockPublicAccessConfiguration).build());
        }

        /**
         * <p>
         * Properties that describe the Amazon Web Services principal that created the
         * <code>BlockPublicAccessConfiguration</code> using the <code>PutBlockPublicAccessConfiguration</code> action
         * as well as the date and time that the configuration was created. Each time a configuration for block public
         * access is updated, Amazon EMR updates this metadata.
         * </p>
         * 
         * @param blockPublicAccessConfigurationMetadata
         *        Properties that describe the Amazon Web Services principal that created the
         *        <code>BlockPublicAccessConfiguration</code> using the <code>PutBlockPublicAccessConfiguration</code>
         *        action as well as the date and time that the configuration was created. Each time a configuration for
         *        block public access is updated, Amazon EMR updates this metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockPublicAccessConfigurationMetadata(
                BlockPublicAccessConfigurationMetadata blockPublicAccessConfigurationMetadata);

        /**
         * <p>
         * Properties that describe the Amazon Web Services principal that created the
         * <code>BlockPublicAccessConfiguration</code> using the <code>PutBlockPublicAccessConfiguration</code> action
         * as well as the date and time that the configuration was created. Each time a configuration for block public
         * access is updated, Amazon EMR updates this metadata.
         * </p>
         * This is a convenience that creates an instance of the {@link BlockPublicAccessConfigurationMetadata.Builder}
         * avoiding the need to create one manually via {@link BlockPublicAccessConfigurationMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link BlockPublicAccessConfigurationMetadata.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #blockPublicAccessConfigurationMetadata(BlockPublicAccessConfigurationMetadata)}.
         * 
         * @param blockPublicAccessConfigurationMetadata
         *        a consumer that will call methods on {@link BlockPublicAccessConfigurationMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockPublicAccessConfigurationMetadata(BlockPublicAccessConfigurationMetadata)
         */
        default Builder blockPublicAccessConfigurationMetadata(
                Consumer<BlockPublicAccessConfigurationMetadata.Builder> blockPublicAccessConfigurationMetadata) {
            return blockPublicAccessConfigurationMetadata(BlockPublicAccessConfigurationMetadata.builder()
                    .applyMutation(blockPublicAccessConfigurationMetadata).build());
        }
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private BlockPublicAccessConfiguration blockPublicAccessConfiguration;

        private BlockPublicAccessConfigurationMetadata blockPublicAccessConfigurationMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlockPublicAccessConfigurationResponse model) {
            super(model);
            blockPublicAccessConfiguration(model.blockPublicAccessConfiguration);
            blockPublicAccessConfigurationMetadata(model.blockPublicAccessConfigurationMetadata);
        }

        public final BlockPublicAccessConfiguration.Builder getBlockPublicAccessConfiguration() {
            return blockPublicAccessConfiguration != null ? blockPublicAccessConfiguration.toBuilder() : null;
        }

        public final void setBlockPublicAccessConfiguration(
                BlockPublicAccessConfiguration.BuilderImpl blockPublicAccessConfiguration) {
            this.blockPublicAccessConfiguration = blockPublicAccessConfiguration != null ? blockPublicAccessConfiguration.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder blockPublicAccessConfiguration(BlockPublicAccessConfiguration blockPublicAccessConfiguration) {
            this.blockPublicAccessConfiguration = blockPublicAccessConfiguration;
            return this;
        }

        public final BlockPublicAccessConfigurationMetadata.Builder getBlockPublicAccessConfigurationMetadata() {
            return blockPublicAccessConfigurationMetadata != null ? blockPublicAccessConfigurationMetadata.toBuilder() : null;
        }

        public final void setBlockPublicAccessConfigurationMetadata(
                BlockPublicAccessConfigurationMetadata.BuilderImpl blockPublicAccessConfigurationMetadata) {
            this.blockPublicAccessConfigurationMetadata = blockPublicAccessConfigurationMetadata != null ? blockPublicAccessConfigurationMetadata
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder blockPublicAccessConfigurationMetadata(
                BlockPublicAccessConfigurationMetadata blockPublicAccessConfigurationMetadata) {
            this.blockPublicAccessConfigurationMetadata = blockPublicAccessConfigurationMetadata;
            return this;
        }

        @Override
        public GetBlockPublicAccessConfigurationResponse build() {
            return new GetBlockPublicAccessConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
