/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetManagedScalingPolicyResponse extends EmrResponse implements
        ToCopyableBuilder<GetManagedScalingPolicyResponse.Builder, GetManagedScalingPolicyResponse> {
    private static final SdkField<ManagedScalingPolicy> MANAGED_SCALING_POLICY_FIELD = SdkField
            .<ManagedScalingPolicy> builder(MarshallingType.SDK_POJO).memberName("ManagedScalingPolicy")
            .getter(getter(GetManagedScalingPolicyResponse::managedScalingPolicy)).setter(setter(Builder::managedScalingPolicy))
            .constructor(ManagedScalingPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedScalingPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_SCALING_POLICY_FIELD));

    private final ManagedScalingPolicy managedScalingPolicy;

    private GetManagedScalingPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.managedScalingPolicy = builder.managedScalingPolicy;
    }

    /**
     * <p>
     * Specifies the managed scaling policy that is attached to an Amazon EMR cluster.
     * </p>
     * 
     * @return Specifies the managed scaling policy that is attached to an Amazon EMR cluster.
     */
    public final ManagedScalingPolicy managedScalingPolicy() {
        return managedScalingPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(managedScalingPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetManagedScalingPolicyResponse)) {
            return false;
        }
        GetManagedScalingPolicyResponse other = (GetManagedScalingPolicyResponse) obj;
        return Objects.equals(managedScalingPolicy(), other.managedScalingPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetManagedScalingPolicyResponse").add("ManagedScalingPolicy", managedScalingPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedScalingPolicy":
            return Optional.ofNullable(clazz.cast(managedScalingPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetManagedScalingPolicyResponse, T> g) {
        return obj -> g.apply((GetManagedScalingPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetManagedScalingPolicyResponse> {
        /**
         * <p>
         * Specifies the managed scaling policy that is attached to an Amazon EMR cluster.
         * </p>
         * 
         * @param managedScalingPolicy
         *        Specifies the managed scaling policy that is attached to an Amazon EMR cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedScalingPolicy(ManagedScalingPolicy managedScalingPolicy);

        /**
         * <p>
         * Specifies the managed scaling policy that is attached to an Amazon EMR cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link ManagedScalingPolicy.Builder} avoiding the need
         * to create one manually via {@link ManagedScalingPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link ManagedScalingPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #managedScalingPolicy(ManagedScalingPolicy)}.
         * 
         * @param managedScalingPolicy
         *        a consumer that will call methods on {@link ManagedScalingPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedScalingPolicy(ManagedScalingPolicy)
         */
        default Builder managedScalingPolicy(Consumer<ManagedScalingPolicy.Builder> managedScalingPolicy) {
            return managedScalingPolicy(ManagedScalingPolicy.builder().applyMutation(managedScalingPolicy).build());
        }
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private ManagedScalingPolicy managedScalingPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetManagedScalingPolicyResponse model) {
            super(model);
            managedScalingPolicy(model.managedScalingPolicy);
        }

        public final ManagedScalingPolicy.Builder getManagedScalingPolicy() {
            return managedScalingPolicy != null ? managedScalingPolicy.toBuilder() : null;
        }

        public final void setManagedScalingPolicy(ManagedScalingPolicy.BuilderImpl managedScalingPolicy) {
            this.managedScalingPolicy = managedScalingPolicy != null ? managedScalingPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder managedScalingPolicy(ManagedScalingPolicy managedScalingPolicy) {
            this.managedScalingPolicy = managedScalingPolicy;
            return this;
        }

        @Override
        public GetManagedScalingPolicyResponse build() {
            return new GetManagedScalingPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
