/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the instance fleet.
 * </p>
 * <note>
 * <p>
 * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceFleetStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceFleetStatus.Builder, InstanceFleetStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(InstanceFleetStatus::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<InstanceFleetStateChangeReason> STATE_CHANGE_REASON_FIELD = SdkField
            .<InstanceFleetStateChangeReason> builder(MarshallingType.SDK_POJO).memberName("StateChangeReason")
            .getter(getter(InstanceFleetStatus::stateChangeReason)).setter(setter(Builder::stateChangeReason))
            .constructor(InstanceFleetStateChangeReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()).build();

    private static final SdkField<InstanceFleetTimeline> TIMELINE_FIELD = SdkField
            .<InstanceFleetTimeline> builder(MarshallingType.SDK_POJO).memberName("Timeline")
            .getter(getter(InstanceFleetStatus::timeline)).setter(setter(Builder::timeline))
            .constructor(InstanceFleetTimeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeline").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            STATE_CHANGE_REASON_FIELD, TIMELINE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String state;

    private final InstanceFleetStateChangeReason stateChangeReason;

    private final InstanceFleetTimeline timeline;

    private InstanceFleetStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.timeline = builder.timeline;
    }

    /**
     * <p>
     * A code representing the instance fleet status.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PROVISIONING</code>—The instance fleet is provisioning EC2 resources and is not yet ready to run jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BOOTSTRAPPING</code>—EC2 instances and other resources have been provisioned and the bootstrap actions
     * specified for the instances are underway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>—EC2 instances and other resources are running. They are either executing jobs or waiting to
     * execute jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESIZING</code>—A resize operation is underway. EC2 instances are either being added or removed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUSPENDED</code>—A resize operation could not complete. Existing EC2 instances are running, but instances
     * can't be added or removed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TERMINATING</code>—The instance fleet is terminating EC2 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TERMINATED</code>—The instance fleet is no longer active, and all EC2 instances have been terminated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InstanceFleetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return A code representing the instance fleet status.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PROVISIONING</code>—The instance fleet is provisioning EC2 resources and is not yet ready to run
     *         jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BOOTSTRAPPING</code>—EC2 instances and other resources have been provisioned and the bootstrap
     *         actions specified for the instances are underway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>—EC2 instances and other resources are running. They are either executing jobs or
     *         waiting to execute jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESIZING</code>—A resize operation is underway. EC2 instances are either being added or removed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUSPENDED</code>—A resize operation could not complete. Existing EC2 instances are running, but
     *         instances can't be added or removed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TERMINATING</code>—The instance fleet is terminating EC2 instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TERMINATED</code>—The instance fleet is no longer active, and all EC2 instances have been
     *         terminated.
     *         </p>
     *         </li>
     * @see InstanceFleetState
     */
    public final InstanceFleetState state() {
        return InstanceFleetState.fromValue(state);
    }

    /**
     * <p>
     * A code representing the instance fleet status.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PROVISIONING</code>—The instance fleet is provisioning EC2 resources and is not yet ready to run jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BOOTSTRAPPING</code>—EC2 instances and other resources have been provisioned and the bootstrap actions
     * specified for the instances are underway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>—EC2 instances and other resources are running. They are either executing jobs or waiting to
     * execute jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESIZING</code>—A resize operation is underway. EC2 instances are either being added or removed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUSPENDED</code>—A resize operation could not complete. Existing EC2 instances are running, but instances
     * can't be added or removed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TERMINATING</code>—The instance fleet is terminating EC2 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TERMINATED</code>—The instance fleet is no longer active, and all EC2 instances have been terminated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InstanceFleetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return A code representing the instance fleet status.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PROVISIONING</code>—The instance fleet is provisioning EC2 resources and is not yet ready to run
     *         jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BOOTSTRAPPING</code>—EC2 instances and other resources have been provisioned and the bootstrap
     *         actions specified for the instances are underway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>—EC2 instances and other resources are running. They are either executing jobs or
     *         waiting to execute jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESIZING</code>—A resize operation is underway. EC2 instances are either being added or removed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUSPENDED</code>—A resize operation could not complete. Existing EC2 instances are running, but
     *         instances can't be added or removed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TERMINATING</code>—The instance fleet is terminating EC2 instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TERMINATED</code>—The instance fleet is no longer active, and all EC2 instances have been
     *         terminated.
     *         </p>
     *         </li>
     * @see InstanceFleetState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Provides status change reason details for the instance fleet.
     * </p>
     * 
     * @return Provides status change reason details for the instance fleet.
     */
    public final InstanceFleetStateChangeReason stateChangeReason() {
        return stateChangeReason;
    }

    /**
     * <p>
     * Provides historical timestamps for the instance fleet, including the time of creation, the time it became ready
     * to run jobs, and the time of termination.
     * </p>
     * 
     * @return Provides historical timestamps for the instance fleet, including the time of creation, the time it became
     *         ready to run jobs, and the time of termination.
     */
    public final InstanceFleetTimeline timeline() {
        return timeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(timeline());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleetStatus)) {
            return false;
        }
        InstanceFleetStatus other = (InstanceFleetStatus) obj;
        return Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateChangeReason(), other.stateChangeReason()) && Objects.equals(timeline(), other.timeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceFleetStatus").add("State", stateAsString())
                .add("StateChangeReason", stateChangeReason()).add("Timeline", timeline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateChangeReason":
            return Optional.ofNullable(clazz.cast(stateChangeReason()));
        case "Timeline":
            return Optional.ofNullable(clazz.cast(timeline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceFleetStatus, T> g) {
        return obj -> g.apply((InstanceFleetStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceFleetStatus> {
        /**
         * <p>
         * A code representing the instance fleet status.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PROVISIONING</code>—The instance fleet is provisioning EC2 resources and is not yet ready to run jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BOOTSTRAPPING</code>—EC2 instances and other resources have been provisioned and the bootstrap actions
         * specified for the instances are underway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>—EC2 instances and other resources are running. They are either executing jobs or waiting
         * to execute jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESIZING</code>—A resize operation is underway. EC2 instances are either being added or removed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUSPENDED</code>—A resize operation could not complete. Existing EC2 instances are running, but
         * instances can't be added or removed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TERMINATING</code>—The instance fleet is terminating EC2 instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TERMINATED</code>—The instance fleet is no longer active, and all EC2 instances have been terminated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        A code representing the instance fleet status.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PROVISIONING</code>—The instance fleet is provisioning EC2 resources and is not yet ready to run
         *        jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BOOTSTRAPPING</code>—EC2 instances and other resources have been provisioned and the bootstrap
         *        actions specified for the instances are underway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>—EC2 instances and other resources are running. They are either executing jobs or
         *        waiting to execute jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESIZING</code>—A resize operation is underway. EC2 instances are either being added or removed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUSPENDED</code>—A resize operation could not complete. Existing EC2 instances are running, but
         *        instances can't be added or removed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TERMINATING</code>—The instance fleet is terminating EC2 instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TERMINATED</code>—The instance fleet is no longer active, and all EC2 instances have been
         *        terminated.
         *        </p>
         *        </li>
         * @see InstanceFleetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceFleetState
         */
        Builder state(String state);

        /**
         * <p>
         * A code representing the instance fleet status.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PROVISIONING</code>—The instance fleet is provisioning EC2 resources and is not yet ready to run jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BOOTSTRAPPING</code>—EC2 instances and other resources have been provisioned and the bootstrap actions
         * specified for the instances are underway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>—EC2 instances and other resources are running. They are either executing jobs or waiting
         * to execute jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESIZING</code>—A resize operation is underway. EC2 instances are either being added or removed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUSPENDED</code>—A resize operation could not complete. Existing EC2 instances are running, but
         * instances can't be added or removed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TERMINATING</code>—The instance fleet is terminating EC2 instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TERMINATED</code>—The instance fleet is no longer active, and all EC2 instances have been terminated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        A code representing the instance fleet status.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PROVISIONING</code>—The instance fleet is provisioning EC2 resources and is not yet ready to run
         *        jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BOOTSTRAPPING</code>—EC2 instances and other resources have been provisioned and the bootstrap
         *        actions specified for the instances are underway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>—EC2 instances and other resources are running. They are either executing jobs or
         *        waiting to execute jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESIZING</code>—A resize operation is underway. EC2 instances are either being added or removed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUSPENDED</code>—A resize operation could not complete. Existing EC2 instances are running, but
         *        instances can't be added or removed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TERMINATING</code>—The instance fleet is terminating EC2 instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TERMINATED</code>—The instance fleet is no longer active, and all EC2 instances have been
         *        terminated.
         *        </p>
         *        </li>
         * @see InstanceFleetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceFleetState
         */
        Builder state(InstanceFleetState state);

        /**
         * <p>
         * Provides status change reason details for the instance fleet.
         * </p>
         * 
         * @param stateChangeReason
         *        Provides status change reason details for the instance fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateChangeReason(InstanceFleetStateChangeReason stateChangeReason);

        /**
         * <p>
         * Provides status change reason details for the instance fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceFleetStateChangeReason.Builder} avoiding
         * the need to create one manually via {@link InstanceFleetStateChangeReason#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceFleetStateChangeReason.Builder#build()} is called
         * immediately and its result is passed to {@link #stateChangeReason(InstanceFleetStateChangeReason)}.
         * 
         * @param stateChangeReason
         *        a consumer that will call methods on {@link InstanceFleetStateChangeReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateChangeReason(InstanceFleetStateChangeReason)
         */
        default Builder stateChangeReason(Consumer<InstanceFleetStateChangeReason.Builder> stateChangeReason) {
            return stateChangeReason(InstanceFleetStateChangeReason.builder().applyMutation(stateChangeReason).build());
        }

        /**
         * <p>
         * Provides historical timestamps for the instance fleet, including the time of creation, the time it became
         * ready to run jobs, and the time of termination.
         * </p>
         * 
         * @param timeline
         *        Provides historical timestamps for the instance fleet, including the time of creation, the time it
         *        became ready to run jobs, and the time of termination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeline(InstanceFleetTimeline timeline);

        /**
         * <p>
         * Provides historical timestamps for the instance fleet, including the time of creation, the time it became
         * ready to run jobs, and the time of termination.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceFleetTimeline.Builder} avoiding the need
         * to create one manually via {@link InstanceFleetTimeline#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceFleetTimeline.Builder#build()} is called immediately and
         * its result is passed to {@link #timeline(InstanceFleetTimeline)}.
         * 
         * @param timeline
         *        a consumer that will call methods on {@link InstanceFleetTimeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeline(InstanceFleetTimeline)
         */
        default Builder timeline(Consumer<InstanceFleetTimeline.Builder> timeline) {
            return timeline(InstanceFleetTimeline.builder().applyMutation(timeline).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private InstanceFleetStateChangeReason stateChangeReason;

        private InstanceFleetTimeline timeline;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFleetStatus model) {
            state(model.state);
            stateChangeReason(model.stateChangeReason);
            timeline(model.timeline);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(InstanceFleetState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final InstanceFleetStateChangeReason.Builder getStateChangeReason() {
            return stateChangeReason != null ? stateChangeReason.toBuilder() : null;
        }

        public final void setStateChangeReason(InstanceFleetStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        @Override
        @Transient
        public final Builder stateChangeReason(InstanceFleetStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final InstanceFleetTimeline.Builder getTimeline() {
            return timeline != null ? timeline.toBuilder() : null;
        }

        public final void setTimeline(InstanceFleetTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        @Override
        @Transient
        public final Builder timeline(InstanceFleetTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        @Override
        public InstanceFleetStatus build() {
            return new InstanceFleetStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
