/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Custom policy for requesting termination protection or termination of specific instances when shrinking an instance
 * group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceResizePolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceResizePolicy.Builder, InstanceResizePolicy> {
    private static final SdkField<List<String>> INSTANCES_TO_TERMINATE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstancesToTerminate")
            .getter(getter(InstanceResizePolicy::instancesToTerminate))
            .setter(setter(Builder::instancesToTerminate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesToTerminate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INSTANCES_TO_PROTECT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstancesToProtect")
            .getter(getter(InstanceResizePolicy::instancesToProtect))
            .setter(setter(Builder::instancesToProtect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesToProtect").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> INSTANCE_TERMINATION_TIMEOUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceTerminationTimeout")
            .getter(getter(InstanceResizePolicy::instanceTerminationTimeout))
            .setter(setter(Builder::instanceTerminationTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTerminationTimeout").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_TO_TERMINATE_FIELD,
            INSTANCES_TO_PROTECT_FIELD, INSTANCE_TERMINATION_TIMEOUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> instancesToTerminate;

    private final List<String> instancesToProtect;

    private final Integer instanceTerminationTimeout;

    private InstanceResizePolicy(BuilderImpl builder) {
        this.instancesToTerminate = builder.instancesToTerminate;
        this.instancesToProtect = builder.instancesToProtect;
        this.instanceTerminationTimeout = builder.instanceTerminationTimeout;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstancesToTerminate property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstancesToTerminate() {
        return instancesToTerminate != null && !(instancesToTerminate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specific list of instances to be terminated when shrinking an instance group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstancesToTerminate} method.
     * </p>
     * 
     * @return Specific list of instances to be terminated when shrinking an instance group.
     */
    public final List<String> instancesToTerminate() {
        return instancesToTerminate;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstancesToProtect property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstancesToProtect() {
        return instancesToProtect != null && !(instancesToProtect instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specific list of instances to be protected when shrinking an instance group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstancesToProtect} method.
     * </p>
     * 
     * @return Specific list of instances to be protected when shrinking an instance group.
     */
    public final List<String> instancesToProtect() {
        return instancesToProtect;
    }

    /**
     * <p>
     * Decommissioning timeout override for the specific list of instances to be terminated.
     * </p>
     * 
     * @return Decommissioning timeout override for the specific list of instances to be terminated.
     */
    public final Integer instanceTerminationTimeout() {
        return instanceTerminationTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInstancesToTerminate() ? instancesToTerminate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInstancesToProtect() ? instancesToProtect() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceTerminationTimeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceResizePolicy)) {
            return false;
        }
        InstanceResizePolicy other = (InstanceResizePolicy) obj;
        return hasInstancesToTerminate() == other.hasInstancesToTerminate()
                && Objects.equals(instancesToTerminate(), other.instancesToTerminate())
                && hasInstancesToProtect() == other.hasInstancesToProtect()
                && Objects.equals(instancesToProtect(), other.instancesToProtect())
                && Objects.equals(instanceTerminationTimeout(), other.instanceTerminationTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceResizePolicy")
                .add("InstancesToTerminate", hasInstancesToTerminate() ? instancesToTerminate() : null)
                .add("InstancesToProtect", hasInstancesToProtect() ? instancesToProtect() : null)
                .add("InstanceTerminationTimeout", instanceTerminationTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstancesToTerminate":
            return Optional.ofNullable(clazz.cast(instancesToTerminate()));
        case "InstancesToProtect":
            return Optional.ofNullable(clazz.cast(instancesToProtect()));
        case "InstanceTerminationTimeout":
            return Optional.ofNullable(clazz.cast(instanceTerminationTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceResizePolicy, T> g) {
        return obj -> g.apply((InstanceResizePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceResizePolicy> {
        /**
         * <p>
         * Specific list of instances to be terminated when shrinking an instance group.
         * </p>
         * 
         * @param instancesToTerminate
         *        Specific list of instances to be terminated when shrinking an instance group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesToTerminate(Collection<String> instancesToTerminate);

        /**
         * <p>
         * Specific list of instances to be terminated when shrinking an instance group.
         * </p>
         * 
         * @param instancesToTerminate
         *        Specific list of instances to be terminated when shrinking an instance group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesToTerminate(String... instancesToTerminate);

        /**
         * <p>
         * Specific list of instances to be protected when shrinking an instance group.
         * </p>
         * 
         * @param instancesToProtect
         *        Specific list of instances to be protected when shrinking an instance group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesToProtect(Collection<String> instancesToProtect);

        /**
         * <p>
         * Specific list of instances to be protected when shrinking an instance group.
         * </p>
         * 
         * @param instancesToProtect
         *        Specific list of instances to be protected when shrinking an instance group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesToProtect(String... instancesToProtect);

        /**
         * <p>
         * Decommissioning timeout override for the specific list of instances to be terminated.
         * </p>
         * 
         * @param instanceTerminationTimeout
         *        Decommissioning timeout override for the specific list of instances to be terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTerminationTimeout(Integer instanceTerminationTimeout);
    }

    static final class BuilderImpl implements Builder {
        private List<String> instancesToTerminate = DefaultSdkAutoConstructList.getInstance();

        private List<String> instancesToProtect = DefaultSdkAutoConstructList.getInstance();

        private Integer instanceTerminationTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceResizePolicy model) {
            instancesToTerminate(model.instancesToTerminate);
            instancesToProtect(model.instancesToProtect);
            instanceTerminationTimeout(model.instanceTerminationTimeout);
        }

        public final Collection<String> getInstancesToTerminate() {
            if (instancesToTerminate instanceof SdkAutoConstructList) {
                return null;
            }
            return instancesToTerminate;
        }

        public final void setInstancesToTerminate(Collection<String> instancesToTerminate) {
            this.instancesToTerminate = EC2InstanceIdsListCopier.copy(instancesToTerminate);
        }

        @Override
        @Transient
        public final Builder instancesToTerminate(Collection<String> instancesToTerminate) {
            this.instancesToTerminate = EC2InstanceIdsListCopier.copy(instancesToTerminate);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instancesToTerminate(String... instancesToTerminate) {
            instancesToTerminate(Arrays.asList(instancesToTerminate));
            return this;
        }

        public final Collection<String> getInstancesToProtect() {
            if (instancesToProtect instanceof SdkAutoConstructList) {
                return null;
            }
            return instancesToProtect;
        }

        public final void setInstancesToProtect(Collection<String> instancesToProtect) {
            this.instancesToProtect = EC2InstanceIdsListCopier.copy(instancesToProtect);
        }

        @Override
        @Transient
        public final Builder instancesToProtect(Collection<String> instancesToProtect) {
            this.instancesToProtect = EC2InstanceIdsListCopier.copy(instancesToProtect);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instancesToProtect(String... instancesToProtect) {
            instancesToProtect(Arrays.asList(instancesToProtect));
            return this;
        }

        public final Integer getInstanceTerminationTimeout() {
            return instanceTerminationTimeout;
        }

        public final void setInstanceTerminationTimeout(Integer instanceTerminationTimeout) {
            this.instanceTerminationTimeout = instanceTerminationTimeout;
        }

        @Override
        @Transient
        public final Builder instanceTerminationTimeout(Integer instanceTerminationTimeout) {
            this.instanceTerminationTimeout = instanceTerminationTimeout;
            return this;
        }

        @Override
        public InstanceResizePolicy build() {
            return new InstanceResizePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
