/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This input determines which instances to list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInstancesRequest extends EmrRequest implements
        ToCopyableBuilder<ListInstancesRequest.Builder, ListInstancesRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(ListInstancesRequest::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<String> INSTANCE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceGroupId").getter(getter(ListInstancesRequest::instanceGroupId))
            .setter(setter(Builder::instanceGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupId").build()).build();

    private static final SdkField<List<String>> INSTANCE_GROUP_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstanceGroupTypes")
            .getter(getter(ListInstancesRequest::instanceGroupTypesAsStrings))
            .setter(setter(Builder::instanceGroupTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INSTANCE_FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceFleetId").getter(getter(ListInstancesRequest::instanceFleetId))
            .setter(setter(Builder::instanceFleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFleetId").build()).build();

    private static final SdkField<String> INSTANCE_FLEET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceFleetType").getter(getter(ListInstancesRequest::instanceFleetTypeAsString))
            .setter(setter(Builder::instanceFleetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFleetType").build()).build();

    private static final SdkField<List<String>> INSTANCE_STATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstanceStates")
            .getter(getter(ListInstancesRequest::instanceStatesAsStrings))
            .setter(setter(Builder::instanceStatesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListInstancesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD,
            INSTANCE_GROUP_ID_FIELD, INSTANCE_GROUP_TYPES_FIELD, INSTANCE_FLEET_ID_FIELD, INSTANCE_FLEET_TYPE_FIELD,
            INSTANCE_STATES_FIELD, MARKER_FIELD));

    private final String clusterId;

    private final String instanceGroupId;

    private final List<String> instanceGroupTypes;

    private final String instanceFleetId;

    private final String instanceFleetType;

    private final List<String> instanceStates;

    private final String marker;

    private ListInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.instanceGroupId = builder.instanceGroupId;
        this.instanceGroupTypes = builder.instanceGroupTypes;
        this.instanceFleetId = builder.instanceFleetId;
        this.instanceFleetType = builder.instanceFleetType;
        this.instanceStates = builder.instanceStates;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The identifier of the cluster for which to list the instances.
     * </p>
     * 
     * @return The identifier of the cluster for which to list the instances.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The identifier of the instance group for which to list the instances.
     * </p>
     * 
     * @return The identifier of the instance group for which to list the instances.
     */
    public final String instanceGroupId() {
        return instanceGroupId;
    }

    /**
     * <p>
     * The type of instance group for which to list the instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceGroupTypes} method.
     * </p>
     * 
     * @return The type of instance group for which to list the instances.
     */
    public final List<InstanceGroupType> instanceGroupTypes() {
        return InstanceGroupTypeListCopier.copyStringToEnum(instanceGroupTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceGroupTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceGroupTypes() {
        return instanceGroupTypes != null && !(instanceGroupTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of instance group for which to list the instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceGroupTypes} method.
     * </p>
     * 
     * @return The type of instance group for which to list the instances.
     */
    public final List<String> instanceGroupTypesAsStrings() {
        return instanceGroupTypes;
    }

    /**
     * <p>
     * The unique identifier of the instance fleet.
     * </p>
     * 
     * @return The unique identifier of the instance fleet.
     */
    public final String instanceFleetId() {
        return instanceFleetId;
    }

    /**
     * <p>
     * The node type of the instance fleet. For example MASTER, CORE, or TASK.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceFleetType}
     * will return {@link InstanceFleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceFleetTypeAsString}.
     * </p>
     * 
     * @return The node type of the instance fleet. For example MASTER, CORE, or TASK.
     * @see InstanceFleetType
     */
    public final InstanceFleetType instanceFleetType() {
        return InstanceFleetType.fromValue(instanceFleetType);
    }

    /**
     * <p>
     * The node type of the instance fleet. For example MASTER, CORE, or TASK.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceFleetType}
     * will return {@link InstanceFleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceFleetTypeAsString}.
     * </p>
     * 
     * @return The node type of the instance fleet. For example MASTER, CORE, or TASK.
     * @see InstanceFleetType
     */
    public final String instanceFleetTypeAsString() {
        return instanceFleetType;
    }

    /**
     * <p>
     * A list of instance states that will filter the instances returned with this request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceStates} method.
     * </p>
     * 
     * @return A list of instance states that will filter the instances returned with this request.
     */
    public final List<InstanceState> instanceStates() {
        return InstanceStateListCopier.copyStringToEnum(instanceStates);
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceStates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceStates() {
        return instanceStates != null && !(instanceStates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of instance states that will filter the instances returned with this request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceStates} method.
     * </p>
     * 
     * @return A list of instance states that will filter the instances returned with this request.
     */
    public final List<String> instanceStatesAsStrings() {
        return instanceStates;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceGroupTypes() ? instanceGroupTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceFleetId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceFleetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceStates() ? instanceStatesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesRequest)) {
            return false;
        }
        ListInstancesRequest other = (ListInstancesRequest) obj;
        return Objects.equals(clusterId(), other.clusterId()) && Objects.equals(instanceGroupId(), other.instanceGroupId())
                && hasInstanceGroupTypes() == other.hasInstanceGroupTypes()
                && Objects.equals(instanceGroupTypesAsStrings(), other.instanceGroupTypesAsStrings())
                && Objects.equals(instanceFleetId(), other.instanceFleetId())
                && Objects.equals(instanceFleetTypeAsString(), other.instanceFleetTypeAsString())
                && hasInstanceStates() == other.hasInstanceStates()
                && Objects.equals(instanceStatesAsStrings(), other.instanceStatesAsStrings())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInstancesRequest").add("ClusterId", clusterId()).add("InstanceGroupId", instanceGroupId())
                .add("InstanceGroupTypes", hasInstanceGroupTypes() ? instanceGroupTypesAsStrings() : null)
                .add("InstanceFleetId", instanceFleetId()).add("InstanceFleetType", instanceFleetTypeAsString())
                .add("InstanceStates", hasInstanceStates() ? instanceStatesAsStrings() : null).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "InstanceGroupId":
            return Optional.ofNullable(clazz.cast(instanceGroupId()));
        case "InstanceGroupTypes":
            return Optional.ofNullable(clazz.cast(instanceGroupTypesAsStrings()));
        case "InstanceFleetId":
            return Optional.ofNullable(clazz.cast(instanceFleetId()));
        case "InstanceFleetType":
            return Optional.ofNullable(clazz.cast(instanceFleetTypeAsString()));
        case "InstanceStates":
            return Optional.ofNullable(clazz.cast(instanceStatesAsStrings()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInstancesRequest, T> g) {
        return obj -> g.apply((ListInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListInstancesRequest> {
        /**
         * <p>
         * The identifier of the cluster for which to list the instances.
         * </p>
         * 
         * @param clusterId
         *        The identifier of the cluster for which to list the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The identifier of the instance group for which to list the instances.
         * </p>
         * 
         * @param instanceGroupId
         *        The identifier of the instance group for which to list the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupId(String instanceGroupId);

        /**
         * <p>
         * The type of instance group for which to list the instances.
         * </p>
         * 
         * @param instanceGroupTypes
         *        The type of instance group for which to list the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupTypesWithStrings(Collection<String> instanceGroupTypes);

        /**
         * <p>
         * The type of instance group for which to list the instances.
         * </p>
         * 
         * @param instanceGroupTypes
         *        The type of instance group for which to list the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupTypesWithStrings(String... instanceGroupTypes);

        /**
         * <p>
         * The type of instance group for which to list the instances.
         * </p>
         * 
         * @param instanceGroupTypes
         *        The type of instance group for which to list the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupTypes(Collection<InstanceGroupType> instanceGroupTypes);

        /**
         * <p>
         * The type of instance group for which to list the instances.
         * </p>
         * 
         * @param instanceGroupTypes
         *        The type of instance group for which to list the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupTypes(InstanceGroupType... instanceGroupTypes);

        /**
         * <p>
         * The unique identifier of the instance fleet.
         * </p>
         * 
         * @param instanceFleetId
         *        The unique identifier of the instance fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFleetId(String instanceFleetId);

        /**
         * <p>
         * The node type of the instance fleet. For example MASTER, CORE, or TASK.
         * </p>
         * 
         * @param instanceFleetType
         *        The node type of the instance fleet. For example MASTER, CORE, or TASK.
         * @see InstanceFleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceFleetType
         */
        Builder instanceFleetType(String instanceFleetType);

        /**
         * <p>
         * The node type of the instance fleet. For example MASTER, CORE, or TASK.
         * </p>
         * 
         * @param instanceFleetType
         *        The node type of the instance fleet. For example MASTER, CORE, or TASK.
         * @see InstanceFleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceFleetType
         */
        Builder instanceFleetType(InstanceFleetType instanceFleetType);

        /**
         * <p>
         * A list of instance states that will filter the instances returned with this request.
         * </p>
         * 
         * @param instanceStates
         *        A list of instance states that will filter the instances returned with this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStatesWithStrings(Collection<String> instanceStates);

        /**
         * <p>
         * A list of instance states that will filter the instances returned with this request.
         * </p>
         * 
         * @param instanceStates
         *        A list of instance states that will filter the instances returned with this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStatesWithStrings(String... instanceStates);

        /**
         * <p>
         * A list of instance states that will filter the instances returned with this request.
         * </p>
         * 
         * @param instanceStates
         *        A list of instance states that will filter the instances returned with this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStates(Collection<InstanceState> instanceStates);

        /**
         * <p>
         * A list of instance states that will filter the instances returned with this request.
         * </p>
         * 
         * @param instanceStates
         *        A list of instance states that will filter the instances returned with this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStates(InstanceState... instanceStates);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param marker
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String clusterId;

        private String instanceGroupId;

        private List<String> instanceGroupTypes = DefaultSdkAutoConstructList.getInstance();

        private String instanceFleetId;

        private String instanceFleetType;

        private List<String> instanceStates = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstancesRequest model) {
            super(model);
            clusterId(model.clusterId);
            instanceGroupId(model.instanceGroupId);
            instanceGroupTypesWithStrings(model.instanceGroupTypes);
            instanceFleetId(model.instanceFleetId);
            instanceFleetType(model.instanceFleetType);
            instanceStatesWithStrings(model.instanceStates);
            marker(model.marker);
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        @Transient
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getInstanceGroupId() {
            return instanceGroupId;
        }

        public final void setInstanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
        }

        @Override
        @Transient
        public final Builder instanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
            return this;
        }

        public final Collection<String> getInstanceGroupTypes() {
            if (instanceGroupTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceGroupTypes;
        }

        public final void setInstanceGroupTypes(Collection<String> instanceGroupTypes) {
            this.instanceGroupTypes = InstanceGroupTypeListCopier.copy(instanceGroupTypes);
        }

        @Override
        @Transient
        public final Builder instanceGroupTypesWithStrings(Collection<String> instanceGroupTypes) {
            this.instanceGroupTypes = InstanceGroupTypeListCopier.copy(instanceGroupTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceGroupTypesWithStrings(String... instanceGroupTypes) {
            instanceGroupTypesWithStrings(Arrays.asList(instanceGroupTypes));
            return this;
        }

        @Override
        @Transient
        public final Builder instanceGroupTypes(Collection<InstanceGroupType> instanceGroupTypes) {
            this.instanceGroupTypes = InstanceGroupTypeListCopier.copyEnumToString(instanceGroupTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceGroupTypes(InstanceGroupType... instanceGroupTypes) {
            instanceGroupTypes(Arrays.asList(instanceGroupTypes));
            return this;
        }

        public final String getInstanceFleetId() {
            return instanceFleetId;
        }

        public final void setInstanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
        }

        @Override
        @Transient
        public final Builder instanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
            return this;
        }

        public final String getInstanceFleetType() {
            return instanceFleetType;
        }

        public final void setInstanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
        }

        @Override
        @Transient
        public final Builder instanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
            return this;
        }

        @Override
        @Transient
        public final Builder instanceFleetType(InstanceFleetType instanceFleetType) {
            this.instanceFleetType(instanceFleetType == null ? null : instanceFleetType.toString());
            return this;
        }

        public final Collection<String> getInstanceStates() {
            if (instanceStates instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceStates;
        }

        public final void setInstanceStates(Collection<String> instanceStates) {
            this.instanceStates = InstanceStateListCopier.copy(instanceStates);
        }

        @Override
        @Transient
        public final Builder instanceStatesWithStrings(Collection<String> instanceStates) {
            this.instanceStates = InstanceStateListCopier.copy(instanceStates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceStatesWithStrings(String... instanceStates) {
            instanceStatesWithStrings(Arrays.asList(instanceStates));
            return this;
        }

        @Override
        @Transient
        public final Builder instanceStates(Collection<InstanceState> instanceStates) {
            this.instanceStates = InstanceStateListCopier.copyEnumToString(instanceStates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceStates(InstanceState... instanceStates) {
            instanceStates(Arrays.asList(instanceStates));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInstancesRequest build() {
            return new ListInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
